set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6900066';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '43',
      '44',
      31.788685,
      9,
      '3234202',
      NULL,
      0.332307,
      2,
      NULL,
      '1420',
      0,
      NULL,
      NULL,
      NULL,
      ' 1-25-1992',
      92,
      NULL,
      NULL,
      1,
      1.101406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.849184,
      ' 9- 5-1987',
      NULL,
      ' 5- 9-1993',
      3,
      0,
      NULL,
      0.526075,
      NULL,
      3.897181,
      3,
      0,
      0.708118,
      NULL,
      9.458730,
      18.143703,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1.528858,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      1.334866,
      NULL,
      60.944250,
      7,
      NULL,
      3,
      0.719712,
      3.564611,
      1.393982,
      0.384727,
      NULL,
      NULL,
      1.100879,
      1.184100,
      0,
      4.300717,
      1.220821,
      0.737130,
      3.885706,
      2,
      0.795762,
      3.783828,
      NULL,
      0.746735,
      0.491757,
      NULL,
      NULL,
      0.138278,
      NULL,
      NULL,
      3.410734,
      0.881530,
      7,
      2,
      0.000699,
      3.388712,
      0,
      3.039230,
      2.819143,
      2,
      1.258603,
      0.390971,
      NULL,
      3.837470,
      NULL,
      0,
      2,
      0.553839,
      2,
      NULL,
      1.508871,
      1,
      9,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.682277,
      0.949675,
      0.411375,
      0.763689,
      0.098078,
      1,
      NULL,
      0,
      1,
      1.565110,
      0.124487,
      1,
      NULL,
      1.716328,
      1.228032,
      1,
      0,
      0,
      NULL,
      0,
      0.325265,
      0.422258,
      0.242797,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      5,
      1,
      0,
      3.967499,
      NULL,
      6,
      1.327038,
      6,
      2.312778,
      2,
      0.637392,
      2,
      3.366094,
      NULL,
      1.633988,
      1,
      3.578021,
      3,
      '10-10-1986',
      NULL,
      ' 4- 4-1992',
      1800.219678,
      2.773191,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.813564,
      NULL,
      1,
      0.732825,
      NULL,
      0.121891,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.190236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.779527,
      2,
      0.771196,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.184070,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      1.816486,
      1,
      NULL,
      3.535272,
      10578.457636,
      1.197007,
      NULL,
      NULL,
      107.569839,
      109,
      3.259567,
      1,
      0.943099,
      0,
      0,
      1.848349,
      NULL,
      1.174156,
      NULL,
      3.913788,
      7,
      1.656216,
      NULL,
      1.705701,
      3,
      2.902769,
      2,
      NULL,
      1,
      2.930740,
      0.124974,
      0,
      0.355287,
      NULL,
      0,
      0,
      0.633467,
      0.708763,
      1,
      0,
      0.946773,
      0,
      0,
      7.352241,
      3.382159,
      NULL,
      2.770068,
      0.010192,
      NULL,
      2,
      NULL,
      0.652799,
      0.652721,
      1,
      5.831141,
      0,
      0,
      62.379219,
      NULL,
      NULL,
      56,
      1,
      4,
      0,
      '10313',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      1.945082,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      9.814738,
      NULL,
      3.607432,
      29.574429,
      NULL,
      NULL,
      NULL,
      0.817786,
      0,
      NULL,
      2.852352,
      0.936713,
      1,
      NULL,
      1.504918,
      0.529640,
      NULL,
      0.684418,
      1.297250,
      3.468828,
      NULL,
      NULL,
      NULL,
      0,
      3.857332,
      1.896284,
      NULL,
      1,
      1,
      1.009305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.233493,
      1,
      0.002271,
      NULL,
      0.618317,
      0.176034,
      NULL,
      0,
      4,
      7,
      NULL,
      0.071282,
      NULL,
      NULL,
      NULL,
      0,
      0.590257,
      1.418768,
      2.252144,
      3.699730,
      2.992790,
      0,
      2.716858,
      2,
      3.622201,
      NULL,
      0,
      2,
      2.611405,
      3.875799,
      2.362179,
      1,
      NULL,
      1,
      NULL,
      3,
      2.396722,
      2,
      1.539931,
      1.167079,
      NULL,
      0.508276,
      2.867677,
      NULL,
      0.736095,
      1.578043,
      0,
      0,
      1.222472,
      1.968387,
      3.233973,
      2,
      2,
      10,
      5.418793,
      NULL,
      1.296844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.360926,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.004823,
      NULL,
      0.444468,
      NULL,
      NULL,
      2,
      NULL,
      1.121094,
      NULL,
      0.979362,
      1,
      NULL,
      NULL,
      1.151177,
      1,
      NULL,
      NULL,
      2.594908,
      0.158455,
      1,
      1,
      NULL,
      NULL,
      0.261088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.134138,
      0.476292,
      NULL,
      NULL,
      1.243461,
      NULL,
      1.531071,
      1,
      0,
      0,
      0.275958,
      0,
      0,
      4.029944,
      3,
      NULL,
      NULL,
      NULL,
      2.582129,
      0.447583,
      0,
      0,
      0,
      0.165985,
      0.092986,
      NULL,
      0,
      9.528795,
      NULL,
      4.644116,
      2.307245,
      NULL,
      3,
      3,
      NULL,
      3.881266,
      2.963918,
      3.182013,
      1.635430,
      1,
      3,
      2,
      NULL,
      7.205704,
      0,
      4.119282,
      1.514852,
      0.752424,
      2,
      1.946176,
      0,
      1.911962,
      0,
      1,
      0.391203,
      1,
      3.266064,
      NULL,
      NULL,
      0.246645,
      NULL,
      NULL,
      213,
      NULL,
      NULL,
      1.333442,
      NULL,
      NULL,
      1.532721,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.645944,
      NULL,
      NULL,
      0.738756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.515088,
      NULL,
      NULL,
      1.715755,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1.521538,
      2.076795,
      NULL,
      0.663082,
      2.438481,
      2,
      3.678481,
      NULL,
      5,
      1.375693,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.756584,
      NULL,
      2.402201,
      NULL,
      0.004040,
      NULL,
      0,
      NULL,
      1,
      0.416895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.806128,
      1.905937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972777,
      1.066875,
      NULL,
      NULL,
      0.529717,
      1.258771,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.554113,
      0,
      1.276591,
      NULL,
      3.263984,
      0,
      NULL,
      NULL,
      1.059882,
      1.135236,
      0,
      NULL,
      0.703330,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.497427,
      NULL,
      0,
      0,
      1,
      NULL,
      3.643528,
      2.458204,
      0.112771,
      NULL,
      13,
      8.319954,
      1,
      NULL,
      15.439648,
      0.514055,
      39,
      7.042306,
      2,
      1.705699,
      369.657854,
      19.964058,
      0,
      91,
      50,
      0.616306,
      NULL,
      NULL,
      2,
      183,
      NULL,
      0,
      NULL,
      23.997578,
      0,
      NULL,
      NULL,
      3,
      35,
      0.235876,
      190,
      18.280258,
      1.951785,
      0.180537,
      0,
      0.674308,
      1.917292,
      0.229363,
      0,
      0,
      1.129396,
      1,
      NULL,
      0,
      1.694521,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.052740,
      0,
      NULL,
      3,
      0,
      0.535334,
      4.883055,
      1.840343,
      2.482025,
      1.826475,
      0.120868,
      1.113412,
      NULL,
      1.167873,
      1,
      NULL,
      0,
      0.456501,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      1.272277,
      0.308760,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      1.509245,
      1.642451,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.602311,
      NULL,
      NULL,
      0.558811,
      1.249786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.756419,
      NULL,
      1,
      NULL,
      0.058457,
      NULL,
      1.682516,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.578280,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.536439,
      NULL,
      1.606771,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4.618688,
      5,
      1,
      NULL,
      NULL,
      0.217115,
      NULL,
      1,
      3.604707,
      NULL,
      '31330',
      NULL,
      '',
      0.136711,
      '',
      '',
      '',
      3,
      '32133',
      '',
      NULL);
commit;
end;
/


