set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '1040101',
      1.561806,
      NULL,
      NULL,
      NULL,
      '4033',
      2.741910,
      1.774503,
      NULL,
      21,
      NULL,
      24.092887,
      NULL,
      0,
      3.650871,
      0.254177,
      ' 6- 0-1989',
      13.182464,
      NULL,
      257.612389,
      NULL,
      2,
      ' 1-10-1982',
      '10- 4-1991',
      ' 0-25-1986',
      NULL,
      3.529785,
      3,
      0,
      1,
      0.276923,
      2.248996,
      0,
      NULL,
      1,
      8.687573,
      19.272549,
      8,
      130,
      191,
      11,
      NULL,
      8,
      6,
      6.283675,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.672049,
      9.626619,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.350231,
      0.059616,
      1.837142,
      2.214689,
      2.010454,
      6.258627,
      7,
      3.644267,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      6,
      3.815039,
      1,
      1.254731,
      NULL,
      2.558076,
      1.922052,
      NULL,
      3,
      0,
      3,
      NULL,
      1.961186,
      1.754522,
      2,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      4.215157,
      1,
      NULL,
      NULL,
      NULL,
      1.812764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      3,
      0.471810,
      1,
      0,
      NULL,
      6.575148,
      NULL,
      5,
      2,
      1.818338,
      NULL,
      1.575961,
      1,
      NULL,
      1.955965,
      5,
      1.125258,
      2.304312,
      4,
      1.413119,
      2,
      6.549264,
      0.710059,
      8.605189,
      4,
      NULL,
      4,
      5.849464,
      3.217533,
      5.992623,
      0,
      NULL,
      9,
      6.956965,
      9,
      2,
      5,
      NULL,
      3.548929,
      0.293690,
      1.112143,
      1.838201,
      ' 9-23-1991',
      12,
      '10-19-1998',
      11,
      2.651172,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      NULL,
      3.995519,
      4.157221,
      2.617389,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665447,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      10,
      7.815842,
      0.783455,
      1.390756,
      6,
      1,
      NULL,
      NULL,
      NULL,
      0.872936,
      5.724651,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.940068,
      2.740967,
      1,
      0,
      1,
      2,
      15,
      NULL,
      1.597342,
      NULL,
      NULL,
      NULL,
      NULL,
      1.189336,
      3,
      3.863208,
      0,
      1,
      3,
      3,
      1,
      1,
      0,
      3.641843,
      2.395126,
      NULL,
      8,
      NULL,
      13.300802,
      0.416646,
      NULL,
      8,
      NULL,
      1,
      0.107267,
      0.395486,
      0.735434,
      1.448739,
      0,
      1,
      0.510617,
      0.317639,
      3.951706,
      NULL,
      1.971382,
      NULL,
      7.035998,
      4.482223,
      9,
      NULL,
      4.639961,
      0.822539,
      5.249084,
      3.362710,
      NULL,
      0.773987,
      31.459581,
      NULL,
      2.979573,
      NULL,
      NULL,
      NULL,
      67.745372,
      NULL,
      0,
      0,
      '44322',
      '',
      '',
      1.805043,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.736065,
      2.961757,
      3.168700,
      1885.593775,
      580,
      NULL,
      NULL,
      NULL,
      1,
      1.384427,
      NULL,
      0.644222,
      NULL,
      NULL,
      0.299669,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320333,
      3415.425747,
      490.053672,
      1,
      NULL,
      1.614432,
      0.366173,
      0,
      0.071655,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      1.015663,
      0.066463,
      0.363103,
      1.542919,
      0.003891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.130009,
      0.705459,
      1.895863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420729,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278639,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390504,
      0.657447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392587,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.327923,
      0.873798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.600330,
      NULL,
      2.552960,
      1.777164,
      3,
      7.765362,
      0,
      0.570238,
      10.627789,
      NULL,
      2,
      1.783133,
      0.306744,
      1,
      NULL,
      NULL,
      0.907255,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.934524,
      NULL,
      0.059428,
      0,
      NULL,
      0.080867,
      3.221564,
      NULL,
      0.435316,
      1,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      NULL,
      3.250300,
      2.680682,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.865847,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.370837,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0.026640,
      NULL,
      1.907301,
      NULL,
      NULL,
      NULL,
      1.475929,
      NULL,
      3.715635,
      NULL,
      3,
      NULL,
      188,
      0.881967,
      NULL,
      0.447986,
      3.263580,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.119934,
      NULL,
      0.544076,
      NULL,
      1.234002,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      43.314505,
      0,
      NULL,
      0,
      NULL,
      1.141715,
      NULL,
      0.160166,
      NULL,
      1,
      6,
      8,
      2.920389,
      0,
      0,
      83.137432,
      102,
      3,
      1.224083,
      3.902954,
      '24444',
      '',
      '',
      0.283073,
      '',
      '',
      '',
      0.641588,
      '',
      NULL,
      '');
commit;
end;
/


