set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8335020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '2240212',
      3,
      1,
      2,
      2,
      '4210',
      3.352537,
      1.170974,
      NULL,
      NULL,
      ' 8-14-1979',
      NULL,
      NULL,
      3.480409,
      1.495828,
      0.113576,
      ' 8-26-1992',
      42,
      NULL,
      262.814437,
      NULL,
      NULL,
      ' 5-11-1992',
      ' 1-12-1995',
      ' 1-28-1990',
      1,
      0.989391,
      1.130634,
      1,
      0.707280,
      0.856746,
      3,
      0.197824,
      1,
      61,
      5.556348,
      15.331389,
      7.197858,
      8.877013,
      NULL,
      6,
      2,
      5.913248,
      NULL,
      7.751825,
      NULL,
      1,
      0.272896,
      0.061841,
      1.922929,
      1,
      0.245955,
      NULL,
      NULL,
      0,
      30.490402,
      NULL,
      3.305783,
      NULL,
      0,
      8.724748,
      0,
      5.302650,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      0.291245,
      0.016244,
      1,
      NULL,
      NULL,
      5,
      1.878857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.070763,
      3,
      7,
      0.668468,
      0,
      0,
      3,
      0,
      NULL,
      0.527193,
      0.421141,
      2,
      1,
      NULL,
      0,
      1,
      0.077612,
      0.922963,
      1.961833,
      NULL,
      3,
      5.223028,
      NULL,
      8,
      NULL,
      3.411188,
      5,
      4,
      1.128208,
      NULL,
      NULL,
      NULL,
      3.821420,
      1,
      1,
      0.416802,
      2,
      3,
      NULL,
      0,
      0.098200,
      1.405249,
      1.888261,
      NULL,
      0.460708,
      1,
      0,
      0,
      0,
      NULL,
      0.718385,
      1.199548,
      1.221612,
      NULL,
      1.137709,
      6,
      5.172687,
      0,
      2,
      0,
      0.474333,
      5.220154,
      3,
      8.104147,
      1.130228,
      2,
      NULL,
      9,
      1.533529,
      4,
      5,
      NULL,
      7,
      NULL,
      5.730575,
      5.903710,
      8,
      1,
      7.366766,
      7,
      2,
      1.816342,
      ' 3- 2-1974',
      521.744954,
      '10-20-1992',
      491,
      2,
      0.102745,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394310,
      1,
      NULL,
      0,
      0.679518,
      0,
      1.694473,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      543.706102,
      0.551183,
      0.736269,
      NULL,
      0,
      NULL,
      1.892992,
      0,
      NULL,
      7,
      1.752902,
      NULL,
      2.580786,
      0.322139,
      2.912285,
      4.564902,
      5,
      0.598038,
      NULL,
      7,
      NULL,
      1.142656,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      3,
      3,
      ' 4- 4-1987',
      154,
      ' 2-10-1984',
      390.946120,
      2,
      0.027132,
      0,
      3,
      3.574520,
      1,
      0,
      0.249286,
      0.451170,
      0,
      1.033398,
      13.287568,
      3.915085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.258704,
      3.246744,
      1,
      0.539992,
      3,
      0,
      0.869011,
      2,
      NULL,
      1,
      NULL,
      0.011369,
      NULL,
      NULL,
      1,
      3,
      1.616816,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.552411,
      NULL,
      1.682948,
      0.318039,
      1,
      1.413413,
      1.066414,
      1.973444,
      0,
      5.488184,
      NULL,
      2,
      4,
      0.218347,
      NULL,
      1,
      1,
      4.393898,
      0,
      2,
      NULL,
      15,
      3.728292,
      NULL,
      NULL,
      20.391323,
      29.504067,
      NULL,
      NULL,
      0,
      NULL,
      '10021',
      '',
      '',
      1.221396,
      '',
      NULL,
      '',
      1.742776,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      2,
      3.889478,
      6,
      NULL,
      0,
      3.969664,
      NULL,
      3.005542,
      NULL,
      1,
      NULL,
      NULL,
      1.296822,
      0,
      NULL,
      0.457454,
      1.628770,
      0,
      3,
      1,
      NULL,
      2.674386,
      0,
      0,
      1.518372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.856087,
      0.995095,
      1.335689,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.744458,
      6.219505,
      1.964259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.361756,
      3.356538,
      1,
      2,
      3,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.285222,
      1,
      NULL,
      NULL,
      3.180336,
      3,
      0.547000,
      3,
      1,
      3,
      0.091446,
      0.566120,
      NULL,
      1,
      2,
      2.165430,
      3.138966,
      2,
      1.141184,
      1.164821,
      NULL,
      NULL,
      3,
      NULL,
      1.852523,
      NULL,
      9.799609,
      9.062606,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.697165,
      1,
      2.519826,
      1.185513,
      0,
      NULL,
      NULL,
      0.964925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245308,
      0.035833,
      2.189282,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.104374,
      NULL,
      NULL,
      0.747022,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.596132,
      NULL,
      2.188283,
      1.677207,
      5.888482,
      2,
      5.381634,
      2,
      0.736842,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.085698,
      NULL,
      3,
      3,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      3.305742,
      2,
      NULL,
      3.174637,
      1,
      1,
      NULL,
      3.714816,
      0.787915,
      0,
      NULL,
      2.108897,
      11,
      1.915578,
      3.782452,
      8,
      NULL,
      1.212865,
      3.606130,
      4.264155,
      2,
      0.447606,
      0,
      0,
      0.700349,
      1.201054,
      0.476009,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.652330,
      NULL,
      NULL,
      1.624506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396982,
      NULL,
      NULL,
      3.401131,
      NULL,
      NULL,
      0.617117,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.903003,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      8.742292,
      3,
      1.559943,
      NULL,
      164,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.447634,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0.748771,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082716,
      NULL,
      NULL,
      1.327692,
      1,
      0.915777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.607093,
      NULL,
      NULL,
      1.076231,
      1,
      1,
      NULL,
      NULL,
      2,
      0.551247,
      NULL,
      1.537071,
      1.209670,
      NULL,
      NULL,
      1,
      3.284917,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      15,
      NULL,
      0.971569,
      NULL,
      1,
      3.029952,
      1.719605,
      4,
      8.263798,
      1.732376,
      2,
      72.713988,
      63.571990,
      2,
      25,
      6,
      3,
      8.187807,
      NULL,
      2.420509,
      3.538528,
      0.335602,
      0,
      5,
      10,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      204.573094,
      0.917850,
      1.837803,
      0.817060,
      NULL,
      0,
      0,
      1.492036,
      1.631827,
      0,
      1,
      NULL,
      0.193755,
      NULL,
      NULL,
      0.960117,
      0,
      0.879829,
      0.767972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.314629,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129848,
      NULL,
      NULL,
      0.672630,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.454494,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573386,
      NULL,
      NULL,
      1.547804,
      NULL,
      1.562078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.779858,
      1.848983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.726739,
      4.237087,
      2,
      NULL,
      3,
      0,
      2.582070,
      4,
      NULL,
      3.628699,
      2,
      1.159446,
      1,
      0.985014,
      NULL,
      1.693436,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1.657768,
      NULL,
      NULL,
      2.224568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423923,
      1,
      NULL,
      1.120497,
      1.467264,
      NULL,
      1,
      1.286430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.567928,
      NULL,
      0,
      NULL,
      3.839526,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.427531,
      NULL,
      2,
      NULL,
      1.150543,
      NULL,
      0.133979,
      NULL,
      3.244721,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      21.553216,
      1,
      NULL,
      0.985019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.909986,
      0.550469,
      3,
      10.246011,
      40,
      0.845110,
      1.487864,
      3.763116,
      '24341',
      '',
      '',
      0.812009,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


