set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9813353';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1,
      0,
      2,
      1,
      2.041368,
      0,
      3,
      '442',
      '22041103',
      68.456509,
      42.985243,
      '0420201',
      3,
      NULL,
      NULL,
      0,
      '3421',
      1.981120,
      0.385843,
      NULL,
      NULL,
      NULL,
      151.737815,
      NULL,
      NULL,
      NULL,
      0.920314,
      '11-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      2.939349,
      NULL,
      NULL,
      ' 3- 2-2003',
      0.319599,
      0,
      3.886621,
      3.932028,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11.708667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.597521,
      0.808766,
      NULL,
      NULL,
      3.431808,
      0,
      0.198412,
      0.921803,
      NULL,
      4,
      NULL,
      NULL,
      4.312834,
      1,
      NULL,
      0,
      NULL,
      0.477567,
      1.646960,
      1,
      0,
      NULL,
      1.539573,
      1.646059,
      4.826697,
      NULL,
      0.587096,
      0.435969,
      1,
      1.082474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.250305,
      1.345424,
      0.031157,
      2,
      0,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      1.256469,
      2.791355,
      NULL,
      1.817625,
      NULL,
      1.415051,
      1,
      0.288739,
      4,
      1.756220,
      2.559371,
      3.379211,
      1,
      NULL,
      NULL,
      0.001270,
      NULL,
      NULL,
      0.540427,
      1,
      6,
      0.531492,
      2.646039,
      1,
      1.846301,
      1,
      1.793807,
      1,
      0.138190,
      1,
      1,
      0.820705,
      1,
      0.418830,
      0.069030,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.243746,
      NULL,
      1.413469,
      0,
      NULL,
      5.496853,
      9,
      1,
      6.661234,
      1,
      1.071764,
      4.527911,
      0,
      1,
      0.313676,
      NULL,
      0.947618,
      0,
      ' 0-11-1999',
      268.845054,
      ' 9- 3-1976',
      NULL,
      1,
      1,
      1,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641009,
      1,
      0,
      1.495834,
      1,
      0.170720,
      0,
      0.843150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750809,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850351,
      0,
      NULL,
      NULL,
      1.307666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444557,
      1,
      1.017077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949474,
      0,
      1,
      0.139642,
      NULL,
      0.025716,
      NULL,
      NULL,
      0.529325,
      0.142205,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      3,
      0.096913,
      NULL,
      2.277634,
      NULL,
      NULL,
      NULL,
      3,
      3.256476,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.483388,
      NULL,
      0,
      1.732891,
      0,
      1,
      0.833383,
      0,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      6.910667,
      0.873265,
      5.624457,
      1,
      3.559816,
      2.121289,
      5,
      0,
      3,
      0,
      6.054313,
      2,
      0.889459,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2,
      '23302',
      '01033',
      '',
      0.398411,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      1.377300,
      NULL,
      2,
      3,
      15,
      7.234066,
      63.951710,
      NULL,
      3,
      2,
      2.963051,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.756135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713312,
      0.370756,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.472603,
      3,
      0.584939,
      0.364270,
      0.958312,
      NULL,
      NULL,
      NULL,
      0.427897,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      NULL,
      1,
      0.642956,
      NULL,
      NULL,
      1,
      0.878524,
      1.664438,
      NULL,
      NULL,
      0.628971,
      NULL,
      0.919301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      1.765186,
      1.167828,
      NULL,
      NULL,
      NULL,
      0.190639,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.529565,
      NULL,
      NULL,
      NULL,
      3.936441,
      3,
      0,
      NULL,
      NULL,
      8.641069,
      7,
      3.849197,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969254,
      NULL,
      NULL,
      0.596572,
      NULL,
      NULL,
      1.002952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.807267,
      NULL,
      NULL,
      1.106628,
      1,
      0.347643,
      1,
      1,
      3,
      0.536283,
      NULL,
      NULL,
      5,
      0.409302,
      1.714915,
      1.481581,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.131269,
      3,
      2.580715,
      1.303880,
      NULL,
      NULL,
      2.636387,
      NULL,
      4.286029,
      0.753089,
      NULL,
      NULL,
      0,
      NULL,
      1.496514,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.546763,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.316164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604060,
      0,
      0,
      0.109254,
      0.082565,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652205,
      NULL,
      NULL,
      NULL,
      1.618693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062204,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.919036,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.369852,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.816169,
      NULL,
      NULL,
      NULL,
      0.627413,
      75.013240,
      20.093611,
      2.705780,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.792452,
      185.545286,
      2.226143,
      NULL,
      1.956530,
      1,
      0,
      1,
      NULL,
      0.589608,
      1,
      0,
      0,
      0.001105,
      NULL,
      1.023310,
      NULL,
      1.134786,
      0.075406,
      1.885073,
      1.881416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.460839,
      1,
      NULL,
      1.937348,
      3,
      2,
      0.463547,
      6.422168,
      1.690747,
      2,
      1.053626,
      1.242415,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0.275081,
      NULL,
      0.512894,
      2,
      NULL,
      0,
      0.356549,
      NULL,
      0.511120,
      0,
      NULL,
      0,
      1.569546,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.097370,
      NULL,
      1,
      0,
      NULL,
      0.726744,
      0.672505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215803,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      1.560707,
      NULL,
      NULL,
      NULL,
      15.650771,
      4.114367,
      NULL,
      3,
      '11303',
      '41201',
      NULL,
      3.555341,
      '30330',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


