set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916164';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '1313414',
      2.673789,
      NULL,
      NULL,
      1,
      '3332',
      2,
      0,
      NULL,
      NULL,
      NULL,
      107.949556,
      NULL,
      0.171954,
      1,
      NULL,
      NULL,
      8.690889,
      5,
      98,
      41.853648,
      3.788459,
      ' 3-29-1979',
      ' 0-27-1978',
      ' 6- 5-1989',
      NULL,
      0.294228,
      3,
      NULL,
      NULL,
      NULL,
      14.314676,
      0.783170,
      1,
      1306,
      12.367109,
      15,
      NULL,
      185,
      16,
      4,
      22.109832,
      0,
      0,
      0.468694,
      1,
      1.907899,
      1,
      NULL,
      1,
      0,
      1,
      0.278429,
      1.686410,
      1,
      10,
      7.804786,
      3,
      5,
      1,
      2,
      1.677463,
      0,
      0,
      0.310965,
      0.908445,
      0,
      1,
      1.575569,
      1,
      0,
      0.736728,
      0,
      0,
      5,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.022740,
      NULL,
      2.633534,
      1,
      0,
      1,
      1,
      NULL,
      1.267520,
      0,
      NULL,
      0.002153,
      1.267652,
      0.979673,
      1,
      1,
      0,
      1.446100,
      1.574012,
      1,
      1.793672,
      NULL,
      1.940737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.342901,
      1.743084,
      3,
      NULL,
      1,
      1,
      1,
      0.394935,
      1,
      1.040981,
      0,
      0,
      1.614348,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      4.648573,
      0.415323,
      7,
      3.217337,
      11,
      4.243957,
      8.859440,
      10.092537,
      NULL,
      8.508541,
      NULL,
      4.678263,
      NULL,
      9.854066,
      1,
      3,
      7.297850,
      7.870695,
      NULL,
      1.845090,
      3,
      7,
      0,
      7.218014,
      NULL,
      0,
      ' 5-12-1983',
      246.758778,
      ' 2- 4-1978',
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574653,
      0.077738,
      NULL,
      NULL,
      3,
      0.661392,
      2,
      0.106021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.000781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113301,
      NULL,
      3.326372,
      2.891380,
      1.360497,
      2.218206,
      1.455287,
      NULL,
      NULL,
      NULL,
      0.257834,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      823.598256,
      3.694642,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      4.923283,
      1.180949,
      NULL,
      1,
      0,
      1.323979,
      1.768779,
      0,
      NULL,
      0.557705,
      7,
      0.972618,
      3,
      NULL,
      10.099475,
      NULL,
      27,
      0,
      1.429960,
      3.953391,
      '02322',
      '30210',
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      '4320',
      '1033',
      0,
      23.187560,
      698.512302,
      NULL,
      3.527544,
      NULL,
      19,
      27.067374,
      11,
      3,
      2,
      3.359147,
      1.504190,
      NULL,
      NULL,
      NULL,
      1.199220,
      0,
      0.679941,
      0.877186,
      2,
      1,
      NULL,
      NULL,
      1.265507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418197,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.974981,
      NULL,
      NULL,
      7.603976,
      2.566899,
      7,
      1,
      1.468129,
      NULL,
      NULL,
      NULL,
      3,
      3.689632,
      2.409383,
      2.690479,
      0,
      1,
      0.803692,
      2,
      0.248998,
      NULL,
      NULL,
      NULL,
      NULL,
      2.636410,
      0,
      NULL,
      0.557329,
      1,
      0,
      NULL,
      0.698223,
      NULL,
      3,
      0,
      3.771553,
      1,
      1.199891,
      0.917892,
      1.040979,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.246733,
      NULL,
      NULL,
      NULL,
      2.774769,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.818515,
      0,
      NULL,
      2.228945,
      1.150432,
      NULL,
      NULL,
      0.563470,
      0,
      0,
      1.843895,
      NULL,
      NULL,
      3.757509,
      1.171747,
      0,
      1,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.688478,
      NULL,
      1.108924,
      1.465788,
      1.686242,
      4,
      1,
      NULL,
      2.686309,
      18.230173,
      NULL,
      NULL,
      9.003208,
      NULL,
      NULL,
      3.949207,
      2,
      2,
      1.941329,
      NULL,
      NULL,
      8.851168,
      9.726257,
      NULL,
      0.280298,
      2.989475,
      1,
      NULL,
      3.735399,
      2,
      7.368726,
      NULL,
      1.142731,
      NULL,
      0,
      0,
      NULL,
      5,
      NULL,
      1.503145,
      0.869524,
      1,
      NULL,
      2,
      0.735354,
      3,
      2.078953,
      NULL,
      5,
      7,
      6,
      0.446107,
      1,
      1.952278,
      1.799190,
      NULL,
      NULL,
      NULL,
      3.615298,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      7,
      4,
      5,
      0,
      2,
      2,
      9,
      NULL,
      1.616750,
      0.937660,
      NULL,
      1,
      2,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.276613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.655110,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.566171,
      0,
      1.097149,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.802303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      15.115301,
      NULL,
      NULL,
      NULL,
      17.861778,
      NULL,
      NULL,
      NULL,
      0.024344,
      NULL,
      NULL,
      2.732249,
      1.738667,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.840719,
      NULL,
      NULL,
      NULL,
      0,
      0.202525,
      NULL,
      NULL,
      0.843086,
      2,
      NULL,
      NULL,
      0,
      0.336709,
      NULL,
      NULL,
      NULL,
      7.968845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.630339,
      222,
      134,
      0.093884,
      NULL,
      NULL,
      1.947442,
      NULL,
      NULL,
      1.282025,
      NULL,
      NULL,
      3.586385,
      424,
      1755,
      NULL,
      NULL,
      NULL,
      3,
      7,
      3.141711,
      10948.878049,
      507,
      1.648104,
      1.642137,
      1.341752,
      1,
      1.768600,
      NULL,
      NULL,
      0,
      0,
      0.553778,
      0.734521,
      1.894899,
      1.968383,
      0.348265,
      1.027350,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.220784,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      NULL,
      2.767688,
      NULL,
      3.504758,
      3.439415,
      1.793421,
      3.150889,
      1,
      0,
      0.300060,
      2,
      2,
      2.448359,
      0.368447,
      0,
      1,
      0,
      NULL,
      NULL,
      1.524816,
      3.371721,
      NULL,
      1.952239,
      NULL,
      1,
      1.512485,
      3,
      NULL,
      NULL,
      1,
      3,
      0,
      1.677632,
      2,
      3,
      NULL,
      1.941916,
      1,
      1,
      0.658948,
      2,
      1.783766,
      2.697864,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      1.259303,
      0,
      1,
      3,
      3.780981,
      0,
      0.369051,
      NULL,
      2,
      1,
      3.739120,
      0,
      1,
      0,
      1.047427,
      1,
      0,
      2.874714,
      1.936883,
      0.403493,
      0.353086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.680538,
      1,
      9,
      7.086892,
      1.947183,
      0,
      NULL,
      3.803610,
      10.371817,
      17,
      3.452999,
      1,
      7,
      '31314',
      '42432',
      '00234',
      1.431021,
      '',
      '',
      '',
      6.111216,
      '4412',
      '4420',
      '2303');
commit;
end;
/


