set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528893';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '1231213',
      3.232909,
      1,
      1,
      2,
      '4414',
      2.771890,
      0.727287,
      NULL,
      NULL,
      NULL,
      117,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2.205897,
      7.828205,
      90.564298,
      NULL,
      ' 4-17-1993',
      ' 4-26-1979',
      '10-17-1985',
      1.935953,
      0.712365,
      0.530297,
      3.612447,
      1,
      0,
      0,
      0.880121,
      0.657921,
      NULL,
      16,
      4.929530,
      7,
      12,
      3.445880,
      4,
      14.397442,
      7,
      NULL,
      NULL,
      1.953430,
      1.947630,
      0,
      1,
      NULL,
      0,
      0.449881,
      0,
      NULL,
      1,
      1.182084,
      3,
      2,
      NULL,
      NULL,
      7,
      1,
      0,
      1,
      1,
      1,
      6.877731,
      2.613768,
      NULL,
      NULL,
      8.109552,
      NULL,
      0,
      NULL,
      0,
      3.289711,
      1.151704,
      0,
      NULL,
      NULL,
      1.747593,
      NULL,
      NULL,
      3.137057,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.548369,
      5,
      NULL,
      3,
      2,
      1.820998,
      NULL,
      NULL,
      1.923004,
      NULL,
      NULL,
      0.412074,
      0.382293,
      3,
      0.264857,
      NULL,
      5,
      3.850985,
      NULL,
      0,
      2.321726,
      5,
      0.986582,
      0,
      7,
      0,
      0.325464,
      1.836752,
      0.803173,
      0,
      NULL,
      1.179455,
      5.985786,
      0,
      0.994185,
      NULL,
      0,
      NULL,
      2.084334,
      0,
      NULL,
      1,
      1.854322,
      1.357855,
      3.950769,
      3.009088,
      0.206183,
      NULL,
      NULL,
      NULL,
      2,
      3.234355,
      2,
      3,
      0.299018,
      4,
      3.993004,
      4.991477,
      2.484024,
      ' 7-26-1988',
      NULL,
      NULL,
      1225.514642,
      2.113451,
      1.823698,
      0.204631,
      2.087394,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.040595,
      0,
      0.081775,
      1,
      1.513929,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      26,
      1,
      0,
      1.019616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.853289,
      1.316866,
      1.707300,
      1.693997,
      4,
      0,
      2.003028,
      1.857695,
      4,
      1,
      NULL,
      NULL,
      0,
      3.249911,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.621758,
      1,
      NULL,
      0.563603,
      1.715853,
      1.237635,
      40,
      1.954762,
      2.234285,
      4,
      117,
      NULL,
      0,
      1,
      0.122204,
      NULL,
      2.158747,
      3,
      1.538110,
      2,
      NULL,
      NULL,
      7,
      6.121255,
      NULL,
      NULL,
      1.458557,
      2,
      1.468682,
      NULL,
      1,
      3,
      0.700974,
      0.451262,
      NULL,
      1.092221,
      1,
      0.750383,
      0,
      0.518346,
      NULL,
      0.773805,
      1,
      1,
      NULL,
      9,
      1,
      1.047492,
      3.148758,
      4,
      5.413532,
      3.034189,
      NULL,
      1,
      2.768927,
      3.320722,
      25.872596,
      NULL,
      0.639815,
      NULL,
      NULL,
      5,
      49,
      1.915538,
      5,
      0.105171,
      '14123',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      9,
      272.888328,
      6,
      1.638441,
      16.430275,
      10,
      8,
      4,
      1.735837,
      1.662689,
      3.874230,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.139370,
      1,
      3.500594,
      2.969384,
      NULL,
      2.825266,
      0,
      0,
      3,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      1.707542,
      3,
      2,
      1,
      2,
      NULL,
      0,
      NULL,
      3.106247,
      2,
      1.851845,
      4.990943,
      NULL,
      4,
      0.524861,
      0.913585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.615099,
      0,
      2,
      NULL,
      3.714985,
      1.303123,
      NULL,
      1,
      1,
      2,
      1.621517,
      NULL,
      2.184547,
      NULL,
      3.209901,
      1,
      2,
      0.755234,
      2.822571,
      1.095875,
      1.455300,
      2.545984,
      3.211259,
      NULL,
      0,
      2.151518,
      NULL,
      1,
      0.278075,
      NULL,
      NULL,
      3.040264,
      NULL,
      NULL,
      1,
      2.933459,
      1.050232,
      1.224126,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408553,
      NULL,
      NULL,
      NULL,
      1.270377,
      NULL,
      NULL,
      3.648201,
      3,
      3,
      2,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.166744,
      2.668525,
      0.445048,
      NULL,
      NULL,
      3.812239,
      4.908463,
      5.769661,
      NULL,
      NULL,
      NULL,
      0.220003,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.163574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.302972,
      0,
      0.040245,
      0,
      NULL,
      2.467382,
      NULL,
      5.083564,
      1,
      3,
      5.775654,
      1,
      NULL,
      NULL,
      1,
      0.578701,
      0,
      1,
      3,
      2.964492,
      1,
      0,
      NULL,
      4.239757,
      NULL,
      4.255746,
      2,
      NULL,
      NULL,
      1.956730,
      NULL,
      NULL,
      NULL,
      2.511311,
      NULL,
      2,
      2.094893,
      2,
      1.239515,
      1.634437,
      NULL,
      6,
      NULL,
      0.421819,
      2.287374,
      2,
      NULL,
      1.338992,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.974724,
      NULL,
      NULL,
      1.175837,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.090263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      0,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.755633,
      0,
      NULL,
      NULL,
      0.405800,
      NULL,
      NULL,
      NULL,
      2.434353,
      0.741207,
      NULL,
      NULL,
      0.859762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.308326,
      2,
      NULL,
      NULL,
      0.622690,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.701569,
      NULL,
      NULL,
      NULL,
      2.209555,
      1.005954,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.112684,
      1.558468,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.469480,
      NULL,
      NULL,
      0.368114,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      3.130777,
      4.475444,
      NULL,
      253.630183,
      89.304665,
      0.533434,
      54,
      6,
      1.366326,
      NULL,
      NULL,
      1,
      0.359147,
      1.060138,
      0.154056,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.836468,
      NULL,
      NULL,
      102,
      0.513404,
      0.229227,
      0.268245,
      NULL,
      1.463490,
      0.963661,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1.700549,
      1,
      0.670080,
      0.183645,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.227930,
      1,
      0.206429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008837,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500090,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191409,
      1.331369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.347837,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.540575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834709,
      2.032756,
      NULL,
      1.616047,
      NULL,
      0.668492,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.588230,
      5,
      3,
      15,
      2,
      3,
      1,
      1.424636,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114024,
      3.939816,
      NULL,
      NULL,
      3.788850,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      2.047816,
      2.333925,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.696812,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      2.018915,
      1,
      NULL,
      1,
      1.466214,
      NULL,
      0.635715,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.436163,
      8,
      2,
      1.037741,
      NULL,
      NULL,
      NULL,
      0.756707,
      4,
      4.746243,
      0.545411,
      '42141',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


