set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7128938';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '14',
      43.625393,
      22.768782,
      '2104100',
      1,
      NULL,
      1,
      3,
      '1400',
      3.539573,
      NULL,
      NULL,
      NULL,
      ' 6- 6-1999',
      63.508699,
      2,
      NULL,
      0.152854,
      1,
      ' 2- 2-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      4.106073,
      NULL,
      NULL,
      ' 9-23-1974',
      1,
      NULL,
      0,
      2.042207,
      NULL,
      0,
      3.544008,
      2,
      NULL,
      NULL,
      NULL,
      11.125291,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      5.747014,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.285066,
      2,
      0,
      1,
      2.335793,
      1.279349,
      1,
      0,
      0.499561,
      1,
      3,
      3,
      0,
      1,
      0.000542,
      3.860548,
      0.194330,
      0.902029,
      NULL,
      NULL,
      0,
      1.132582,
      1.388879,
      NULL,
      NULL,
      1.192261,
      NULL,
      NULL,
      4,
      1,
      1,
      0.236208,
      1.221237,
      2.953460,
      2.319341,
      0.111768,
      1,
      3,
      2.551457,
      NULL,
      0.469390,
      NULL,
      0.262458,
      NULL,
      0,
      1.155742,
      3,
      NULL,
      1.099781,
      0,
      9,
      1,
      1,
      2,
      0.411485,
      NULL,
      NULL,
      0.734845,
      NULL,
      NULL,
      0,
      1.993193,
      0.432550,
      1,
      0,
      1,
      0,
      NULL,
      0.747463,
      1,
      1.036485,
      0,
      1.716453,
      3.726095,
      1,
      NULL,
      1,
      0,
      0.164940,
      NULL,
      0,
      NULL,
      1.117743,
      0.311020,
      0.787853,
      1.337376,
      0.898512,
      4.409183,
      1,
      0,
      0.534214,
      1.348533,
      1.743549,
      3.332089,
      1.228326,
      0.135751,
      4.774506,
      0,
      2,
      NULL,
      9.420177,
      NULL,
      5,
      2.039630,
      1,
      NULL,
      1.647403,
      3.192880,
      '11-29-1986',
      3586,
      NULL,
      2609.776357,
      0,
      1.781165,
      1,
      3,
      0.489931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.988462,
      1.750268,
      1.928845,
      3,
      1.146867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.088088,
      0.441421,
      0,
      0,
      0.348579,
      NULL,
      NULL,
      NULL,
      0.413254,
      3.419224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.121015,
      NULL,
      NULL,
      0.189453,
      1.822553,
      0.064334,
      1.699425,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.634710,
      0,
      0.671346,
      5.332265,
      1,
      4.340017,
      NULL,
      4.582816,
      NULL,
      2,
      5,
      5,
      1,
      NULL,
      3,
      3,
      NULL,
      1,
      1,
      1,
      1.265725,
      NULL,
      1.951725,
      0,
      NULL,
      0,
      1.588875,
      1,
      1.511961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.258858,
      0,
      7,
      3.794733,
      4,
      1.965171,
      5.934232,
      NULL,
      2.983340,
      NULL,
      11.995849,
      NULL,
      1,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4.427923,
      '11110',
      '04330',
      NULL,
      0,
      NULL,
      '',
      NULL,
      3.350613,
      '02211',
      '',
      NULL,
      1,
      NULL,
      916.171120,
      14,
      0,
      22.641561,
      3.384251,
      5.737807,
      NULL,
      2.134516,
      0,
      0.345762,
      0.864139,
      NULL,
      NULL,
      0.574082,
      NULL,
      NULL,
      0.502746,
      NULL,
      NULL,
      2,
      0,
      1,
      3.681596,
      3,
      1,
      3,
      1,
      1,
      0,
      0,
      0,
      1.012889,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.342913,
      0,
      1,
      1.573060,
      NULL,
      NULL,
      3,
      9,
      2.876971,
      0.171624,
      0.976351,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.281806,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.951915,
      2,
      1,
      0.594534,
      1.063788,
      1.750827,
      NULL,
      0,
      NULL,
      1,
      3.908099,
      2,
      2.971178,
      2.831213,
      2,
      0.489823,
      2.093809,
      1.401750,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.468340,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961094,
      NULL,
      NULL,
      NULL,
      0.801614,
      NULL,
      NULL,
      1.130598,
      NULL,
      NULL,
      2.241431,
      0,
      0.460707,
      0,
      NULL,
      NULL,
      2.637529,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453784,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.370839,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544525,
      NULL,
      NULL,
      NULL,
      1.775382,
      3.482632,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.006335,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153635,
      3,
      2,
      2,
      1.156256,
      NULL,
      2,
      0,
      2.060194,
      0.905845,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.495240,
      3.111866,
      NULL,
      1.528908,
      NULL,
      NULL,
      0.609022,
      1,
      NULL,
      1.867258,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      3.913324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.110765,
      NULL,
      NULL,
      1.771829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.347199,
      3,
      0,
      NULL,
      NULL,
      2.702637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572519,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.815339,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423645,
      NULL,
      NULL,
      NULL,
      3,
      2.754935,
      1,
      1.577685,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.834086,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.392678,
      1,
      NULL,
      1,
      0.127484,
      0,
      2.412837,
      0.473059,
      0,
      NULL,
      3.833714,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      25.789610,
      NULL,
      1.812528,
      33.757197,
      10.212504,
      NULL,
      0,
      NULL,
      NULL,
      1.092814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.487318,
      NULL,
      0.821053,
      NULL,
      0.175052,
      NULL,
      0.099590,
      NULL,
      0.191494,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      NULL,
      4.285338,
      2.593699,
      1,
      6,
      1,
      NULL,
      1.281442,
      1.967900,
      0,
      NULL,
      0.396760,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451660,
      0.136988,
      NULL,
      0.180812,
      1.343018,
      NULL,
      1.372335,
      1,
      NULL,
      1.532524,
      1.661217,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558892,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.804272,
      NULL,
      1,
      1.153293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731361,
      NULL,
      1,
      0,
      NULL,
      0.014553,
      NULL,
      NULL,
      64,
      13.911113,
      3.500033,
      4.320194,
      0,
      '31330',
      '12001',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '32312',
      '',
      '');
commit;
end;
/


