set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8533544';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '4424032',
      3,
      0.996664,
      3,
      NULL,
      '4003',
      3,
      1.766053,
      NULL,
      NULL,
      ' 9-11-1983',
      46.901152,
      NULL,
      1,
      NULL,
      2,
      ' 9-11-1981',
      NULL,
      2,
      354.372662,
      NULL,
      1.320002,
      ' 5-14-1974',
      ' 4-24-2002',
      ' 4- 8-2000',
      NULL,
      1,
      2,
      0,
      1.366933,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126103,
      NULL,
      23.226155,
      1.086459,
      9.254648,
      1,
      9.963718,
      NULL,
      9,
      0,
      1.433025,
      2.652843,
      NULL,
      0,
      1.744682,
      1,
      NULL,
      0,
      0,
      1.368346,
      NULL,
      0.782150,
      2.424267,
      1.025201,
      NULL,
      5,
      0.265292,
      NULL,
      0.552100,
      NULL,
      NULL,
      1,
      2,
      1,
      0.257216,
      0,
      1.435490,
      1,
      3.503345,
      3,
      NULL,
      1.934860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      2.668251,
      NULL,
      NULL,
      3,
      2.964540,
      0,
      3.700661,
      0,
      2,
      NULL,
      NULL,
      3,
      1.400948,
      2.832557,
      2.169194,
      1.878793,
      NULL,
      2,
      0,
      9.550627,
      1,
      4.754826,
      NULL,
      1,
      NULL,
      NULL,
      1.060860,
      NULL,
      NULL,
      0,
      0,
      0.259650,
      0.286918,
      0.080837,
      1.315411,
      NULL,
      NULL,
      0.416698,
      0,
      0.043113,
      1.479484,
      NULL,
      0.680097,
      0,
      0.921769,
      0.990305,
      1.223273,
      0.203207,
      NULL,
      1.140714,
      2.894212,
      2,
      0,
      NULL,
      0.703895,
      1.136533,
      0.787234,
      NULL,
      0.192413,
      2.207379,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      7,
      NULL,
      3,
      9,
      NULL,
      1,
      1,
      0,
      1.341322,
      1.025366,
      2,
      ' 1- 7-1979',
      135.436893,
      NULL,
      NULL,
      3,
      0.593734,
      NULL,
      1.434835,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919188,
      1.871494,
      0.052792,
      0,
      7,
      0,
      1.491269,
      0.005112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.395706,
      1.441606,
      0.353522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.150937,
      2,
      2,
      0,
      4,
      1,
      4,
      1.463623,
      2.336074,
      NULL,
      4.486778,
      1,
      NULL,
      NULL,
      0.681756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941652,
      0,
      0,
      0.979886,
      NULL,
      NULL,
      1,
      1.305974,
      NULL,
      1,
      1.225580,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.062296,
      2.566054,
      2,
      3,
      1.324738,
      NULL,
      2.608962,
      NULL,
      0.745080,
      NULL,
      3.113175,
      0,
      2.369396,
      1.626796,
      0.604942,
      2.307031,
      NULL,
      5,
      0,
      0,
      36,
      142,
      49.975052,
      70,
      21.764007,
      38,
      1.355592,
      1.890764,
      0.847091,
      1,
      NULL,
      2,
      2.473135,
      9.184273,
      8.103896,
      0,
      1.242023,
      2,
      NULL,
      NULL,
      3,
      3.581488,
      23,
      3,
      1.987785,
      NULL,
      NULL,
      75.725328,
      26,
      5.211893,
      1,
      1,
      '04140',
      '',
      NULL,
      3,
      '41144',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3.248868,
      6,
      32,
      NULL,
      1.948788,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.142633,
      3,
      1,
      NULL,
      NULL,
      3,
      0.002462,
      NULL,
      0,
      2,
      1.484467,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.650795,
      NULL,
      NULL,
      1.275573,
      1,
      0.074810,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.826023,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.608798,
      0,
      NULL,
      0,
      1.679401,
      1,
      2,
      0,
      1,
      NULL,
      0.018037,
      NULL,
      2,
      0.975443,
      0,
      1.905657,
      2.205592,
      0,
      2.034482,
      NULL,
      3.911357,
      3.728651,
      NULL,
      2,
      1.632414,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.859195,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.444665,
      1.990836,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660615,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.910860,
      NULL,
      NULL,
      1.550628,
      NULL,
      NULL,
      1.959748,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.458835,
      NULL,
      NULL,
      2,
      NULL,
      0,
      4,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.195091,
      2,
      NULL,
      3.663225,
      0.623190,
      1,
      NULL,
      6.245613,
      NULL,
      0,
      3.029363,
      2,
      2.433539,
      1,
      0,
      2.309130,
      1.129644,
      0.350911,
      1,
      1.048805,
      1.240003,
      NULL,
      4.153775,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.298107,
      1,
      0.447263,
      1,
      0,
      2,
      NULL,
      NULL,
      1.330444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520806,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.036178,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.752337,
      NULL,
      NULL,
      0.796545,
      NULL,
      1.996294,
      0.232019,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      747.693895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564853,
      NULL,
      NULL,
      NULL,
      1.596503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      7,
      0,
      5,
      0,
      NULL,
      2,
      0.133766,
      NULL,
      NULL,
      0.431134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590042,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.757140,
      NULL,
      0,
      NULL,
      NULL,
      1.552788,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.021269,
      0.974642,
      1.386759,
      0,
      0.952590,
      1.903097,
      1,
      1,
      0.770093,
      1.904165,
      3.662956,
      0,
      0,
      NULL,
      1.563855,
      NULL,
      0,
      NULL,
      0.265629,
      NULL,
      0,
      NULL,
      0.531254,
      NULL,
      1.212018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.258705,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429336,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.412657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.758067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.165297,
      2.401017,
      1.902149,
      1.271868,
      0.374411,
      NULL,
      NULL,
      1,
      0.535829,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842631,
      4,
      0.975863,
      6.732185,
      0,
      4,
      5.746663,
      2.671249,
      2.140608,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0.906857,
      1.291976,
      NULL,
      NULL,
      1.069915,
      NULL,
      NULL,
      1.525558,
      NULL,
      0,
      0.869945,
      NULL,
      0,
      3.367064,
      NULL,
      3,
      3,
      NULL,
      1,
      1,
      NULL,
      1.842302,
      1,
      NULL,
      NULL,
      2.404545,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.454040,
      1.875190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.447161,
      1.465863,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.635402,
      NULL,
      0.824496,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.767422,
      NULL,
      0.405442,
      NULL,
      1,
      NULL,
      1.918167,
      NULL,
      NULL,
      NULL,
      7,
      1.794714,
      3.961902,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      4.042966,
      3,
      0.416482,
      2.705975,
      0,
      19,
      NULL,
      NULL,
      NULL,
      1.749974,
      '00012',
      '',
      '',
      1,
      '22344',
      '',
      NULL,
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


