set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.178489,
      2.521119,
      1,
      0,
      1.043981,
      1,
      3.195913,
      NULL,
      '14234440',
      10,
      55,
      '4130303',
      1,
      0.132210,
      1,
      2,
      '3202',
      3,
      1.374129,
      NULL,
      NULL,
      '11-10-1988',
      2,
      NULL,
      NULL,
      1.137495,
      NULL,
      ' 5- 3-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 6- 5-1979',
      ' 7- 4-1977',
      '11-29-1990',
      2,
      3,
      2.098077,
      3,
      1,
      2.521270,
      0.923854,
      0,
      NULL,
      NULL,
      NULL,
      8,
      5.903755,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.766916,
      NULL,
      2.702366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      6.732926,
      0,
      NULL,
      5,
      NULL,
      1,
      2,
      1.985189,
      1.123690,
      0,
      0,
      0,
      2.593616,
      1.097793,
      2,
      0,
      0,
      1.972295,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.009545,
      1.883885,
      0,
      0.894351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536916,
      2,
      1.668435,
      0.237025,
      1,
      0.437022,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.779991,
      1.154841,
      4.934172,
      0,
      NULL,
      3.036979,
      1.124049,
      0,
      1,
      NULL,
      NULL,
      0.946711,
      1.050055,
      4.399717,
      NULL,
      NULL,
      0.909728,
      0.892746,
      0,
      NULL,
      1,
      0.523363,
      0.296269,
      0.098077,
      1,
      1.164260,
      0.725351,
      0.773428,
      0,
      NULL,
      NULL,
      NULL,
      0.416333,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      4.416680,
      0,
      9.768772,
      NULL,
      6.854286,
      1,
      0,
      1.811913,
      3,
      ' 9-12-1998',
      NULL,
      '11- 1-1976',
      0,
      NULL,
      1.889154,
      1.121189,
      3.799593,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.664900,
      1.758684,
      NULL,
      11.202494,
      3.884051,
      1,
      1.543287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.901798,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3.598608,
      1,
      0.442634,
      1.750405,
      1.286591,
      NULL,
      0,
      1.915060,
      5.460644,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.840450,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656291,
      0,
      1.484957,
      0.647850,
      0,
      1.842698,
      2.187086,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.974751,
      NULL,
      1,
      3.398505,
      0,
      7,
      2.410245,
      NULL,
      NULL,
      3.011180,
      NULL,
      0.855216,
      2,
      2.261519,
      0.204714,
      NULL,
      NULL,
      1,
      0.010298,
      0.288940,
      0.620805,
      NULL,
      NULL,
      0,
      NULL,
      1.764106,
      NULL,
      1.807025,
      1.924511,
      3.380910,
      4.185288,
      1.115828,
      5,
      1,
      3,
      8,
      NULL,
      5.779703,
      0.810305,
      3,
      4,
      NULL,
      NULL,
      0,
      NULL,
      2.690484,
      1.040816,
      22,
      NULL,
      56.643706,
      20,
      5.659158,
      2,
      3,
      '00443',
      '22130',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.715535,
      6.727571,
      194,
      29,
      NULL,
      26,
      NULL,
      0,
      1,
      2.822675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458956,
      NULL,
      NULL,
      1.063632,
      NULL,
      NULL,
      0.671333,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.390483,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.695024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602921,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.410382,
      1,
      0,
      NULL,
      NULL,
      1.623961,
      1,
      0,
      1.599035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263272,
      NULL,
      NULL,
      0.543758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.353067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.058656,
      NULL,
      NULL,
      0.965147,
      NULL,
      NULL,
      0.638598,
      3.227920,
      0,
      3,
      0,
      2,
      0.068699,
      NULL,
      NULL,
      0.994990,
      5.984417,
      2.236217,
      0.152473,
      3.241896,
      2,
      3.767473,
      1,
      2,
      2,
      1,
      NULL,
      2,
      NULL,
      1,
      0,
      2.643692,
      NULL,
      NULL,
      3,
      0,
      0.152027,
      NULL,
      NULL,
      1,
      1.168389,
      NULL,
      0,
      1,
      1.422490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.213412,
      1.528274,
      1,
      0.309577,
      1.400322,
      1.031760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478368,
      0.748489,
      5.079630,
      1.035877,
      NULL,
      NULL,
      NULL,
      1.039485,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.090682,
      NULL,
      NULL,
      0.422171,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      27,
      3.641552,
      2,
      2,
      0,
      2.639314,
      3,
      2,
      NULL,
      0.010159,
      1.346939,
      0.516095,
      0,
      1,
      0.024500,
      NULL,
      NULL,
      1.141244,
      3,
      NULL,
      1.101551,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      1,
      4.447861,
      147,
      0,
      7.436400,
      20,
      NULL,
      0,
      0.323876,
      NULL,
      0,
      1.008255,
      3.152795,
      0.423682,
      0,
      1.877412,
      0,
      0,
      0.485931,
      1.959802,
      1,
      0.270488,
      0,
      0.086069,
      1,
      1,
      1.711937,
      0,
      1,
      1.277917,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1.688421,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.801149,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.573852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772181,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.910478,
      1.025436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.634192,
      1.090329,
      NULL,
      1.656915,
      0,
      NULL,
      NULL,
      0.153485,
      0,
      NULL,
      0.643183,
      0.354083,
      1.120501,
      0.873100,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944837,
      0.624165,
      NULL,
      2.656954,
      3,
      0,
      0,
      1.262347,
      7,
      3,
      3.577462,
      1,
      NULL,
      1.232782,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.970540,
      NULL,
      0.656229,
      0.690669,
      NULL,
      0.672766,
      1.657245,
      NULL,
      0,
      0.746968,
      NULL,
      NULL,
      1.771536,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      6,
      6.584570,
      1.369306,
      NULL,
      NULL,
      4,
      NULL,
      4,
      2.465052,
      0.030924,
      '04011',
      '40314',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


