set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.586345,
      1,
      1,
      1.945384,
      3,
      1.833574,
      0.326003,
      '330',
      '10310211',
      33.198456,
      47.122909,
      '4100314',
      3,
      0.879227,
      6,
      0,
      '3010',
      5,
      1.085910,
      NULL,
      NULL,
      NULL,
      67.078766,
      41,
      NULL,
      0.463595,
      0,
      ' 5-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-16-1982',
      0.987734,
      0,
      3.077094,
      1.006957,
      NULL,
      0,
      3,
      3.350951,
      NULL,
      NULL,
      NULL,
      6,
      0.445419,
      NULL,
      NULL,
      NULL,
      NULL,
      8.313557,
      NULL,
      NULL,
      1,
      1.785170,
      1.748383,
      1,
      1.381361,
      0.434285,
      1.267248,
      NULL,
      0.946817,
      1.279597,
      0.303741,
      NULL,
      2.781101,
      NULL,
      NULL,
      0,
      1,
      1,
      1.083902,
      NULL,
      1,
      3,
      0.227388,
      1.109161,
      0,
      1,
      0,
      2.469213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.939708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682254,
      1.895672,
      0,
      3.797153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697163,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      0,
      0.216775,
      1.040681,
      0,
      0.206583,
      0,
      0.070318,
      NULL,
      0,
      NULL,
      1.773257,
      1,
      NULL,
      NULL,
      1.444398,
      0,
      1,
      1.916749,
      0.050869,
      NULL,
      0.213805,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1.227464,
      2.762497,
      0,
      0,
      3,
      5.328481,
      7,
      0.274125,
      5,
      NULL,
      0.771056,
      1,
      0,
      1.895588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.270454,
      1.165516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042987,
      NULL,
      1.443968,
      0,
      NULL,
      NULL,
      1,
      1.696824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.964480,
      3.309825,
      2.420867,
      0,
      1,
      2,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.773890,
      2.021955,
      5.974387,
      NULL,
      4,
      1.611923,
      NULL,
      NULL,
      NULL,
      0.947103,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834617,
      0,
      NULL,
      1,
      0,
      1.975345,
      1,
      0.077791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124476,
      1,
      NULL,
      3.640596,
      2.109091,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      5,
      1.996304,
      0.381134,
      0.635331,
      1.760612,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.317762,
      NULL,
      1.714291,
      1,
      1.540183,
      NULL,
      3,
      NULL,
      3,
      5.306417,
      5.279643,
      9,
      11.120960,
      0,
      1,
      NULL,
      1,
      2.619726,
      2,
      NULL,
      12.433934,
      3.137322,
      0.633513,
      56.348903,
      NULL,
      NULL,
      NULL,
      3.605235,
      2.377677,
      3,
      '02122',
      '22332',
      '',
      0.390456,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.041268,
      25,
      376.443848,
      NULL,
      2.016385,
      30,
      NULL,
      3,
      0,
      3,
      0.428825,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.154872,
      NULL,
      0,
      1.922290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990203,
      0,
      NULL,
      1.616273,
      NULL,
      NULL,
      1.677524,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.031024,
      NULL,
      NULL,
      1.586647,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      0.890493,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1.606184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527536,
      NULL,
      1.296641,
      1.064371,
      0,
      3,
      NULL,
      0.873029,
      NULL,
      NULL,
      1.472884,
      1,
      NULL,
      2.019835,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      0.291451,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.080974,
      1,
      1,
      1.451563,
      0.293194,
      NULL,
      1.651859,
      NULL,
      NULL,
      3,
      1.547191,
      0.829829,
      1.293930,
      0.408281,
      0.448890,
      0,
      1.557193,
      0,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.150190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.001793,
      1.488621,
      0.162215,
      0,
      NULL,
      NULL,
      6,
      1.672471,
      0.390850,
      4.205789,
      NULL,
      0.382716,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.317594,
      0.269838,
      2.728402,
      2,
      NULL,
      0,
      2.122806,
      1,
      2.469779,
      0.572100,
      1,
      NULL,
      NULL,
      1,
      3.616163,
      0.011142,
      0.197220,
      1.571204,
      3.643113,
      NULL,
      5,
      4,
      1.433353,
      NULL,
      0.815769,
      7,
      1.280320,
      1.628036,
      1.271079,
      1.751096,
      1,
      0.638237,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315688,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.584402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.548359,
      NULL,
      0.037766,
      1.615840,
      NULL,
      0.787474,
      1.034961,
      NULL,
      NULL,
      0.286405,
      NULL,
      NULL,
      NULL,
      1.178032,
      NULL,
      NULL,
      NULL,
      0.035926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.199497,
      NULL,
      NULL,
      2.272708,
      NULL,
      NULL,
      NULL,
      0.898707,
      NULL,
      NULL,
      NULL,
      0.199581,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.930924,
      0.499548,
      NULL,
      NULL,
      0.495692,
      0.443717,
      NULL,
      NULL,
      1.368558,
      3,
      NULL,
      NULL,
      1,
      0.067587,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.099597,
      0,
      NULL,
      NULL,
      1.174293,
      0,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      2,
      1,
      0.416741,
      NULL,
      1,
      NULL,
      NULL,
      0.066800,
      NULL,
      NULL,
      0.948389,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.180477,
      10,
      0.119269,
      2.381691,
      NULL,
      0,
      0.442758,
      NULL,
      NULL,
      2,
      1,
      0.979944,
      1,
      0.796592,
      0,
      0,
      0.218923,
      0.030976,
      0,
      NULL,
      NULL,
      1.614149,
      NULL,
      NULL,
      NULL,
      1.409288,
      NULL,
      0,
      NULL,
      0.111108,
      NULL,
      69.780181,
      NULL,
      1,
      30,
      24.676299,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.937747,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.733808,
      NULL,
      1.557420,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.235566,
      3,
      0.148245,
      0.686209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.823316,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.864635,
      1.781212,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.326744,
      1,
      1,
      NULL,
      0,
      1.400018,
      5,
      NULL,
      0.528066,
      2,
      2.330563,
      NULL,
      NULL,
      0.232683,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      1,
      0.335672,
      0.567152,
      1,
      3.838323,
      2,
      0,
      1,
      2.632478,
      0.678565,
      0,
      2,
      1.828223,
      0,
      0.313743,
      0,
      1.552221,
      0.025173,
      0.885644,
      1,
      NULL,
      1.454386,
      0.770518,
      0.301253,
      NULL,
      0.588441,
      0.099162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.226112,
      0,
      0,
      NULL,
      2,
      NULL,
      0.370777,
      1.012241,
      2,
      NULL,
      31.974733,
      0,
      0,
      0.335776,
      '24401',
      '03121',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


