set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9515594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      0.241829,
      1.643032,
      2,
      1.053996,
      2,
      3.792976,
      '203',
      '23130120',
      43,
      5,
      '1014441',
      0.504901,
      0.240432,
      3,
      1,
      '4240',
      3,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1988',
      161.688472,
      164,
      NULL,
      1.324202,
      3.325490,
      ' 5-23-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      1.559493,
      ' 3-26-1981',
      ' 4-28-1994',
      '10-29-1985',
      0,
      NULL,
      0,
      0.882720,
      0.881353,
      0,
      NULL,
      3.703283,
      NULL,
      NULL,
      NULL,
      NULL,
      3.169553,
      NULL,
      NULL,
      NULL,
      NULL,
      6.611505,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.469194,
      2,
      NULL,
      NULL,
      5,
      4.745160,
      1.361749,
      0,
      4,
      10.189167,
      10,
      1.863846,
      3,
      0,
      2,
      0.244754,
      8.002284,
      NULL,
      4.883746,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0,
      0.454461,
      NULL,
      0,
      0.461785,
      3,
      0.525455,
      1,
      0,
      NULL,
      3.592488,
      1,
      0,
      1.340713,
      0,
      NULL,
      NULL,
      0,
      4.126499,
      3.247546,
      1,
      1.901416,
      1,
      1.997323,
      NULL,
      NULL,
      1.275166,
      NULL,
      NULL,
      NULL,
      2.591457,
      5,
      5.043515,
      1,
      7,
      NULL,
      3.531598,
      1,
      NULL,
      2.313409,
      0.211855,
      0.655711,
      NULL,
      NULL,
      0.922845,
      0.776551,
      0,
      1.960059,
      NULL,
      1,
      1.645113,
      4,
      NULL,
      1.486905,
      1,
      1,
      5.166131,
      0,
      2,
      2.371588,
      0,
      3,
      2.858955,
      7.755721,
      0.473368,
      9,
      4.123271,
      1,
      NULL,
      9,
      9.083163,
      NULL,
      4,
      5.715350,
      0.661370,
      0.477745,
      1.509213,
      ' 1-26-2003',
      192,
      NULL,
      264.701832,
      0.664392,
      1,
      0,
      NULL,
      1.997165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.906363,
      3.380262,
      0.216503,
      1,
      0.439651,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.300251,
      0.876738,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150135,
      1.447411,
      0,
      4,
      5,
      2,
      5,
      3.184963,
      1.431966,
      NULL,
      0.036047,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980224,
      0.521118,
      1,
      1.409026,
      0,
      0,
      2,
      22.048048,
      1.598378,
      1.193697,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.181090,
      0.286095,
      3,
      NULL,
      0,
      2,
      2.670399,
      2,
      1,
      1,
      1.220762,
      NULL,
      0.101343,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.995875,
      NULL,
      1.202257,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.571993,
      1,
      5,
      0.158096,
      7.701546,
      NULL,
      4.048918,
      4,
      2,
      NULL,
      NULL,
      0,
      3,
      0.862224,
      20,
      2.579506,
      2.545494,
      17.984294,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      '44331',
      '',
      NULL,
      1.322354,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0.426516,
      NULL,
      104.915703,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.078870,
      2,
      2.322438,
      2,
      0.035816,
      1.692979,
      1.137127,
      1.291641,
      3.820325,
      2.336225,
      1.366962,
      1,
      3.235321,
      1.235328,
      0.645919,
      2,
      3.859534,
      3,
      3,
      0,
      1.110644,
      NULL,
      3.626681,
      3,
      3.869999,
      NULL,
      0.436182,
      0,
      NULL,
      NULL,
      2.358328,
      3,
      2.475764,
      1.929764,
      NULL,
      NULL,
      3.118184,
      7,
      NULL,
      NULL,
      0.054497,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.133469,
      3.676951,
      2,
      1,
      2,
      0,
      2.156147,
      0.411423,
      1.298180,
      3.993031,
      2.500029,
      NULL,
      NULL,
      1.929723,
      0.681200,
      NULL,
      1.177064,
      1,
      3.084353,
      3.888965,
      0,
      1,
      NULL,
      1,
      NULL,
      0.741169,
      0.197768,
      1.864537,
      3.647698,
      1,
      NULL,
      7.086831,
      NULL,
      3.543798,
      0.776588,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217770,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.026849,
      1.229131,
      3,
      3,
      1.640855,
      0,
      1,
      1.148458,
      2.769475,
      NULL,
      1.494101,
      1.772447,
      1.166206,
      NULL,
      1,
      0.339893,
      1,
      NULL,
      1,
      4.245240,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.989851,
      3,
      2.078414,
      2.263623,
      0,
      0.249971,
      3,
      5.294416,
      NULL,
      NULL,
      NULL,
      NULL,
      2.232190,
      1.032285,
      0.340486,
      3.106052,
      3.867394,
      1.612296,
      3.354182,
      3,
      3,
      4,
      0,
      NULL,
      NULL,
      2,
      0,
      2.038460,
      0.218851,
      1.438658,
      3,
      0,
      2,
      1,
      0,
      1.478790,
      4,
      4.539642,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012140,
      NULL,
      NULL,
      0.563905,
      0,
      1,
      1.519350,
      0.721673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810376,
      NULL,
      NULL,
      0.488943,
      NULL,
      NULL,
      0.654890,
      NULL,
      NULL,
      3.448794,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.518239,
      NULL,
      0.108097,
      0,
      1.497776,
      NULL,
      1,
      NULL,
      NULL,
      0.716751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.716373,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.055390,
      NULL,
      NULL,
      1.722749,
      NULL,
      NULL,
      1.324913,
      NULL,
      NULL,
      0.426591,
      NULL,
      NULL,
      0.964144,
      NULL,
      NULL,
      1.255499,
      NULL,
      1,
      NULL,
      5,
      NULL,
      NULL,
      0.098570,
      1.465511,
      NULL,
      NULL,
      NULL,
      1.493007,
      0.867630,
      NULL,
      0,
      0.668575,
      NULL,
      1,
      0.442042,
      0,
      0,
      0.479497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.056885,
      NULL,
      0,
      0.959104,
      NULL,
      1.037241,
      0,
      NULL,
      2.854360,
      0.925913,
      0,
      1.517383,
      NULL,
      0.390329,
      2.858836,
      NULL,
      0.736549,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.400340,
      0,
      NULL,
      0,
      0,
      NULL,
      1.350963,
      NULL,
      NULL,
      0,
      1.112074,
      NULL,
      NULL,
      1,
      NULL,
      0.289916,
      3,
      NULL,
      1,
      1,
      NULL,
      1.374034,
      1.850136,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205987,
      NULL,
      0,
      NULL,
      1.634761,
      NULL,
      NULL,
      0.698485,
      2.532179,
      0.890184,
      NULL,
      NULL,
      50,
      64.355257,
      1.152596,
      NULL,
      0.667863,
      NULL,
      '',
      '',
      0.446357,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


