set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9510703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '1340310',
      NULL,
      0.589853,
      NULL,
      0,
      '1233',
      2,
      1,
      NULL,
      NULL,
      ' 1- 3-2000',
      8,
      NULL,
      3.275439,
      2,
      0.673913,
      NULL,
      40.163337,
      3.763880,
      NULL,
      45.116285,
      2.221456,
      NULL,
      ' 3- 1-1984',
      ' 1-20-1981',
      3,
      1.594904,
      NULL,
      1.840334,
      0.237851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      26,
      2,
      4.071057,
      7,
      2.389669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693079,
      1.207461,
      4,
      NULL,
      2.771328,
      1.717857,
      1,
      NULL,
      NULL,
      3,
      3,
      0,
      0.247331,
      1,
      0.200338,
      1.441416,
      7.607004,
      0.892142,
      NULL,
      5.456379,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.332717,
      1.870561,
      0.742134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.360087,
      1.294210,
      1.811913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.557522,
      NULL,
      1,
      3,
      NULL,
      0.070483,
      0,
      0.229251,
      NULL,
      1,
      1,
      0.113089,
      0.342696,
      1,
      0.943710,
      0.853592,
      NULL,
      1.848361,
      0,
      0,
      1.662649,
      2,
      1.575541,
      NULL,
      NULL,
      0,
      5,
      4,
      0.991456,
      NULL,
      4.951984,
      4.599864,
      3.679350,
      3.525259,
      1,
      NULL,
      9.527830,
      0.992085,
      6,
      NULL,
      5,
      0.663443,
      0.216195,
      0,
      NULL,
      ' 3-12-1990',
      25.743078,
      NULL,
      3,
      1,
      0.933343,
      0.194564,
      1.181453,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436311,
      0.392691,
      0,
      0,
      0.377543,
      0.187915,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221828,
      0,
      1.111765,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1.555971,
      0.070541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.870493,
      1.710352,
      0.884509,
      3.560843,
      39.365198,
      1,
      0.837903,
      NULL,
      NULL,
      NULL,
      4,
      1.214183,
      0.146282,
      3,
      0,
      NULL,
      0.432801,
      0,
      2.140014,
      2.577894,
      NULL,
      NULL,
      NULL,
      4.525441,
      2,
      3,
      5.147201,
      0.959235,
      0,
      1.397215,
      1,
      1.052257,
      NULL,
      0.762231,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.545926,
      1,
      1.430197,
      6,
      6,
      3.281750,
      NULL,
      5,
      3,
      0.433826,
      0,
      4.163029,
      1,
      3,
      2,
      3.491784,
      2,
      0.090763,
      NULL,
      8,
      22.494694,
      52,
      4,
      3,
      NULL,
      '42032',
      '',
      '',
      1.882814,
      '0004',
      '',
      NULL,
      0.434514,
      '',
      '',
      NULL,
      NULL,
      2.805537,
      82.117449,
      0,
      0.834382,
      NULL,
      NULL,
      NULL,
      NULL,
      3.429875,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.102827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.286110,
      1,
      1.173570,
      NULL,
      0,
      NULL,
      2,
      0.882344,
      0,
      0.341212,
      NULL,
      NULL,
      1.678760,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.112174,
      1.379424,
      0,
      NULL,
      NULL,
      NULL,
      1.216057,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252439,
      NULL,
      NULL,
      1.987666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590590,
      NULL,
      NULL,
      0.013650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923110,
      NULL,
      NULL,
      0,
      0.515696,
      NULL,
      3.448602,
      1.723361,
      1.891577,
      0,
      NULL,
      NULL,
      1.778116,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541502,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.196135,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.094441,
      NULL,
      NULL,
      1.212705,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.912794,
      NULL,
      NULL,
      0.194211,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.801166,
      0.054910,
      0.872046,
      5.898760,
      NULL,
      1.538591,
      NULL,
      0.289947,
      0,
      3,
      2.485903,
      0,
      1,
      2.461702,
      0,
      2.386303,
      NULL,
      1,
      2,
      0,
      1.066149,
      2.476475,
      NULL,
      1.960666,
      2.198793,
      1.327266,
      0.710873,
      2,
      0,
      NULL,
      NULL,
      1.594527,
      0,
      3.215634,
      NULL,
      NULL,
      NULL,
      3.333892,
      3.683225,
      1.291434,
      0.452715,
      0,
      0,
      1,
      2.336253,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.196783,
      NULL,
      NULL,
      1.234184,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.005864,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.272599,
      NULL,
      0.208314,
      0,
      3.062073,
      0.999164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.631405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.196889,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.704817,
      NULL,
      NULL,
      NULL,
      2.901845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211895,
      NULL,
      NULL,
      NULL,
      3.387709,
      NULL,
      NULL,
      NULL,
      0.099970,
      NULL,
      NULL,
      NULL,
      8.065333,
      NULL,
      NULL,
      NULL,
      1.951501,
      NULL,
      NULL,
      NULL,
      2.872273,
      NULL,
      2,
      0.866000,
      NULL,
      NULL,
      1.559473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.134636,
      NULL,
      1,
      104,
      6,
      NULL,
      NULL,
      0.428307,
      0,
      1,
      0,
      NULL,
      1.778252,
      1.393104,
      0,
      NULL,
      1.142994,
      0.897323,
      0.766816,
      0.236203,
      0,
      0,
      NULL,
      NULL,
      1.503965,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.551212,
      NULL,
      9.818240,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      0.577966,
      NULL,
      1.343090,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.556167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664754,
      1.388465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      1.263240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594408,
      1.453819,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432947,
      1,
      2,
      5,
      2,
      3.957509,
      2.906876,
      3,
      NULL,
      1.363030,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.906132,
      NULL,
      0,
      1.693463,
      NULL,
      0,
      NULL,
      NULL,
      0.686191,
      NULL,
      NULL,
      0.239226,
      1,
      NULL,
      1,
      1,
      NULL,
      0.275532,
      0,
      NULL,
      1.794459,
      1,
      NULL,
      0.719514,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1.025560,
      1.472054,
      1,
      NULL,
      NULL,
      26,
      NULL,
      0.673185,
      NULL,
      1,
      NULL,
      '24312',
      NULL,
      NULL,
      '2134',
      NULL,
      '',
      0.467610,
      '',
      '',
      '');
commit;
end;
/


