set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935282';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      2,
      '1103',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      32.994361,
      NULL,
      4,
      0.273419,
      1.208901,
      ' 8- 1-1995',
      0.440901,
      1.940198,
      165.147915,
      NULL,
      2,
      '10- 3-1989',
      NULL,
      ' 4-17-1981',
      2,
      3.104792,
      NULL,
      3.576922,
      1,
      3.969449,
      2,
      1.437592,
      1,
      15.971760,
      2,
      NULL,
      0.541977,
      23.749476,
      26.171855,
      5.640197,
      23,
      2.124259,
      0,
      5,
      1.601998,
      NULL,
      1,
      1.650874,
      0,
      0,
      NULL,
      0,
      0.098291,
      NULL,
      17,
      2.729480,
      4.214897,
      2.646954,
      1.651412,
      0.147985,
      0.545420,
      1,
      1.457198,
      0.897708,
      NULL,
      2.925192,
      1.899099,
      1.338344,
      NULL,
      1.639517,
      NULL,
      1.206188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.284309,
      NULL,
      0.624814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161482,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.326068,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0.403177,
      0.767285,
      1,
      1,
      NULL,
      1,
      0.749010,
      0.638320,
      0,
      NULL,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      9.697336,
      NULL,
      5.023228,
      8.633443,
      1,
      1,
      1.389797,
      2.382808,
      6.430454,
      6,
      NULL,
      0.242736,
      6,
      7.303863,
      0.962460,
      NULL,
      6,
      4,
      6,
      0.328908,
      0,
      0.527869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691963,
      1,
      0.742083,
      NULL,
      NULL,
      1.691046,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.101098,
      0.060127,
      3,
      0.680270,
      1.224028,
      3.457645,
      0,
      1,
      7,
      1,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0,
      6.995298,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657001,
      1,
      1,
      NULL,
      1,
      0.624841,
      2.033141,
      20.617914,
      3.184695,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.596759,
      2.100735,
      NULL,
      3,
      NULL,
      0,
      4,
      3,
      1,
      2.775279,
      2.399548,
      0,
      2.697708,
      NULL,
      1.726510,
      NULL,
      1.546781,
      3.204497,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0.497210,
      1,
      NULL,
      2,
      1.163960,
      11.322405,
      7.239196,
      4.848646,
      NULL,
      3,
      1.985571,
      1.454201,
      NULL,
      0.154603,
      0,
      0.872198,
      2,
      9.827139,
      0,
      2,
      NULL,
      47.328970,
      34,
      30.963219,
      NULL,
      0,
      2,
      '22012',
      '',
      '',
      1.868505,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0,
      18.476236,
      115.584839,
      11,
      0.545863,
      0.704409,
      NULL,
      1.753616,
      0.774242,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.837102,
      NULL,
      NULL,
      0.267281,
      NULL,
      1.260472,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.305314,
      NULL,
      1.817231,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.385489,
      1.052163,
      NULL,
      0.320314,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.290523,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.303970,
      NULL,
      NULL,
      1.343995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034019,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.484474,
      3.269381,
      1.476040,
      2,
      0.796850,
      1,
      1.578836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.961548,
      NULL,
      NULL,
      0,
      1,
      0.573054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.237400,
      NULL,
      NULL,
      2,
      2.005133,
      3.555861,
      3,
      2,
      NULL,
      10.672824,
      5.383238,
      1.632191,
      1,
      4,
      6.389161,
      1,
      0.400775,
      1,
      2.628279,
      NULL,
      1,
      1,
      NULL,
      3,
      3,
      0.716934,
      1.284206,
      10.615323,
      NULL,
      5.798006,
      NULL,
      1,
      2.354794,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.218386,
      2.305418,
      3.756663,
      7,
      NULL,
      1,
      0,
      0.780977,
      6.685390,
      2,
      NULL,
      6,
      0,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.330150,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.898970,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.131026,
      NULL,
      NULL,
      1.373593,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.373301,
      1.889356,
      1,
      0,
      2.949884,
      2.348248,
      NULL,
      NULL,
      0.343575,
      1.936888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.308533,
      NULL,
      NULL,
      0,
      1.514526,
      NULL,
      NULL,
      1.459545,
      3.029423,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      0.519852,
      NULL,
      NULL,
      0.018298,
      NULL,
      NULL,
      NULL,
      0,
      1.723028,
      NULL,
      NULL,
      0.108925,
      3.133020,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      97,
      6,
      NULL,
      4.694189,
      NULL,
      1.707031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0.333100,
      0.288830,
      NULL,
      NULL,
      0.987107,
      NULL,
      0,
      28,
      1.892388,
      0.961638,
      0.454969,
      0,
      0,
      0,
      1,
      1.112436,
      1,
      0,
      NULL,
      1.703320,
      1.967899,
      NULL,
      0.481682,
      0.198584,
      0,
      0,
      1.005991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675877,
      1.091920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.774555,
      0.845310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.586975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.691032,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.700344,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.540664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396076,
      3,
      1,
      2.493585,
      4,
      NULL,
      4,
      4,
      15,
      NULL,
      0,
      NULL,
      1.732307,
      0,
      1.721279,
      1.172355,
      NULL,
      1,
      1.794402,
      1,
      0,
      0.147428,
      0,
      0,
      1,
      0,
      1,
      1.072698,
      0.882889,
      2,
      0.722179,
      0.256279,
      1,
      0.484241,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0.189761,
      0.066890,
      0,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172085,
      1,
      1.233258,
      0,
      0,
      NULL,
      1,
      2.700207,
      NULL,
      2,
      1,
      0,
      71.244461,
      105,
      NULL,
      NULL,
      1.530129,
      '02212',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


