set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '0423222',
      1.470942,
      1,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      1,
      1,
      1.569899,
      ' 5- 9-1995',
      54.922787,
      1.158227,
      114.676999,
      56.339466,
      3,
      '10-17-1981',
      '11- 7-1987',
      ' 9-12-1995',
      0,
      3,
      1,
      2.155195,
      0,
      1.451249,
      2,
      0,
      0,
      8,
      7.553588,
      9.717895,
      1.549716,
      9,
      NULL,
      3.313766,
      NULL,
      0,
      2.709014,
      NULL,
      0.842390,
      1,
      0.029886,
      1,
      0,
      1,
      NULL,
      1.752318,
      1,
      0,
      NULL,
      NULL,
      8,
      0,
      3,
      NULL,
      0.201005,
      1.233180,
      0.518436,
      0.755733,
      0,
      0.263567,
      0.262674,
      0.349565,
      0.258151,
      1.485961,
      1,
      0.742642,
      1,
      3.039630,
      1.353016,
      1,
      1.808591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.048989,
      2,
      2,
      NULL,
      1,
      1,
      NULL,
      2,
      0,
      3,
      NULL,
      NULL,
      3.083462,
      NULL,
      1,
      1,
      1,
      1.548628,
      0,
      3.327098,
      0,
      NULL,
      9,
      0.324025,
      2.997389,
      1.538293,
      1.340503,
      NULL,
      NULL,
      1.979836,
      NULL,
      NULL,
      0,
      NULL,
      2.922852,
      1.334750,
      7,
      5.756218,
      4.762574,
      1.843749,
      NULL,
      0,
      5,
      0.873161,
      1.716189,
      1,
      0.642376,
      1,
      1.009148,
      0,
      5.460581,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      6,
      0.578001,
      7.546898,
      0.395924,
      1,
      NULL,
      3,
      NULL,
      3,
      NULL,
      9.396698,
      8.756536,
      0.459679,
      3.654696,
      1,
      7,
      9.524723,
      NULL,
      5,
      1,
      1.122320,
      ' 3-26-1977',
      461.073331,
      ' 8-13-1982',
      1038,
      NULL,
      1.759844,
      1.787139,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091694,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.515372,
      1,
      NULL,
      0,
      1,
      0.217405,
      0.193802,
      0,
      7,
      2,
      0,
      7.000149,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.439489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1.360737,
      NULL,
      0,
      0.332720,
      3,
      NULL,
      3,
      NULL,
      NULL,
      65.399815,
      3,
      1,
      0.534402,
      3,
      0,
      NULL,
      5.950497,
      1.875600,
      2.150799,
      1,
      0,
      NULL,
      NULL,
      3.882667,
      1,
      3,
      3,
      1,
      0.583785,
      1.664545,
      4.365257,
      0.468690,
      0.306009,
      0.019795,
      NULL,
      1,
      0.248668,
      0.936676,
      NULL,
      0,
      0,
      0,
      1.425298,
      9.549643,
      NULL,
      7.810738,
      NULL,
      0,
      1.272073,
      3.217015,
      0,
      NULL,
      1,
      2,
      NULL,
      58.121760,
      0.911246,
      1,
      NULL,
      29,
      NULL,
      NULL,
      0,
      1,
      0,
      '02104',
      '',
      '',
      0.796542,
      '',
      '',
      '',
      1.465826,
      '',
      '',
      '',
      3,
      13,
      242,
      NULL,
      2.611592,
      9,
      0.141656,
      10.097778,
      7,
      0,
      1.053924,
      0.942980,
      0.000618,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.387348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859889,
      NULL,
      NULL,
      8.060190,
      NULL,
      2,
      1.681371,
      1,
      NULL,
      NULL,
      NULL,
      0.844282,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.720174,
      0.958279,
      3.223809,
      3,
      0.700286,
      2,
      NULL,
      3.850490,
      1.477488,
      0.687444,
      2,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.085991,
      1.954693,
      NULL,
      0.652894,
      3,
      1.676511,
      2,
      3.381660,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      1,
      1.629944,
      0.980751,
      NULL,
      NULL,
      NULL,
      1.468074,
      NULL,
      NULL,
      NULL,
      1.507966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078850,
      3,
      1.824330,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.231901,
      0,
      0.127564,
      0,
      NULL,
      NULL,
      NULL,
      1.265931,
      1.301878,
      0.530326,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.726332,
      NULL,
      NULL,
      2.444007,
      NULL,
      0.336696,
      NULL,
      NULL,
      NULL,
      3,
      2.934163,
      2.974397,
      1.956356,
      0.813867,
      NULL,
      0,
      1.025023,
      5,
      1,
      0.251846,
      3.827297,
      2,
      5.006266,
      3.931610,
      NULL,
      3.771620,
      NULL,
      3,
      0.978576,
      3.822655,
      NULL,
      3.149491,
      2,
      4.218569,
      0,
      2,
      3,
      3.252427,
      1.477773,
      0,
      3,
      3,
      3.178037,
      1,
      1,
      3,
      3,
      2.785658,
      0.282166,
      2.435950,
      5.400075,
      0.129410,
      0.216352,
      1.540166,
      0,
      2.150249,
      4,
      0,
      0.966729,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.737330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.270587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.230478,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      105.329948,
      NULL,
      NULL,
      NULL,
      1.423768,
      NULL,
      NULL,
      NULL,
      1.099886,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.306665,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.228817,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6.596834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      166,
      7.592215,
      1.547990,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.456039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453727,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      47,
      30.893592,
      0.452129,
      0,
      0.228347,
      1,
      0,
      0.054451,
      1,
      0.319047,
      1,
      2,
      1.149740,
      1.415151,
      0.165456,
      1,
      NULL,
      1,
      1.841945,
      2.614504,
      NULL,
      0.637963,
      NULL,
      0.275170,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.433907,
      NULL,
      0.530087,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.297675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.475547,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994847,
      NULL,
      0.388086,
      0,
      1.755705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.561143,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.191885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763117,
      NULL,
      0,
      NULL,
      1,
      0.530021,
      1.055088,
      4,
      59.642930,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1.552231,
      0,
      NULL,
      3,
      0.058070,
      0.950298,
      1.587614,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.888306,
      NULL,
      NULL,
      0.670882,
      NULL,
      1,
      1.655235,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.154456,
      0.932375,
      NULL,
      0.893822,
      1.838719,
      NULL,
      0,
      1,
      NULL,
      2,
      1.025978,
      1.717215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762761,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.046171,
      1.097133,
      NULL,
      3.017876,
      0.754441,
      0.638876,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      '',
      NULL,
      0.617202,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '');
commit;
end;
/


