set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '1231124',
      NULL,
      NULL,
      NULL,
      0,
      '2434',
      2,
      0,
      NULL,
      NULL,
      ' 2-21-1978',
      NULL,
      NULL,
      4,
      0,
      1,
      ' 3-20-1976',
      51.110930,
      0,
      346.811858,
      38,
      1.539784,
      NULL,
      ' 3-20-1974',
      ' 6- 8-2000',
      NULL,
      2,
      3.484274,
      0.152266,
      NULL,
      1.826189,
      NULL,
      0.049810,
      1,
      191,
      0.585005,
      11.227694,
      NULL,
      6.753785,
      4,
      3,
      18,
      NULL,
      3,
      5.100527,
      NULL,
      1.944357,
      NULL,
      1,
      0.567429,
      1.999834,
      0,
      NULL,
      1,
      0.827482,
      31,
      10.308368,
      NULL,
      1.920341,
      1.383712,
      4.999244,
      0,
      NULL,
      0,
      0.240833,
      0.897382,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0.926074,
      1,
      0.289333,
      1.930750,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      2.863341,
      1.057299,
      NULL,
      1.816616,
      1,
      1,
      2.150343,
      1,
      0.850092,
      0,
      0.202031,
      0.180358,
      0,
      1.795655,
      0,
      1.269870,
      1.807919,
      0.608254,
      NULL,
      0,
      NULL,
      NULL,
      0.095431,
      NULL,
      0.057543,
      NULL,
      NULL,
      NULL,
      0.265992,
      NULL,
      NULL,
      0.865152,
      NULL,
      NULL,
      0.069647,
      8.830040,
      0.566501,
      7.501205,
      NULL,
      NULL,
      1.492105,
      1,
      1.450671,
      1,
      1.754931,
      0,
      0.408453,
      1,
      NULL,
      0.338631,
      0,
      1.132231,
      5,
      1.197926,
      NULL,
      0,
      0,
      3.926548,
      5,
      1,
      4,
      0.420777,
      0.821692,
      NULL,
      2.098005,
      4,
      4,
      4.604666,
      1.679466,
      9,
      NULL,
      NULL,
      9.849208,
      7,
      11.809941,
      0.660559,
      1,
      2,
      NULL,
      ' 7-16-1978',
      423,
      ' 1-22-1985',
      386,
      0,
      0.032096,
      NULL,
      6,
      3.256829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.991552,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763823,
      NULL,
      NULL,
      NULL,
      NULL,
      2.372011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510497,
      0,
      0,
      0,
      1.342010,
      1.510691,
      2,
      1.456973,
      0,
      0.659523,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      7.632671,
      0.641283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.363876,
      NULL,
      1.988659,
      1,
      0,
      1.369867,
      NULL,
      NULL,
      0,
      3.178978,
      1,
      3,
      79.095375,
      3.711255,
      0,
      NULL,
      0.819104,
      2.864351,
      0,
      3.628221,
      2.130011,
      2.948567,
      2.608879,
      NULL,
      0.124509,
      3,
      3,
      NULL,
      3.220176,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.853183,
      1,
      1,
      1.049843,
      1.212936,
      1,
      1.197257,
      0.950897,
      1.695100,
      1.752629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      14.594068,
      33,
      38,
      NULL,
      5.196948,
      3.925318,
      '02114',
      NULL,
      '',
      1.189171,
      '',
      '',
      '',
      1.377835,
      NULL,
      '',
      '',
      NULL,
      38.110953,
      79,
      NULL,
      2.115249,
      43,
      NULL,
      11.638414,
      5.704240,
      0.219123,
      NULL,
      0.709721,
      1.471473,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.141773,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.320236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145870,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.515846,
      NULL,
      6,
      NULL,
      0.926670,
      NULL,
      NULL,
      NULL,
      0.445514,
      NULL,
      NULL,
      NULL,
      2.119001,
      2.041271,
      1.190239,
      1.568596,
      2,
      1,
      3,
      NULL,
      2.358174,
      1.464547,
      0.358895,
      1,
      3.854511,
      1,
      0.247412,
      0,
      2,
      1.115142,
      2,
      1,
      1.229355,
      1,
      3.969392,
      NULL,
      0.611505,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.024097,
      NULL,
      NULL,
      5,
      0.738861,
      4,
      1.641402,
      1.187743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.160681,
      NULL,
      NULL,
      NULL,
      2.912335,
      3.018527,
      1.519589,
      NULL,
      NULL,
      NULL,
      2.302644,
      3,
      0.443689,
      NULL,
      3,
      1,
      NULL,
      NULL,
      2.364091,
      1.840931,
      0.202979,
      0.798287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014443,
      NULL,
      NULL,
      0.682757,
      NULL,
      NULL,
      3.572852,
      1.039433,
      NULL,
      0.514086,
      NULL,
      NULL,
      0,
      2,
      2.529033,
      3.328705,
      NULL,
      1,
      NULL,
      3.743038,
      2.869287,
      3,
      NULL,
      NULL,
      1.276009,
      4.651889,
      5,
      2,
      NULL,
      NULL,
      1,
      3,
      0.394284,
      1,
      2,
      3,
      4.888937,
      5.971102,
      3,
      1.945302,
      2.312213,
      2,
      1.620608,
      0,
      0,
      NULL,
      3.455616,
      NULL,
      0.826829,
      1.893830,
      2,
      0,
      3,
      NULL,
      2,
      0.834905,
      0,
      2.870394,
      0,
      4,
      1,
      1,
      1,
      1.171079,
      1,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252683,
      NULL,
      NULL,
      1.773598,
      NULL,
      NULL,
      1.890814,
      NULL,
      NULL,
      0.528589,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.804668,
      NULL,
      NULL,
      1.173021,
      NULL,
      NULL,
      0.442895,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      79,
      NULL,
      NULL,
      NULL,
      3.516464,
      NULL,
      NULL,
      NULL,
      1.419420,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.172693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.700456,
      NULL,
      NULL,
      NULL,
      1.211344,
      NULL,
      NULL,
      NULL,
      1.932936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443156,
      NULL,
      NULL,
      NULL,
      3.724950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      321,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.800189,
      NULL,
      NULL,
      0.728757,
      NULL,
      NULL,
      1.317009,
      NULL,
      1.476801,
      11,
      0,
      0.336199,
      1.960101,
      1.209741,
      1.392933,
      0,
      0,
      1,
      0.988457,
      0,
      1.141615,
      0,
      0.925010,
      NULL,
      1.995232,
      NULL,
      1,
      1,
      3,
      NULL,
      1.101861,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.652880,
      NULL,
      NULL,
      NULL,
      0.450608,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.531770,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.878420,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.419640,
      NULL,
      36,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.261508,
      NULL,
      1.273008,
      0.705107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670946,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.132121,
      NULL,
      1.247273,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.531725,
      1,
      2,
      1,
      20,
      1.893696,
      NULL,
      NULL,
      NULL,
      1.140499,
      0.666298,
      1,
      NULL,
      0.029924,
      1.743260,
      0.758196,
      0.200131,
      0.805219,
      NULL,
      1,
      0,
      0,
      1.122261,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.786349,
      NULL,
      1,
      1,
      NULL,
      1.298422,
      0.505078,
      NULL,
      1.411204,
      NULL,
      NULL,
      1.880823,
      2.802264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0.240210,
      0.442496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.857584,
      NULL,
      0,
      NULL,
      4.431237,
      5.424871,
      5.888252,
      NULL,
      NULL,
      1.500497,
      16,
      0.568918,
      NULL,
      5.534697,
      NULL,
      '02334',
      '',
      NULL,
      1.337668,
      NULL,
      '',
      '',
      1.883024,
      '',
      '',
      '');
commit;
end;
/


