set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7800082';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '2244032',
      3,
      0,
      2,
      0,
      '1034',
      1,
      2,
      4.450411,
      NULL,
      ' 7-26-1977',
      47.003895,
      NULL,
      1,
      3.042155,
      1,
      ' 2- 9-1976',
      92.515105,
      4.828555,
      NULL,
      136.027251,
      NULL,
      NULL,
      NULL,
      '11-15-1976',
      1,
      1,
      NULL,
      1.970113,
      0.838435,
      2.479969,
      0.870614,
      0.767977,
      NULL,
      10,
      4,
      NULL,
      6.755821,
      16,
      24.751879,
      2.926543,
      18.522671,
      0,
      NULL,
      NULL,
      1.921751,
      0.978191,
      0,
      1.232876,
      1.957807,
      0,
      1.742805,
      0.720480,
      1,
      0.915285,
      1.283562,
      1,
      0.353218,
      1,
      3,
      NULL,
      0.850768,
      1,
      1.843165,
      NULL,
      NULL,
      1,
      NULL,
      0.069366,
      NULL,
      0.346632,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.214524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.332741,
      0.269660,
      2,
      0,
      3,
      1,
      1,
      1.735096,
      1,
      5.100277,
      1,
      1,
      NULL,
      NULL,
      1.620947,
      1.684167,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.490887,
      NULL,
      2.041714,
      NULL,
      1,
      4,
      9,
      2,
      2.525682,
      3.757808,
      4,
      3,
      4.206028,
      NULL,
      0,
      0,
      4.778996,
      4,
      1,
      3.102009,
      2,
      2,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.780104,
      0,
      NULL,
      0.805628,
      4,
      0,
      2.448159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154470,
      1,
      0.380974,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.122468,
      3,
      0.339166,
      1,
      NULL,
      1.924967,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      1.599977,
      0,
      1.078793,
      1,
      1,
      0,
      0,
      0.385008,
      2.152886,
      3.954050,
      0,
      2,
      3.114279,
      1,
      1,
      0,
      0,
      0,
      0.188054,
      4,
      NULL,
      1,
      NULL,
      1,
      1.936174,
      3.206777,
      NULL,
      1.503636,
      0,
      3.731786,
      2,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.902410,
      2.665639,
      1.029994,
      1.750601,
      1,
      26.112084,
      NULL,
      1.367730,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      '11420',
      '',
      NULL,
      1.059720,
      '',
      '',
      '',
      3.492120,
      '4433',
      '',
      '',
      3,
      NULL,
      212,
      32.716977,
      0,
      23,
      5,
      12,
      5,
      3.933335,
      3,
      1,
      NULL,
      0,
      0.508216,
      1.520677,
      NULL,
      NULL,
      0,
      1,
      0.566780,
      1.107863,
      NULL,
      NULL,
      0.164435,
      NULL,
      NULL,
      1,
      2,
      0.545849,
      NULL,
      NULL,
      NULL,
      3.035074,
      2,
      0.168591,
      2.180609,
      NULL,
      0.881107,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      7.307691,
      0.308970,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.600204,
      3,
      NULL,
      0.453356,
      1,
      2,
      3.311686,
      0.694688,
      0.682490,
      NULL,
      1.848939,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.391074,
      1,
      0.525212,
      NULL,
      1.197574,
      2,
      0.790689,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.386056,
      NULL,
      NULL,
      3.987849,
      3,
      6.055673,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.609694,
      0.871097,
      2.607925,
      0.211265,
      0.135711,
      0,
      NULL,
      0,
      1.392925,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      2,
      0,
      1.185867,
      NULL,
      NULL,
      NULL,
      5,
      2.304241,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244779,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2.891493,
      2,
      3,
      1,
      2,
      6,
      0.484227,
      6,
      5,
      2,
      6.191486,
      4.599715,
      0.841602,
      3,
      2.038899,
      NULL,
      2,
      1.894559,
      3,
      0,
      1.923113,
      2,
      3.513276,
      5.443718,
      4.160874,
      1.480666,
      0,
      1.112872,
      2,
      0.584811,
      NULL,
      0,
      NULL,
      NULL,
      2.177251,
      3,
      2,
      3.747116,
      5,
      NULL,
      5,
      1.143202,
      2,
      0,
      3.071775,
      NULL,
      3,
      0,
      1.101046,
      0.906291,
      1.067699,
      1,
      NULL,
      NULL,
      5.937989,
      NULL,
      NULL,
      8.396844,
      NULL,
      NULL,
      0.690723,
      NULL,
      NULL,
      1.981058,
      NULL,
      NULL,
      1.175395,
      NULL,
      NULL,
      2.982062,
      NULL,
      NULL,
      1.491432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.268469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0.641529,
      2.127513,
      NULL,
      NULL,
      2.127488,
      0.758692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363612,
      NULL,
      NULL,
      NULL,
      0.299630,
      NULL,
      NULL,
      NULL,
      1.365269,
      NULL,
      NULL,
      1.435459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.387674,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.725520,
      0,
      NULL,
      NULL,
      0.805063,
      0.772299,
      NULL,
      NULL,
      0,
      1.090495,
      NULL,
      NULL,
      3.177436,
      3,
      NULL,
      NULL,
      0,
      3.148969,
      NULL,
      NULL,
      1.433510,
      2.571761,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5.085237,
      1,
      NULL,
      NULL,
      1.120110,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.133294,
      1,
      1.850884,
      0.256783,
      NULL,
      NULL,
      0.657199,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.817884,
      1,
      0.358656,
      NULL,
      NULL,
      0,
      23,
      4,
      0.074186,
      0,
      1.557975,
      0.393721,
      1,
      0,
      1,
      1.294028,
      1.786983,
      0,
      1,
      0.268623,
      1.112960,
      NULL,
      NULL,
      NULL,
      1.356002,
      0.693120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7,
      0.112602,
      1.015342,
      2,
      1.407888,
      NULL,
      1.450221,
      8.553405,
      NULL,
      3.473320,
      NULL,
      NULL,
      0,
      0,
      2.640280,
      3,
      1,
      3,
      0.906053,
      2.771873,
      1.138755,
      0.889797,
      1.946120,
      3,
      2,
      2.704698,
      1.724505,
      3,
      0,
      1.167630,
      1,
      3.309625,
      NULL,
      1.437180,
      1.348852,
      0,
      0.479283,
      1.508364,
      1,
      2.745703,
      2,
      1.966657,
      3,
      1,
      2.140424,
      1.393634,
      0.334588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550222,
      0.031362,
      1.130513,
      1,
      1.964092,
      0.746580,
      5.441167,
      11.958446,
      9,
      3.361765,
      0.264098,
      3.856684,
      NULL,
      15,
      2.883544,
      NULL,
      2.623004,
      NULL,
      '',
      NULL,
      1.651083,
      '',
      NULL,
      '',
      1.533520,
      '1402',
      '1402',
      '4112');
commit;
end;
/


