set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924136';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '2232242',
      1.487844,
      1.049817,
      2,
      0,
      '0040',
      0.981531,
      1.709629,
      NULL,
      NULL,
      ' 0-13-1985',
      NULL,
      NULL,
      7,
      0,
      1,
      NULL,
      34.130722,
      2,
      NULL,
      35.576211,
      2,
      ' 4- 1-1978',
      ' 5-17-1988',
      ' 1-17-1981',
      3,
      NULL,
      NULL,
      0.736127,
      0.239411,
      NULL,
      2.153254,
      0.500088,
      NULL,
      38,
      6.329527,
      17.592329,
      0,
      22,
      NULL,
      4.653274,
      15.940445,
      7.993361,
      3,
      2.700229,
      0,
      1,
      1,
      0,
      1.370898,
      NULL,
      1.125127,
      0,
      1,
      NULL,
      1.142666,
      2,
      NULL,
      3,
      NULL,
      7,
      NULL,
      1,
      NULL,
      3,
      0.981107,
      8,
      1,
      NULL,
      0.509394,
      NULL,
      0.988762,
      5,
      1,
      1.565717,
      1.510820,
      1,
      1.194155,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.773619,
      3.133022,
      1.683756,
      2,
      0.033791,
      NULL,
      3,
      NULL,
      0,
      3.124860,
      3.253793,
      3,
      2.136028,
      3,
      0,
      0,
      3.064452,
      0.371393,
      0,
      3,
      0,
      1.226170,
      NULL,
      1,
      NULL,
      0.599742,
      0,
      NULL,
      NULL,
      1.445892,
      NULL,
      NULL,
      0.920213,
      3,
      2,
      0,
      1.026767,
      3,
      6,
      0,
      4.190189,
      5.757306,
      NULL,
      0.365605,
      0,
      9,
      NULL,
      0,
      1.310375,
      0.975926,
      0,
      NULL,
      0.525771,
      0.384322,
      3.386458,
      0,
      1,
      0.789584,
      0,
      2.325829,
      3.677106,
      0.980385,
      0,
      0.413655,
      1,
      2,
      0.816241,
      1.861776,
      0.686108,
      0,
      4.593474,
      1.912626,
      6,
      1.743394,
      3,
      9,
      1,
      NULL,
      6.984061,
      3,
      ' 1- 3-1988',
      263.251548,
      ' 3-11-1986',
      NULL,
      3.761075,
      0,
      0,
      NULL,
      1.100797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774022,
      1.722047,
      2.545616,
      2.217309,
      NULL,
      0,
      0,
      0.781745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.346353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160427,
      NULL,
      0.783192,
      0.285190,
      3.258658,
      9.387351,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.691695,
      NULL,
      1,
      0,
      0.045942,
      NULL,
      NULL,
      0.003422,
      12.610314,
      1,
      0.184421,
      NULL,
      NULL,
      NULL,
      2.169289,
      NULL,
      2,
      0.820114,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.195682,
      NULL,
      NULL,
      1,
      1.114188,
      3,
      1,
      NULL,
      NULL,
      0.105552,
      2.918987,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0.180689,
      NULL,
      1,
      0,
      NULL,
      1.639894,
      11,
      11,
      1,
      0,
      NULL,
      7.950953,
      3,
      1,
      NULL,
      0.995346,
      0,
      NULL,
      15,
      0.601149,
      2,
      NULL,
      NULL,
      15.598237,
      NULL,
      0,
      0.389424,
      1,
      '03143',
      '',
      '',
      1,
      '',
      '',
      '',
      0.392557,
      '',
      '',
      '',
      1.141321,
      37.989605,
      141,
      21.873404,
      NULL,
      0,
      3.601965,
      1,
      1.309058,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.591935,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.166572,
      2.264827,
      0,
      NULL,
      NULL,
      2.332834,
      0,
      0.956463,
      1.003255,
      1.156729,
      1,
      1.373591,
      1,
      NULL,
      1,
      2.647685,
      1,
      1,
      0.295865,
      1.868441,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.158199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.378468,
      2,
      0,
      0,
      1.579921,
      2.014416,
      0,
      2,
      2,
      1,
      2.410962,
      0.618211,
      2,
      0.097912,
      NULL,
      3,
      2.423557,
      0,
      1.914675,
      NULL,
      3,
      1.727118,
      1.448243,
      NULL,
      NULL,
      1.278836,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.209885,
      NULL,
      6,
      1,
      1.899654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170135,
      NULL,
      NULL,
      0.304277,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.963288,
      NULL,
      NULL,
      5,
      1,
      1.043834,
      0.787939,
      1,
      0,
      3.650701,
      NULL,
      NULL,
      5.345168,
      1.172020,
      3,
      NULL,
      NULL,
      NULL,
      1.420011,
      NULL,
      NULL,
      1.145683,
      NULL,
      NULL,
      0.653588,
      NULL,
      NULL,
      0.736401,
      NULL,
      NULL,
      1.966614,
      NULL,
      NULL,
      0.821331,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      1,
      2.074512,
      0.741952,
      0.482823,
      2.633201,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.880397,
      NULL,
      NULL,
      1.570535,
      0.679930,
      3.364009,
      1,
      1,
      0,
      2.343885,
      1,
      NULL,
      3,
      NULL,
      1.116682,
      3.283886,
      2,
      2,
      1.378018,
      2,
      7.584878,
      6.337793,
      NULL,
      4,
      1,
      2,
      3.633099,
      1,
      NULL,
      1.741282,
      0,
      0.160536,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916067,
      NULL,
      NULL,
      0.142804,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.986661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.771439,
      NULL,
      NULL,
      1,
      0,
      3,
      0.391669,
      0,
      1.930162,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.768062,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.172488,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.105234,
      NULL,
      NULL,
      NULL,
      0.172229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923649,
      NULL,
      NULL,
      NULL,
      1.242469,
      NULL,
      NULL,
      NULL,
      1.391640,
      NULL,
      NULL,
      NULL,
      0.878968,
      NULL,
      NULL,
      NULL,
      3.988253,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.801106,
      0.751272,
      NULL,
      NULL,
      NULL,
      0.100543,
      NULL,
      NULL,
      1.346892,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.179499,
      NULL,
      NULL,
      109.899662,
      1,
      NULL,
      1.175074,
      1.490389,
      0,
      0.012947,
      1.696367,
      0.305095,
      0.836345,
      NULL,
      NULL,
      0.289142,
      1,
      0.287371,
      0.705795,
      1.466355,
      0,
      NULL,
      1.316243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.351301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      1,
      0.468826,
      NULL,
      0,
      1.823756,
      NULL,
      2.472567,
      1,
      NULL,
      1,
      2.712762,
      NULL,
      0.500231,
      0,
      NULL,
      0.897977,
      0.476216,
      NULL,
      1,
      NULL,
      NULL,
      0.448509,
      0.780175,
      NULL,
      1.418598,
      0,
      NULL,
      1,
      1,
      NULL,
      1.008674,
      1,
      NULL,
      0.030727,
      1,
      NULL,
      NULL,
      1.593678,
      NULL,
      2.222770,
      NULL,
      1.255988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.957744,
      2.266065,
      NULL,
      1.924478,
      NULL,
      1,
      NULL,
      1.767150,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.739792,
      NULL,
      0,
      NULL,
      1.270667,
      NULL,
      3,
      NULL,
      3.339162,
      NULL,
      0,
      NULL,
      7.841686,
      NULL,
      NULL,
      1.672605,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.169666,
      9,
      3.975374,
      1,
      3,
      NULL,
      47,
      2,
      NULL,
      2.150659,
      '20203',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


