set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8920528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1020030',
      2.909512,
      0.882340,
      2,
      0,
      '1011',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1974',
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1985',
      29.281922,
      2,
      2.485912,
      26.234697,
      2,
      ' 9-20-1982',
      NULL,
      ' 1-29-1976',
      NULL,
      1,
      2,
      1,
      1.039451,
      2.847525,
      1,
      1.003854,
      0,
      101.849349,
      NULL,
      NULL,
      3,
      11.277104,
      8.496214,
      1,
      NULL,
      3,
      2,
      5.185077,
      0,
      0,
      1.233827,
      1,
      0.720862,
      1.607186,
      1,
      1,
      1,
      1,
      93.968196,
      NULL,
      9,
      10,
      0,
      0.994606,
      1.414947,
      0,
      2,
      NULL,
      0.386532,
      1,
      0,
      3,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.052316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316579,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.107310,
      5,
      NULL,
      1,
      4.740849,
      3,
      NULL,
      3.309962,
      0,
      0.325558,
      NULL,
      0,
      5,
      0.120244,
      1.858565,
      0.577617,
      1.040268,
      0.144221,
      NULL,
      1.692708,
      5.888893,
      5.065829,
      1,
      1,
      1,
      4.005035,
      6,
      0.393115,
      3.418570,
      7,
      0,
      5,
      NULL,
      8.508896,
      NULL,
      6.112253,
      NULL,
      1.873978,
      3.010237,
      NULL,
      2,
      3.937739,
      9,
      NULL,
      1.826176,
      3,
      0.074694,
      ' 1-21-1976',
      NULL,
      ' 0-15-1999',
      1429,
      0.357551,
      0.576390,
      0,
      2,
      0.427328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.565924,
      0,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      881,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4.879166,
      0,
      NULL,
      NULL,
      NULL,
      0.015644,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.528344,
      1,
      1,
      NULL,
      NULL,
      NULL,
      502.796647,
      1.239597,
      0,
      NULL,
      460,
      1589,
      0,
      1,
      0,
      1.711099,
      1.069223,
      1,
      0.868662,
      NULL,
      1,
      NULL,
      0.244687,
      3,
      0,
      2.655090,
      2.071915,
      1,
      2,
      NULL,
      1,
      0.638514,
      1.780002,
      0,
      0,
      0.091238,
      1.072867,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.670381,
      2.518398,
      0.976520,
      11,
      7.598384,
      3.579520,
      0,
      2.178243,
      3,
      3.149766,
      2.504317,
      1.914766,
      9.060769,
      NULL,
      2.577095,
      NULL,
      33,
      1,
      39,
      3,
      NULL,
      NULL,
      '10031',
      NULL,
      '',
      0.239098,
      '',
      NULL,
      '',
      2.124598,
      '43312',
      '21420',
      '31311',
      2.602883,
      22.838579,
      202,
      NULL,
      0.560733,
      10.592917,
      0,
      1.611441,
      7,
      0.754293,
      0.693275,
      0,
      NULL,
      NULL,
      NULL,
      0.040891,
      NULL,
      NULL,
      3,
      0,
      2.737713,
      NULL,
      2,
      NULL,
      0.579088,
      2,
      0,
      0.956193,
      3.772677,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.382672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.040250,
      0,
      4,
      2,
      1.279890,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248519,
      1.621003,
      0,
      3.006040,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.134009,
      NULL,
      NULL,
      1.845611,
      1,
      0,
      1.852904,
      1,
      NULL,
      0.228660,
      0.494751,
      0.140703,
      NULL,
      3,
      NULL,
      0,
      0,
      1.704858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      2,
      2.246602,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.472861,
      0.336434,
      0.846682,
      NULL,
      1.969791,
      NULL,
      1,
      3.512889,
      2,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      4.032282,
      2.532693,
      NULL,
      1.913883,
      1.939350,
      3,
      NULL,
      NULL,
      NULL,
      8,
      7,
      NULL,
      3,
      NULL,
      0,
      0.585573,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.251475,
      NULL,
      NULL,
      NULL,
      2.632158,
      1.497476,
      NULL,
      3,
      1.446195,
      0,
      NULL,
      1.959361,
      1,
      2.602997,
      0.462222,
      4.830734,
      3,
      4.860280,
      NULL,
      7,
      NULL,
      5,
      6.535048,
      7,
      2,
      3,
      1,
      2,
      3,
      2.209623,
      3,
      2.907262,
      0.825173,
      NULL,
      8,
      NULL,
      NULL,
      1.261105,
      3.465354,
      2,
      NULL,
      0,
      2.064917,
      1.017765,
      0,
      1,
      0,
      0.289748,
      6,
      7,
      7,
      NULL,
      2,
      NULL,
      3,
      4.356767,
      5.172787,
      NULL,
      1,
      0,
      0.656893,
      0,
      0.056718,
      NULL,
      NULL,
      0.159027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513703,
      NULL,
      NULL,
      0.973033,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.786374,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.359378,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.168889,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.685885,
      0,
      0.129727,
      1.384405,
      0,
      NULL,
      3,
      NULL,
      173.107553,
      NULL,
      89.457583,
      NULL,
      1.492752,
      NULL,
      1.214275,
      NULL,
      0.408000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282026,
      NULL,
      NULL,
      NULL,
      1.252143,
      NULL,
      1,
      NULL,
      0.809049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.885393,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.696473,
      NULL,
      0.405494,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      3.171329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.881440,
      NULL,
      1.488180,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.096845,
      NULL,
      10.827053,
      NULL,
      0.536925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039441,
      372,
      271,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.975449,
      NULL,
      NULL,
      1.063904,
      NULL,
      NULL,
      0.550171,
      NULL,
      NULL,
      1,
      30.225793,
      0.161307,
      800,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0.760300,
      0.745280,
      NULL,
      NULL,
      0.709191,
      NULL,
      1.741664,
      0,
      1,
      1.973501,
      3,
      NULL,
      2.815441,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.076980,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383049,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.573675,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.333319,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.118997,
      NULL,
      0.828808,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      0.425815,
      0,
      4.072314,
      0.097523,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1.035858,
      NULL,
      1.689859,
      1.282642,
      NULL,
      0,
      1.586028,
      NULL,
      0.299078,
      1.256807,
      NULL,
      0.687547,
      0,
      NULL,
      0.843763,
      1,
      NULL,
      1.148324,
      1.059946,
      NULL,
      0.219238,
      0.074230,
      NULL,
      3.822212,
      0.965320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620378,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4.219236,
      NULL,
      7.017624,
      1.760739,
      0,
      NULL,
      8,
      28,
      3.720518,
      0.097084,
      4,
      '21142',
      '32301',
      '',
      1.570847,
      '',
      NULL,
      NULL,
      NULL,
      '43144',
      NULL,
      NULL);
commit;
end;
/


