set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8418200';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3404443',
      3.261787,
      0.173818,
      1,
      2,
      '2224',
      0.414463,
      NULL,
      NULL,
      NULL,
      ' 1-15-1985',
      16.193321,
      NULL,
      2,
      0,
      0,
      ' 5-28-2000',
      43.729943,
      1.149308,
      195,
      128,
      2.067274,
      ' 0- 8-1989',
      NULL,
      ' 0-14-1983',
      3,
      2,
      2,
      2.038370,
      0.921068,
      1,
      NULL,
      0.706384,
      NULL,
      NULL,
      NULL,
      5.743985,
      5,
      8,
      20.956666,
      3,
      27,
      0.881431,
      NULL,
      6,
      1,
      0.179999,
      1.880634,
      1,
      0.796094,
      0,
      0.643004,
      NULL,
      1.551705,
      0.762925,
      1.631568,
      1.513454,
      5.506757,
      1.945482,
      0,
      2.564047,
      0,
      NULL,
      0,
      NULL,
      NULL,
      11,
      1.777487,
      1.533229,
      1.272654,
      0,
      0,
      5.147692,
      2,
      NULL,
      1.525298,
      0.825458,
      1.129429,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.958499,
      2.923871,
      3.555780,
      NULL,
      0.643354,
      1,
      0,
      NULL,
      NULL,
      0.625971,
      NULL,
      NULL,
      1.712525,
      NULL,
      NULL,
      0.904475,
      1.759037,
      0,
      1.505740,
      NULL,
      3,
      5.997844,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      6,
      9.288742,
      7.927098,
      5.788245,
      0.115142,
      7,
      1,
      4.958282,
      NULL,
      3.903278,
      0.519879,
      1,
      0,
      1,
      1.457670,
      NULL,
      1,
      6.472736,
      0.582669,
      4,
      0.394557,
      1,
      2.808902,
      NULL,
      1.342109,
      NULL,
      1,
      3,
      0,
      3.623959,
      8.957220,
      2.046134,
      8.393821,
      5.370076,
      6.581358,
      5.221157,
      0.905476,
      NULL,
      0.481769,
      1,
      6,
      6,
      3.314346,
      0,
      '11- 7-1996',
      5,
      ' 0-28-2001',
      3,
      0,
      2.122591,
      1.750789,
      NULL,
      1.171752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889342,
      5,
      1.547439,
      1.337557,
      1.357405,
      0,
      NULL,
      1.385396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.245821,
      1.584056,
      0,
      3.071256,
      0,
      6,
      NULL,
      0,
      2.234678,
      NULL,
      NULL,
      NULL,
      1,
      5.235104,
      2.898968,
      4,
      10,
      0.538129,
      NULL,
      NULL,
      NULL,
      NULL,
      9.116114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1.390907,
      0,
      NULL,
      1.355585,
      0.781640,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.623784,
      3,
      0.591491,
      1,
      1,
      2.430910,
      NULL,
      NULL,
      NULL,
      NULL,
      2.830915,
      3.720850,
      0.964030,
      1.518183,
      1,
      0.250241,
      1.229316,
      0.670310,
      1,
      1.923313,
      1.728454,
      0,
      0.687384,
      1,
      0.467271,
      1,
      0.243668,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.246979,
      NULL,
      25.882222,
      2,
      NULL,
      0,
      '40122',
      NULL,
      '14240',
      0,
      NULL,
      '',
      '',
      0.243703,
      '',
      NULL,
      NULL,
      1.473412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.156278,
      597,
      4,
      NULL,
      NULL,
      1,
      NULL,
      1.402057,
      NULL,
      1.661318,
      0.673054,
      3.084888,
      1.871703,
      NULL,
      1.842447,
      0,
      0.061798,
      0,
      1.475763,
      0.324387,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.456532,
      NULL,
      3.470258,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153297,
      NULL,
      NULL,
      NULL,
      1.098433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.741786,
      NULL,
      0.161795,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.340006,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.921930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.324887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.270942,
      3,
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      40.778871,
      NULL,
      0,
      NULL,
      0.176394,
      NULL,
      3,
      NULL,
      NULL,
      1.737015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.979243,
      1.476556,
      1.935292,
      3,
      1,
      2.986385,
      2.991802,
      3.522977,
      NULL,
      1.952841,
      0,
      NULL,
      1,
      0.601298,
      NULL,
      1,
      0,
      NULL,
      0.602977,
      NULL,
      NULL,
      0,
      2.123963,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.160909,
      NULL,
      1.054632,
      1.563732,
      NULL,
      0,
      1,
      NULL,
      0,
      0.454933,
      NULL,
      NULL,
      1.402211,
      NULL,
      NULL,
      0.933326,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.846195,
      5.888978,
      3.769480,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      NULL,
      1,
      3.155378,
      '01401',
      '20232',
      '02323',
      0.869202,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


