set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7616981';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '3200331',
      0.650345,
      1,
      1,
      2,
      '2344',
      1.799043,
      0.228196,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      2.966067,
      NULL,
      1,
      ' 9-21-1991',
      36,
      2,
      125.888614,
      110,
      NULL,
      ' 3- 5-2001',
      NULL,
      NULL,
      3.741498,
      1,
      3,
      1,
      1.043124,
      NULL,
      3,
      1,
      1,
      283,
      7,
      13.012253,
      5.472854,
      22,
      NULL,
      4,
      16.697297,
      NULL,
      NULL,
      0.025433,
      0.448049,
      NULL,
      0.660745,
      0.907311,
      0.490151,
      NULL,
      0,
      0.075536,
      1.417375,
      0,
      NULL,
      13,
      0,
      3,
      1,
      NULL,
      0.438337,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0.246186,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1.122394,
      NULL,
      NULL,
      0.748899,
      NULL,
      NULL,
      1,
      1,
      0.184314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.582746,
      1.783484,
      0.547667,
      0.027844,
      0,
      3.833420,
      1,
      1.625668,
      NULL,
      NULL,
      0.039467,
      NULL,
      NULL,
      1.053157,
      1.271245,
      1.703730,
      NULL,
      NULL,
      NULL,
      3.510794,
      0.938166,
      2,
      5.596297,
      1.053165,
      1.506119,
      0,
      7,
      0,
      NULL,
      1.746209,
      0.196397,
      1.926575,
      NULL,
      NULL,
      0,
      4.462155,
      0,
      5,
      0,
      NULL,
      0.030896,
      0.697932,
      1,
      NULL,
      0.741242,
      NULL,
      3.287183,
      5.133321,
      NULL,
      0,
      NULL,
      4.198320,
      NULL,
      NULL,
      NULL,
      3.178135,
      8,
      3,
      9,
      3,
      0,
      ' 6-24-2001',
      NULL,
      ' 5-19-1996',
      843.513034,
      2,
      1.302315,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.068551,
      1,
      NULL,
      0.697559,
      NULL,
      1,
      0,
      1.607587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934967,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.340751,
      0,
      NULL,
      1,
      0.888256,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.951935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.129693,
      0.345039,
      0,
      1,
      0.678721,
      NULL,
      1.042400,
      1,
      3817.278554,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.238431,
      0.978534,
      1,
      1.830125,
      0,
      2,
      3.131254,
      0,
      2.397217,
      3.510734,
      1.824320,
      3,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      3.810075,
      1.039022,
      1,
      0.089191,
      NULL,
      0,
      0.097589,
      NULL,
      0,
      NULL,
      0.804176,
      NULL,
      0.751909,
      0.802839,
      NULL,
      2.941452,
      NULL,
      4.387689,
      1,
      5,
      1,
      5,
      1,
      0,
      1.467944,
      61,
      1.568191,
      NULL,
      NULL,
      3,
      NULL,
      37.688825,
      1.547484,
      0.059284,
      0.157325,
      '32040',
      '03243',
      '',
      1,
      '',
      '',
      '',
      0.526154,
      '',
      '',
      '',
      2,
      16,
      564,
      21.616479,
      2,
      11,
      4,
      67,
      6,
      1.581380,
      3.858195,
      0,
      1.339068,
      NULL,
      NULL,
      0.326240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768411,
      NULL,
      NULL,
      0.501534,
      0.915238,
      0,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      1.323154,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.495746,
      6.132516,
      4,
      0,
      0.103702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.473591,
      NULL,
      1.344503,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303921,
      0,
      NULL,
      2,
      0,
      1.889685,
      3,
      NULL,
      NULL,
      0.181596,
      0.407812,
      1.234942,
      1,
      2.971859,
      NULL,
      0.511381,
      1,
      0.524752,
      2,
      0.832961,
      NULL,
      NULL,
      1.879306,
      NULL,
      NULL,
      9,
      1.087574,
      NULL,
      1.804299,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.455379,
      NULL,
      NULL,
      NULL,
      NULL,
      3.676185,
      0,
      NULL,
      NULL,
      NULL,
      2.357867,
      3.750785,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4.106629,
      1,
      NULL,
      0.225464,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.710159,
      NULL,
      0.814862,
      5,
      4.984618,
      5.701435,
      1.533054,
      4.377953,
      NULL,
      5.401353,
      1,
      5.535662,
      3.131760,
      2,
      2,
      1.026144,
      3.220840,
      1.223777,
      3,
      1.325446,
      3,
      2,
      2,
      5,
      0,
      2.760277,
      1.219482,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.520804,
      3.644141,
      1,
      3,
      9.448796,
      0.726091,
      9.430830,
      8,
      NULL,
      3.436349,
      1,
      2.263321,
      NULL,
      0.784055,
      0,
      0.910350,
      NULL,
      NULL,
      2.190529,
      NULL,
      NULL,
      0.046893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001085,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164293,
      NULL,
      NULL,
      0.999790,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.001001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.880463,
      NULL,
      NULL,
      NULL,
      2.941690,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574116,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.138220,
      NULL,
      NULL,
      NULL,
      3,
      79.517726,
      214,
      0.093726,
      NULL,
      NULL,
      1.242576,
      NULL,
      NULL,
      0.644968,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322110,
      NULL,
      16.114385,
      0.300034,
      1.887838,
      0.195304,
      NULL,
      1.425670,
      NULL,
      0,
      NULL,
      0.027687,
      0.763309,
      0.429959,
      1.148802,
      1,
      0.884457,
      1.794259,
      1.054040,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236671,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.354759,
      NULL,
      0.115713,
      NULL,
      NULL,
      NULL,
      1.429049,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.833986,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.817336,
      NULL,
      0.367941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.189238,
      NULL,
      NULL,
      NULL,
      NULL,
      3.264575,
      NULL,
      659,
      NULL,
      NULL,
      NULL,
      1.372327,
      NULL,
      1,
      0,
      2,
      35.635207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.936681,
      4.501708,
      9,
      1.311721,
      0,
      1.984422,
      2,
      19,
      3.566245,
      1,
      0,
      0.400387,
      0.191973,
      NULL,
      0,
      1.558935,
      NULL,
      1.592123,
      0.034435,
      NULL,
      1.170869,
      1.572063,
      NULL,
      0,
      0.865733,
      NULL,
      0,
      NULL,
      NULL,
      1.069581,
      2,
      NULL,
      2,
      NULL,
      NULL,
      0.028970,
      0.841305,
      NULL,
      3.739447,
      2,
      NULL,
      1.181457,
      0.720383,
      NULL,
      NULL,
      0.090095,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.181258,
      NULL,
      7,
      5.802251,
      1.037440,
      3.975091,
      NULL,
      3.516555,
      NULL,
      14,
      3,
      0.814331,
      0,
      '11302',
      '11241',
      '',
      0.500529,
      '',
      '',
      '',
      1.971953,
      '',
      '',
      '');
commit;
end;
/


