set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0433144',
      NULL,
      1.881652,
      NULL,
      2,
      '1101',
      1.917842,
      0,
      NULL,
      NULL,
      ' 3-23-1983',
      NULL,
      NULL,
      NULL,
      2,
      1,
      ' 1- 3-2002',
      49.673082,
      NULL,
      212,
      121.877494,
      0.735115,
      '10-13-1993',
      NULL,
      '11-19-1974',
      1,
      3,
      3,
      0.014582,
      NULL,
      1,
      NULL,
      0,
      0,
      71,
      NULL,
      7,
      3.516999,
      4.284533,
      8,
      0.768981,
      1.097103,
      3.756733,
      0,
      5,
      1,
      NULL,
      3.163930,
      1.240590,
      0,
      0,
      NULL,
      0,
      0.626787,
      0,
      1,
      3.158989,
      0,
      2.193404,
      0,
      10.017455,
      0,
      1.280902,
      2.987816,
      0,
      2,
      3.681285,
      1,
      1.463980,
      0.497683,
      1,
      0.775034,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.837114,
      NULL,
      NULL,
      0,
      1.316148,
      0.206543,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314080,
      0,
      0.369001,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.187567,
      3.126245,
      0,
      2.751287,
      NULL,
      4,
      0.304394,
      0,
      3.818948,
      3,
      0.814786,
      0,
      1.937539,
      0.277370,
      0,
      1,
      1.341217,
      0,
      NULL,
      1,
      1,
      0.732761,
      0.267920,
      NULL,
      0,
      0.340795,
      2,
      1.052210,
      1,
      1.663047,
      1,
      NULL,
      5.989443,
      1,
      6,
      8.143474,
      2,
      11,
      NULL,
      NULL,
      3.238291,
      7.597701,
      4,
      1,
      1.838318,
      0,
      3,
      ' 5- 3-2003',
      NULL,
      NULL,
      20.680908,
      NULL,
      1,
      1,
      6,
      0.996124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.390761,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.267577,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      2,
      0.972589,
      NULL,
      3,
      0.770628,
      NULL,
      NULL,
      0.246562,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.848782,
      1.958468,
      1,
      0.977933,
      0,
      1,
      1.548673,
      NULL,
      26,
      2.872676,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.939958,
      0,
      3.222407,
      1,
      2,
      2.995373,
      3,
      1,
      2.507943,
      1,
      0.577235,
      3.804979,
      NULL,
      2,
      2.277646,
      NULL,
      0,
      NULL,
      4,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0.195165,
      NULL,
      2.265443,
      NULL,
      6,
      5,
      0,
      4.371392,
      0.617093,
      0,
      2,
      0,
      2,
      2,
      0,
      NULL,
      14.754713,
      3,
      0,
      NULL,
      29,
      NULL,
      20,
      3,
      0.635238,
      0.727727,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      2,
      '4413',
      '3341',
      '',
      2,
      4,
      172,
      17,
      3.381438,
      NULL,
      NULL,
      NULL,
      2.366128,
      3.480440,
      NULL,
      1,
      0.168045,
      NULL,
      NULL,
      0.163380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.128461,
      1.370629,
      0.207611,
      0.367261,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.669877,
      NULL,
      NULL,
      1.970767,
      NULL,
      NULL,
      1.980886,
      NULL,
      NULL,
      5,
      1,
      1.911662,
      0.221342,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.129586,
      1.313480,
      NULL,
      NULL,
      0.133498,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.185027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      2.105022,
      0.617585,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.949216,
      0.861222,
      NULL,
      NULL,
      2,
      1.332226,
      0,
      1.993959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.774025,
      NULL,
      NULL,
      1.926960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328789,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588476,
      NULL,
      1,
      2,
      3,
      3.233437,
      3,
      NULL,
      NULL,
      NULL,
      2.540581,
      2,
      3,
      2.123123,
      0,
      NULL,
      NULL,
      0,
      1.530515,
      2,
      0,
      2,
      0.760307,
      7.362295,
      5.975765,
      0.232322,
      2.047614,
      3.562702,
      0.929714,
      0,
      NULL,
      NULL,
      NULL,
      1.252619,
      0.597993,
      0.252615,
      0.545314,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.597706,
      3,
      0.151227,
      1,
      NULL,
      1,
      0,
      NULL,
      4.458950,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.385271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.514851,
      NULL,
      NULL,
      NULL,
      0.293912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.482660,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.405013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.231372,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.216546,
      0.175105,
      NULL,
      NULL,
      NULL,
      0,
      2.373511,
      0.623310,
      0,
      1.317499,
      0.168132,
      NULL,
      NULL,
      NULL,
      1.241235,
      2.448226,
      0.655279,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.872759,
      NULL,
      1.139324,
      186,
      16.140275,
      1,
      1.362060,
      1,
      1,
      NULL,
      1.226477,
      1,
      NULL,
      1,
      1.449164,
      1,
      1.416157,
      1.936912,
      NULL,
      NULL,
      NULL,
      0.282224,
      1.532186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      3,
      1.503967,
      NULL,
      NULL,
      2,
      11.563318,
      2.491646,
      2,
      1,
      NULL,
      1,
      NULL,
      1,
      3.775221,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      0.299858,
      NULL,
      0.298829,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.850821,
      2,
      NULL,
      0.249972,
      3.459465,
      NULL,
      3.507800,
      0.222932,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311410,
      2.845734,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.579774,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.253368,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.079188,
      NULL,
      NULL,
      NULL,
      3.223685,
      0,
      NULL,
      NULL,
      51.215937,
      24,
      4,
      0,
      3.397655,
      '22344',
      NULL,
      '',
      0.085755,
      NULL,
      NULL,
      '',
      5,
      '2423',
      '2240',
      '');
commit;
end;
/


