set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      0,
      1.518173,
      2,
      1,
      '2043',
      1,
      0,
      0,
      NULL,
      NULL,
      35,
      NULL,
      3,
      0.660217,
      1.305903,
      ' 3-11-1999',
      15.186325,
      2,
      85.936006,
      98.565536,
      3.835599,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346241,
      0,
      0,
      NULL,
      0.728414,
      5.029981,
      0,
      NULL,
      NULL,
      NULL,
      13,
      2.036161,
      18.063936,
      0.622006,
      4.202850,
      30.026572,
      2.657105,
      0.106851,
      NULL,
      0,
      1,
      0.756254,
      0,
      1,
      0.430011,
      1,
      NULL,
      NULL,
      1.191106,
      1.408692,
      NULL,
      NULL,
      1.575537,
      NULL,
      0.603119,
      0.005610,
      NULL,
      1,
      NULL,
      1,
      0,
      0.946172,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815596,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674030,
      1,
      0.833873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.430306,
      0.752522,
      0,
      NULL,
      0,
      1.396342,
      NULL,
      1.990953,
      1.266510,
      0.107266,
      0.528241,
      NULL,
      1,
      NULL,
      1.482435,
      0,
      0,
      NULL,
      NULL,
      1,
      0.420709,
      NULL,
      0,
      1,
      1.662952,
      0.295732,
      1.471825,
      0.464481,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0.328570,
      NULL,
      0,
      NULL,
      0.165076,
      0.234249,
      0.670235,
      1.766209,
      NULL,
      0.584258,
      1.833626,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.220100,
      1.069219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241111,
      0.156759,
      0.077556,
      0,
      NULL,
      0.357104,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.380040,
      0,
      0.987226,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539849,
      1,
      0.883259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.308036,
      1,
      1,
      0.705433,
      1.809738,
      0,
      NULL,
      0.838157,
      NULL,
      0.923526,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.393596,
      1.010143,
      NULL,
      1,
      2.596635,
      2,
      1.939465,
      1,
      2.010824,
      NULL,
      1.594724,
      NULL,
      2.600884,
      0.637410,
      3,
      2,
      NULL,
      0,
      7.546167,
      NULL,
      0,
      0,
      NULL,
      0.666430,
      0.695672,
      0,
      0,
      2.232274,
      0.308429,
      3.529120,
      NULL,
      NULL,
      8,
      NULL,
      5,
      NULL,
      2,
      5.473157,
      3,
      NULL,
      0.487775,
      0,
      0,
      27,
      1,
      0,
      120.871851,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.888123,
      '',
      '',
      '',
      0,
      15,
      NULL,
      35,
      NULL,
      15,
      2,
      1.299669,
      NULL,
      2.644968,
      0.158149,
      1,
      1.024347,
      NULL,
      NULL,
      0.384227,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.014696,
      NULL,
      NULL,
      0.175761,
      NULL,
      NULL,
      1.432561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693168,
      NULL,
      NULL,
      1.587122,
      NULL,
      NULL,
      1.304306,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.344982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.861701,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072648,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.089899,
      0.873139,
      0.307956,
      2.297904,
      NULL,
      1,
      3.257260,
      0,
      0,
      0.379827,
      NULL,
      NULL,
      1.149940,
      NULL,
      NULL,
      1.925907,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919439,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818491,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.526997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.026837,
      1.677472,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      14.649307,
      0,
      1,
      NULL,
      NULL,
      1.599976,
      NULL,
      NULL,
      1.712181,
      NULL,
      NULL,
      2.770616,
      1.292657,
      0.363459,
      NULL,
      NULL,
      0.022118,
      1.295786,
      NULL,
      NULL,
      0.939697,
      0.973629,
      0,
      0.062364,
      NULL,
      0.619337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595004,
      NULL,
      NULL,
      0.279343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.389236,
      2,
      NULL,
      0,
      2,
      1,
      0.392356,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.749155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.959202,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.956843,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.562715,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10.668297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733264,
      NULL,
      NULL,
      0.293553,
      6.275149,
      1.127891,
      0.575417,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836419,
      NULL,
      NULL,
      1.599763,
      NULL,
      0,
      566.861656,
      0,
      0,
      0.431512,
      1.995578,
      NULL,
      1,
      NULL,
      0,
      2.570424,
      0,
      0.903624,
      NULL,
      NULL,
      0,
      0.459984,
      NULL,
      1.423568,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.322694,
      NULL,
      0.120838,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076933,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278896,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.379162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.270867,
      NULL,
      1.985360,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.869172,
      NULL,
      1,
      NULL,
      0,
      0.613809,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822507,
      1,
      0,
      0.540155,
      3,
      0,
      3.299458,
      1,
      NULL,
      1,
      0.687039,
      1.378409,
      0.489879,
      0.166051,
      0,
      1,
      1.725953,
      1,
      NULL,
      15,
      0.610181,
      0,
      NULL,
      0,
      2.826548,
      3,
      3,
      0,
      NULL,
      1,
      1.056545,
      0.448259,
      1.538192,
      0,
      0.681361,
      0,
      0,
      0.883749,
      1,
      1,
      0.265373,
      0.222721,
      1.134385,
      1.191438,
      NULL,
      0.648624,
      NULL,
      0.725559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.276724,
      1.598974,
      0.154299,
      0,
      NULL,
      1,
      3,
      1,
      0,
      10,
      0,
      2,
      3,
      NULL,
      0.981220,
      3,
      0,
      NULL,
      1,
      2.537206,
      NULL,
      3,
      0,
      NULL,
      1,
      0.600927,
      0,
      9,
      3,
      NULL,
      NULL,
      0.104000,
      1.649238,
      0,
      0.293519,
      0.206753,
      NULL,
      4,
      3.505366,
      0.272951,
      NULL,
      NULL,
      138,
      39.100025,
      4.067873,
      0,
      3,
      '24231',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1.122851,
      '24213',
      '',
      '');
commit;
end;
/


