set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '1412312',
      2,
      1,
      3,
      3,
      '0034',
      3.888344,
      NULL,
      NULL,
      NULL,
      ' 7-10-1975',
      66,
      NULL,
      1,
      2.788000,
      0,
      ' 7- 0-1995',
      57.470410,
      2,
      344,
      280,
      1,
      ' 4-10-1998',
      ' 1-18-1988',
      NULL,
      0.031975,
      1.209139,
      2,
      1.300164,
      0.308936,
      0,
      0,
      2.677970,
      NULL,
      NULL,
      NULL,
      9.243546,
      7,
      22,
      10.656327,
      0.697314,
      NULL,
      NULL,
      2.268705,
      0.151245,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.371852,
      NULL,
      2.550895,
      4,
      NULL,
      1,
      3.148360,
      1.130640,
      0.915161,
      7.925014,
      0,
      NULL,
      0,
      0.284566,
      0.002902,
      6,
      NULL,
      1,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.976452,
      0.447185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.685294,
      0.093371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426197,
      0,
      NULL,
      1,
      1,
      1.235263,
      0,
      0.638779,
      0,
      0.295896,
      0,
      NULL,
      1,
      0.118877,
      0.882538,
      1.709592,
      NULL,
      0,
      1,
      3.267925,
      3.262885,
      0.966030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.371947,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0.755398,
      5.710722,
      1,
      4,
      1,
      0,
      1,
      2.852867,
      0.476626,
      4,
      2.627615,
      ' 2-25-2003',
      58,
      ' 8-16-1979',
      2,
      1,
      1,
      1.369010,
      NULL,
      0.750698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310334,
      1,
      0,
      5.987485,
      1,
      0.906889,
      0.218383,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.806757,
      0,
      2.926031,
      NULL,
      0,
      1.609260,
      1,
      0.882095,
      0.406294,
      NULL,
      2.415794,
      4,
      0,
      NULL,
      NULL,
      NULL,
      0.211780,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.467046,
      NULL,
      NULL,
      0,
      0.294991,
      NULL,
      1.002766,
      NULL,
      1.470051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.765593,
      NULL,
      3,
      0,
      1.803949,
      0.990178,
      0,
      3,
      2.050541,
      1,
      1,
      3.880901,
      NULL,
      0,
      0,
      1.586760,
      NULL,
      3.107597,
      0,
      1.890599,
      NULL,
      0,
      0.811170,
      NULL,
      1,
      1,
      0,
      0,
      1.520154,
      1.375415,
      10,
      11,
      4,
      7,
      7,
      3,
      5.157413,
      NULL,
      1,
      NULL,
      2,
      1.433872,
      NULL,
      3,
      0.361978,
      NULL,
      0.611552,
      31.113612,
      30,
      2.598086,
      NULL,
      4.659809,
      '30420',
      '21121',
      '32422',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.743558,
      NULL,
      98,
      42,
      2,
      2.806454,
      0,
      0.914592,
      2,
      NULL,
      0,
      1,
      1.073895,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.489847,
      0,
      3.129254,
      3,
      0,
      1.996250,
      NULL,
      NULL,
      NULL,
      1.278498,
      1.579846,
      1.285533,
      NULL,
      NULL,
      2,
      1.007476,
      0.693961,
      2.016382,
      0.346079,
      0.915037,
      1.002368,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      8.972101,
      NULL,
      3.799902,
      0.351387,
      NULL,
      NULL,
      NULL,
      1.395935,
      NULL,
      NULL,
      NULL,
      0.615317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.753137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880276,
      NULL,
      NULL,
      3,
      3,
      1,
      3,
      2.639754,
      NULL,
      0.947228,
      NULL,
      NULL,
      3.359861,
      NULL,
      NULL,
      3.183063,
      1.337766,
      1.045915,
      0.670240,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.182885,
      NULL,
      NULL,
      0.746588,
      NULL,
      NULL,
      0.090766,
      NULL,
      NULL,
      0.716178,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.472491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.407366,
      1,
      1,
      1.628699,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.044487,
      3,
      3.521828,
      1.491772,
      2,
      2.190250,
      5.376534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743858,
      3,
      0,
      0.472230,
      3.679032,
      0.506297,
      2.683243,
      6.896496,
      3.212588,
      5.617896,
      2,
      2.656547,
      1,
      1.849102,
      7,
      2.609771,
      0,
      NULL,
      0.960455,
      0.924368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.635461,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.663917,
      NULL,
      NULL,
      3.215216,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.325466,
      1.002792,
      1,
      NULL,
      1.753191,
      NULL,
      NULL,
      NULL,
      2,
      1.230528,
      NULL,
      NULL,
      120.590743,
      NULL,
      NULL,
      NULL,
      2.760442,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.572590,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.759262,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441685,
      0,
      NULL,
      NULL,
      1,
      0.679310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937727,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.732281,
      NULL,
      50.694793,
      1.344770,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      250,
      27.534479,
      1.326315,
      1,
      0.141782,
      0,
      0,
      0,
      0,
      NULL,
      1,
      3,
      0,
      3,
      NULL,
      0.251105,
      0,
      NULL,
      1,
      3.095027,
      NULL,
      1.491797,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.406269,
      NULL,
      2.348879,
      NULL,
      NULL,
      NULL,
      0.159629,
      NULL,
      2.352766,
      NULL,
      0.522216,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.259039,
      NULL,
      2.666264,
      NULL,
      0,
      NULL,
      2.574885,
      NULL,
      0,
      NULL,
      0.163447,
      NULL,
      1.835131,
      NULL,
      1.099105,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.910701,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.319150,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195843,
      NULL,
      1,
      NULL,
      1,
      0.539099,
      1.380718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      0.757449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.029638,
      NULL,
      1.983430,
      1.598432,
      NULL,
      30,
      NULL,
      0.973671,
      0,
      2,
      NULL,
      2.752087,
      5,
      1.659775,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      0.069111,
      0.718144,
      1,
      1,
      2.892232,
      2,
      0.564163,
      0.627028,
      3.368366,
      NULL,
      NULL,
      0.881247,
      NULL,
      1,
      0,
      3,
      0,
      0,
      NULL,
      3.580814,
      0.101831,
      1.217645,
      0,
      1.656630,
      0.563815,
      0,
      1.292148,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      1.958870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418712,
      3.180970,
      2.078038,
      3.928725,
      0.458169,
      0.854339,
      NULL,
      1.662663,
      1,
      0,
      1.840435,
      3,
      2.549307,
      NULL,
      3,
      NULL,
      2,
      1.501622,
      0,
      3.028462,
      NULL,
      0,
      1,
      NULL,
      3.543936,
      1,
      0.084649,
      32,
      NULL,
      NULL,
      NULL,
      1.103878,
      NULL,
      1,
      0,
      1,
      5.118307,
      NULL,
      6.442796,
      1,
      0.763658,
      NULL,
      75,
      75.971938,
      3.945458,
      0.098267,
      4,
      NULL,
      '20024',
      NULL,
      0.771666,
      '',
      '',
      '',
      0.157092,
      NULL,
      '',
      '');
commit;
end;
/


