set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9970404';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.944815,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      '101',
      '30022013',
      86.949791,
      32.809248,
      '4141214',
      1.965513,
      0.744309,
      3,
      1,
      '1330',
      5,
      0.004574,
      NULL,
      NULL,
      ' 1-29-1982',
      103,
      5.053031,
      NULL,
      NULL,
      0.673139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 9- 7-1997',
      NULL,
      ' 6-14-1993',
      1.965809,
      2.354675,
      0,
      0,
      1.040620,
      NULL,
      2,
      NULL,
      1.343260,
      0.308251,
      NULL,
      15.497023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.826309,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1.708946,
      NULL,
      5,
      0.202275,
      2.608834,
      2,
      4.627556,
      0.196427,
      0,
      1,
      0.098081,
      2.608843,
      0,
      2.741381,
      NULL,
      8.444399,
      1,
      0.321874,
      3.469167,
      1,
      1.981898,
      1,
      4.052221,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.486347,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.624459,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      2.170708,
      1.637681,
      2.587172,
      3,
      0,
      3,
      0,
      1.668638,
      3,
      3.957892,
      1.432565,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1.336896,
      NULL,
      1,
      6,
      0,
      0.804084,
      1.547629,
      NULL,
      0.936049,
      0.222824,
      0,
      1.563401,
      2,
      1.693427,
      0.478384,
      0.836622,
      0,
      NULL,
      NULL,
      1.079869,
      2.640063,
      NULL,
      1,
      1.912738,
      1.854228,
      NULL,
      1,
      NULL,
      0,
      4.271223,
      1,
      0,
      4.395814,
      0,
      0,
      3.945631,
      4.598919,
      2,
      8.228294,
      3.162759,
      1.817648,
      2,
      5.913875,
      0,
      1,
      0.734427,
      NULL,
      NULL,
      NULL,
      ' 4-18-1982',
      2210.511633,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408498,
      0.136674,
      5.762166,
      8,
      0.311872,
      5.237247,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.101273,
      5,
      4.099737,
      0,
      6.028694,
      7.918900,
      2.406612,
      5.413403,
      2,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.536011,
      0,
      1.353752,
      NULL,
      0.806469,
      0.078337,
      1,
      3.041763,
      8.126644,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.891989,
      1,
      1.281100,
      NULL,
      NULL,
      1,
      1.125898,
      3.221605,
      3.681843,
      0,
      0.006007,
      3,
      2.028204,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      1.279111,
      1,
      0.769358,
      NULL,
      1,
      0,
      0.012361,
      0,
      0.258201,
      0.802932,
      3,
      NULL,
      7.886301,
      8.781411,
      0,
      2.395028,
      NULL,
      5,
      2.796652,
      NULL,
      6.349150,
      0.759148,
      2.837269,
      NULL,
      57.032303,
      0.548431,
      1.452492,
      1,
      NULL,
      5,
      45.881394,
      2.651398,
      4.596668,
      NULL,
      '12432',
      '',
      '',
      0.291960,
      '',
      '',
      '',
      2.273125,
      '1421',
      '',
      '',
      NULL,
      2,
      38,
      NULL,
      1,
      NULL,
      14,
      35,
      0.628529,
      1.789308,
      1.425330,
      1,
      1.892968,
      NULL,
      NULL,
      0.238187,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2.222253,
      NULL,
      0,
      3.608239,
      2.401227,
      1.236736,
      NULL,
      0.321862,
      NULL,
      0.024410,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1.655324,
      3.266914,
      NULL,
      1,
      3,
      9,
      4.369128,
      1.107192,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.284053,
      0,
      NULL,
      NULL,
      1.122789,
      NULL,
      NULL,
      2,
      3.005209,
      1,
      3.893514,
      1.498588,
      1,
      0,
      3.262936,
      1.431076,
      2.268445,
      NULL,
      0.948416,
      2.079273,
      1.889318,
      2.045527,
      3,
      1,
      2,
      0.353380,
      1,
      NULL,
      NULL,
      2,
      1,
      2.036984,
      1.131500,
      6.431302,
      5.161419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.108066,
      0.953914,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.420513,
      0.371572,
      NULL,
      NULL,
      0,
      3.576833,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.509537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.308053,
      NULL,
      NULL,
      2.652177,
      0.410720,
      3,
      0.489943,
      NULL,
      NULL,
      3,
      0.776475,
      0.093542,
      4.755695,
      4,
      3,
      0.051773,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.574872,
      NULL,
      3,
      3,
      0.109002,
      NULL,
      7.883747,
      1.334204,
      1,
      0,
      2.321919,
      NULL,
      2,
      3,
      1.094221,
      2.172805,
      NULL,
      0,
      NULL,
      2,
      3,
      3.594862,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.425256,
      1,
      0.823406,
      NULL,
      1.304193,
      1.494147,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.959516,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.755484,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.782710,
      NULL,
      NULL,
      3.650966,
      NULL,
      NULL,
      1,
      NULL,
      0.000630,
      1.366461,
      0.483222,
      NULL,
      1.895229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.916701,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.097001,
      NULL,
      0,
      3,
      NULL,
      61.900181,
      5,
      0.686917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      40.010415,
      0.480722,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.180697,
      NULL,
      1.720926,
      172,
      NULL,
      1.735231,
      1,
      NULL,
      0,
      0.843260,
      NULL,
      NULL,
      0.105736,
      0.598889,
      NULL,
      NULL,
      1.079475,
      NULL,
      1,
      NULL,
      NULL,
      1.302924,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029506,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.557570,
      NULL,
      NULL,
      NULL,
      1.308264,
      1.660582,
      0.419057,
      NULL,
      NULL,
      NULL,
      0.010334,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.153905,
      6.924814,
      1.625929,
      4,
      2.972879,
      3.153129,
      0,
      2,
      NULL,
      1.876711,
      1,
      1.039470,
      NULL,
      1.252772,
      2.784952,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      0.643917,
      NULL,
      NULL,
      1,
      NULL,
      0.706606,
      NULL,
      NULL,
      NULL,
      0.157845,
      NULL,
      0,
      1.992501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598738,
      NULL,
      1.580352,
      NULL,
      0,
      NULL,
      2,
      NULL,
      7,
      1,
      NULL,
      NULL,
      44,
      121,
      3,
      4.916175,
      3,
      '40213',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.573088,
      '2133',
      '',
      '');
commit;
end;
/


