set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8834206';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      3.770764,
      NULL,
      2,
      NULL,
      '1303',
      3.715833,
      0,
      NULL,
      NULL,
      ' 4-21-1986',
      25,
      NULL,
      1,
      1,
      NULL,
      ' 4-21-1996',
      19,
      0.305784,
      NULL,
      105,
      3.101742,
      ' 3-14-2003',
      ' 4- 7-1983',
      NULL,
      0,
      0,
      0.898176,
      0.594020,
      NULL,
      1.074633,
      0.393930,
      1,
      0.625462,
      1,
      NULL,
      NULL,
      0,
      19,
      7.040116,
      1.947477,
      13.330475,
      1.018904,
      NULL,
      3,
      0.992098,
      1.844714,
      1,
      1,
      1.271854,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.940139,
      1.972270,
      3,
      3.035474,
      0.182304,
      NULL,
      0.036406,
      3,
      0,
      3,
      0.268009,
      NULL,
      1.606697,
      0.510446,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.885140,
      1.670454,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.453072,
      0.217342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.861218,
      1.704464,
      0.724278,
      11,
      1.826944,
      3.940899,
      0,
      0,
      1,
      0.705357,
      1.447171,
      0.615481,
      3,
      1,
      0,
      1,
      0.769429,
      0.648518,
      NULL,
      1.350600,
      NULL,
      4.798430,
      1.355814,
      2.858646,
      NULL,
      0.187994,
      5,
      1,
      5.754401,
      3.943394,
      6.444079,
      NULL,
      0,
      0.330242,
      0,
      2,
      11.643191,
      7.675384,
      7,
      1,
      10.357879,
      1,
      NULL,
      1.766143,
      NULL,
      3,
      0.633801,
      ' 8- 8-1990',
      31.967195,
      NULL,
      38,
      0,
      1.103352,
      1.657795,
      3.469965,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.252692,
      0.480997,
      3,
      NULL,
      0.700870,
      2.112909,
      2.747986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.825325,
      NULL,
      1.933592,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.226653,
      2,
      0.670474,
      1.528563,
      3,
      1.959550,
      0.656616,
      NULL,
      NULL,
      NULL,
      0,
      1.785346,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846517,
      0.756251,
      NULL,
      1,
      0.144340,
      1.684285,
      NULL,
      0,
      252.219206,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.551152,
      0,
      NULL,
      0,
      6.109236,
      1,
      1.990507,
      5,
      1,
      0,
      1,
      6,
      7,
      2.645149,
      2.856312,
      0.781198,
      0,
      1.042872,
      2.116053,
      0.820768,
      0,
      1.983931,
      1.902441,
      0.092392,
      1.037995,
      NULL,
      1.889557,
      1,
      0,
      4.958289,
      1.465824,
      4,
      4.996236,
      1.474803,
      10,
      9,
      4,
      3.423550,
      3.084846,
      1,
      2,
      3.692634,
      2.603384,
      NULL,
      NULL,
      3,
      NULL,
      51,
      27,
      30.118873,
      5,
      NULL,
      3.719843,
      '32210',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.042524,
      '',
      '',
      '',
      3,
      21.569943,
      37,
      NULL,
      3.171574,
      NULL,
      NULL,
      5,
      3,
      2,
      2.704358,
      1.046047,
      0.865714,
      NULL,
      NULL,
      0,
      1.986780,
      3.288703,
      1,
      2.550797,
      1,
      3,
      3.934286,
      1,
      0.373323,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643632,
      14,
      7,
      1,
      NULL,
      NULL,
      9,
      5.083788,
      3.784005,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.999346,
      NULL,
      NULL,
      1.411733,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      10.245099,
      3,
      0.152737,
      NULL,
      NULL,
      1.138671,
      NULL,
      1,
      0.920975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690521,
      NULL,
      NULL,
      1.325918,
      0.922347,
      0.679703,
      NULL,
      1,
      1.975699,
      0,
      NULL,
      NULL,
      1.735227,
      10.171001,
      1.897716,
      NULL,
      1,
      1,
      3.833062,
      0,
      0.446227,
      5.037997,
      0,
      1,
      0.023886,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.349074,
      NULL,
      1,
      NULL,
      0.847501,
      3.873330,
      2.133753,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.643443,
      NULL,
      NULL,
      3.796950,
      0,
      3.031417,
      NULL,
      2.011509,
      3,
      7,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2.473547,
      1,
      1.686378,
      1.240389,
      3.598241,
      1.045639,
      2,
      1,
      0,
      2.961554,
      NULL,
      4,
      4.684585,
      2.062907,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.515151,
      NULL,
      NULL,
      3.700643,
      NULL,
      NULL,
      2.802628,
      NULL,
      NULL,
      12.746053,
      NULL,
      NULL,
      2,
      1,
      0.467483,
      1.615835,
      0,
      2,
      1,
      NULL,
      NULL,
      4,
      3.778055,
      NULL,
      NULL,
      18.571354,
      NULL,
      NULL,
      NULL,
      0.689919,
      0,
      NULL,
      NULL,
      0.505632,
      NULL,
      NULL,
      NULL,
      0.087859,
      NULL,
      NULL,
      NULL,
      0.205270,
      NULL,
      NULL,
      NULL,
      2.905453,
      NULL,
      NULL,
      NULL,
      NULL,
      2.839768,
      NULL,
      NULL,
      0.060141,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      16.742363,
      0,
      NULL,
      NULL,
      1.745906,
      2.037720,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.294523,
      3.673555,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.716144,
      1,
      NULL,
      NULL,
      4.635723,
      0.988579,
      NULL,
      NULL,
      9,
      10.669026,
      NULL,
      NULL,
      0.434953,
      NULL,
      NULL,
      NULL,
      1.484497,
      20,
      12,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.612907,
      NULL,
      NULL,
      1.448408,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.379014,
      NULL,
      NULL,
      8224,
      1769,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0.711548,
      0,
      1.938503,
      1,
      NULL,
      0,
      1.295527,
      0,
      0.105243,
      0,
      1,
      NULL,
      NULL,
      0.050385,
      NULL,
      0,
      NULL,
      1.906454,
      NULL,
      3.926183,
      NULL,
      1,
      NULL,
      10,
      NULL,
      2,
      42,
      21.667541,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.708971,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.009522,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.155396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846494,
      NULL,
      NULL,
      0.439175,
      3.281261,
      3.159789,
      2.188445,
      NULL,
      6,
      0.377893,
      0.386325,
      3.390502,
      0,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      1.897183,
      0.689032,
      NULL,
      17,
      0,
      1,
      0.318890,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      1,
      0,
      3.886343,
      2,
      0,
      NULL,
      0.406127,
      1.059703,
      1,
      0.595019,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.653122,
      NULL,
      2,
      NULL,
      2,
      0,
      2,
      1.321613,
      2,
      1.131717,
      3,
      0,
      1.644007,
      3.352122,
      1.516898,
      0.387560,
      2.939750,
      1,
      0.174125,
      1.642524,
      3.795198,
      0,
      1.003735,
      1,
      NULL,
      0.919191,
      0.108426,
      10,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      0.291071,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271388,
      NULL,
      NULL,
      36.320616,
      125,
      3,
      1,
      NULL,
      NULL,
      '04141',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


