set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8102496';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '1430141',
      3,
      1,
      0,
      1,
      '4031',
      0.425144,
      NULL,
      NULL,
      NULL,
      ' 2-17-1976',
      28.099638,
      NULL,
      0.297036,
      1.403965,
      0.601299,
      '10-20-1997',
      13.938115,
      NULL,
      157,
      154.868725,
      1.746695,
      NULL,
      '10-17-1989',
      NULL,
      3,
      0,
      NULL,
      0.542778,
      1,
      NULL,
      0.817086,
      0,
      0,
      62,
      5,
      14.671231,
      5.903298,
      141,
      NULL,
      NULL,
      33,
      5,
      3,
      3.996497,
      0.203595,
      1,
      0,
      1.324162,
      NULL,
      0,
      1.762985,
      NULL,
      1.131253,
      0,
      5,
      14,
      1.386064,
      NULL,
      3.807182,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      5.314575,
      5,
      3,
      2.461392,
      0,
      1.372748,
      4,
      NULL,
      4.662951,
      2.429903,
      1,
      1.441083,
      NULL,
      NULL,
      1.645417,
      NULL,
      NULL,
      4,
      1.867859,
      NULL,
      3.497389,
      2,
      NULL,
      0.553413,
      2,
      1.587497,
      2.482658,
      2,
      0.237921,
      0.245069,
      0,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      0.173915,
      4.220617,
      5,
      0,
      NULL,
      1,
      1.059668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.085578,
      2.967407,
      NULL,
      NULL,
      NULL,
      NULL,
      3.223749,
      0.048492,
      1.202863,
      2.573784,
      1,
      0,
      1.443051,
      NULL,
      1,
      1.354764,
      1,
      1,
      1,
      NULL,
      0.626407,
      4.352356,
      NULL,
      1.417832,
      8.041374,
      NULL,
      4,
      9.073857,
      7.049344,
      8.861014,
      1,
      2,
      NULL,
      NULL,
      0.533442,
      6.812925,
      2.085865,
      10.842594,
      0.881828,
      10,
      5,
      7,
      1.681403,
      1.831429,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 7- 2-1991',
      490.788961,
      3,
      NULL,
      NULL,
      3.587123,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.118644,
      1,
      0,
      1.716827,
      0.779504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.154053,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.437409,
      6.851167,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083263,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.042096,
      0,
      2,
      0,
      1,
      0.525912,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.946143,
      1.615792,
      0,
      2,
      2.989045,
      1.443905,
      2,
      0,
      3,
      2,
      2.936201,
      1.013415,
      1.043313,
      2.871604,
      16,
      17.707525,
      185.237624,
      NULL,
      43.651924,
      78.976680,
      193.928471,
      NULL,
      1.191345,
      0.034694,
      NULL,
      0,
      1,
      0.667252,
      1,
      19,
      13.164039,
      0.720361,
      8,
      0.830346,
      NULL,
      7,
      4,
      2.397207,
      0.094303,
      NULL,
      7,
      2,
      2,
      3.060569,
      0,
      3.260650,
      1.405457,
      NULL,
      42,
      20,
      NULL,
      3,
      0,
      0.117608,
      '03410',
      '',
      NULL,
      0,
      NULL,
      '',
      NULL,
      1.132681,
      '',
      '',
      NULL,
      3,
      46.533527,
      37.780963,
      NULL,
      3,
      31,
      4,
      12.971315,
      9.919940,
      1,
      NULL,
      2.726159,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.817316,
      1.394596,
      NULL,
      NULL,
      3,
      2.689671,
      NULL,
      0,
      0.465224,
      0.213176,
      NULL,
      2,
      0,
      0.582466,
      NULL,
      NULL,
      0.818202,
      NULL,
      NULL,
      3.948036,
      NULL,
      1,
      2,
      0,
      0.263254,
      NULL,
      NULL,
      NULL,
      0.397050,
      5.411245,
      4,
      0,
      1.510706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513885,
      1,
      NULL,
      2.664634,
      1.458192,
      3,
      NULL,
      1,
      2,
      NULL,
      3.410776,
      2,
      3,
      0.365660,
      1.629450,
      3,
      3,
      1.329310,
      3,
      2,
      NULL,
      1.749252,
      2.623240,
      2.302371,
      1,
      3,
      NULL,
      NULL,
      0.637392,
      NULL,
      NULL,
      1.293499,
      0,
      0.616175,
      6,
      4,
      NULL,
      0.374122,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884832,
      NULL,
      NULL,
      2.922267,
      0.911860,
      1,
      NULL,
      NULL,
      0.157144,
      NULL,
      NULL,
      4,
      7.318656,
      NULL,
      2.408289,
      NULL,
      1.555455,
      1.964895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683904,
      NULL,
      NULL,
      0.967602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.914474,
      NULL,
      NULL,
      NULL,
      1.752135,
      NULL,
      1,
      2.398450,
      NULL,
      1.985190,
      2.160308,
      2.228386,
      9,
      4,
      2,
      2.070681,
      NULL,
      NULL,
      1.372175,
      3.184460,
      NULL,
      1,
      0.065142,
      NULL,
      3,
      3.239704,
      NULL,
      NULL,
      NULL,
      4.141912,
      NULL,
      2,
      2,
      3.409897,
      1.371797,
      1.353172,
      1.990915,
      3,
      1,
      NULL,
      0.999971,
      0.284406,
      NULL,
      3,
      6.062149,
      NULL,
      3.753966,
      NULL,
      1,
      1.645729,
      3.272401,
      1.801282,
      1.731974,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.116360,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572566,
      0,
      0,
      1.856557,
      1,
      1,
      0,
      NULL,
      NULL,
      2.604444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.824254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716544,
      NULL,
      NULL,
      NULL,
      0.116758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.745480,
      NULL,
      NULL,
      NULL,
      3.956847,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.135208,
      5,
      3.743062,
      84,
      297.770744,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.008134,
      772.918040,
      18,
      0.031281,
      NULL,
      0.986964,
      1,
      1,
      1.222131,
      0.570150,
      NULL,
      1.543741,
      0,
      1,
      0,
      0.872495,
      0.588480,
      0,
      0.832152,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.209166,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.276877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.815387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869736,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.498649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093747,
      2,
      NULL,
      0.306493,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.249787,
      0,
      2.318586,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.256907,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793673,
      NULL,
      NULL,
      3.544686,
      0.996470,
      1.669902,
      1,
      5,
      7.546437,
      NULL,
      1,
      1,
      0.394820,
      0.229224,
      NULL,
      0,
      1.259786,
      NULL,
      NULL,
      1.230803,
      NULL,
      1,
      0,
      NULL,
      0,
      1.450940,
      NULL,
      0.970211,
      0.144237,
      NULL,
      0.958802,
      0.719950,
      NULL,
      NULL,
      0.237377,
      NULL,
      NULL,
      0.428926,
      NULL,
      0.642370,
      NULL,
      NULL,
      0.810137,
      1.604451,
      NULL,
      3.640792,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.647259,
      NULL,
      5,
      7.560641,
      6.286364,
      2.053881,
      1.442496,
      3,
      11.791484,
      24.799696,
      1.268668,
      NULL,
      0.581748,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


