set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8102496';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      '02',
      12.744377,
      11,
      '1123210',
      5,
      1,
      2,
      NULL,
      '2041',
      3.769537,
      1.027317,
      NULL,
      NULL,
      NULL,
      96.332311,
      105,
      NULL,
      3.317671,
      0.405946,
      ' 2- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      ' 6-12-1976',
      2,
      0,
      2.836357,
      NULL,
      0.025437,
      1,
      2,
      0.590413,
      0.523741,
      81.436769,
      8,
      NULL,
      5.243987,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.470556,
      NULL,
      1.635038,
      0.561663,
      0,
      1,
      1,
      NULL,
      0,
      1.466147,
      1,
      1,
      NULL,
      2.451152,
      6.405206,
      7.438345,
      2.340174,
      5,
      1.656386,
      3.990578,
      1,
      4.569809,
      3.119785,
      7.941062,
      9.742489,
      1.013016,
      4.128524,
      2,
      NULL,
      8.965235,
      1,
      1.561286,
      3.065353,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      6,
      3.406510,
      2.905150,
      0,
      1.625468,
      3,
      0,
      2.452945,
      3.741600,
      1,
      0.630012,
      NULL,
      1.383005,
      1.309208,
      3,
      3,
      1.415781,
      NULL,
      1,
      1,
      NULL,
      2,
      0,
      4.100881,
      3.321131,
      0.804316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757695,
      2.947453,
      0,
      0,
      1.090153,
      3.640241,
      2.020535,
      NULL,
      0.151764,
      1,
      0.871360,
      0,
      1,
      0,
      NULL,
      0,
      0.585200,
      1,
      1,
      3,
      2,
      0,
      2,
      0.751885,
      0,
      2.644020,
      2,
      5.659828,
      1,
      5.097816,
      3,
      NULL,
      0,
      1,
      1.020046,
      1,
      6.451426,
      4.248904,
      7.350599,
      0.692636,
      NULL,
      4,
      0,
      0.427472,
      4,
      1.587845,
      NULL,
      NULL,
      ' 5-26-1989',
      671,
      NULL,
      1668,
      3.018841,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.294125,
      0.665613,
      0,
      NULL,
      1.421377,
      1.298191,
      1.651126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504160,
      1.405681,
      NULL,
      3,
      5,
      4.862958,
      NULL,
      1,
      NULL,
      NULL,
      1.023068,
      5.525644,
      1.944191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1.657569,
      1.883449,
      1.486228,
      3.036949,
      0,
      3,
      1.513806,
      NULL,
      NULL,
      87.985190,
      NULL,
      1.485304,
      0.234411,
      3,
      NULL,
      2.473548,
      1,
      1,
      1.323422,
      2,
      NULL,
      3,
      0.278897,
      NULL,
      0.733403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326730,
      0.869479,
      1.090890,
      0,
      0,
      NULL,
      0.233886,
      NULL,
      NULL,
      NULL,
      10,
      3,
      0,
      3.559888,
      NULL,
      5,
      NULL,
      0,
      3.698956,
      2,
      3.220233,
      2.174880,
      58,
      1,
      1.979768,
      57.219133,
      NULL,
      0.787887,
      5,
      0.976642,
      4,
      1.226487,
      '34114',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.871336,
      NULL,
      '',
      '',
      0,
      23,
      49.404793,
      NULL,
      3,
      46,
      7.673403,
      213,
      8,
      3.786808,
      2.658343,
      2,
      0,
      NULL,
      NULL,
      2,
      0.912237,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      1.274161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718771,
      1,
      1.437838,
      0,
      0.378657,
      NULL,
      NULL,
      NULL,
      9,
      3,
      2.054091,
      0,
      1.207917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.538593,
      2.732423,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      3,
      3,
      NULL,
      NULL,
      3,
      0,
      0.238035,
      1,
      0.968781,
      1.287237,
      1,
      0,
      1,
      3,
      0.555414,
      3,
      1,
      0,
      NULL,
      NULL,
      1.838116,
      3.508436,
      1.251412,
      0.876852,
      9.298534,
      2.984460,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287076,
      NULL,
      NULL,
      NULL,
      2.310817,
      NULL,
      3.032713,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      6.912422,
      2,
      0,
      0,
      0.550988,
      1,
      NULL,
      NULL,
      7,
      NULL,
      3.938180,
      1.247327,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.922882,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.181078,
      2,
      NULL,
      NULL,
      0.795173,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.356715,
      NULL,
      NULL,
      3.986802,
      3,
      1.393588,
      3,
      3.259169,
      3,
      1,
      1,
      NULL,
      1.185722,
      2,
      NULL,
      NULL,
      2.731103,
      NULL,
      0.169985,
      NULL,
      3.430784,
      3.112872,
      2,
      NULL,
      0.682453,
      0.758627,
      1.219092,
      10.404099,
      4.815204,
      7.715470,
      3.390011,
      7,
      NULL,
      0.826037,
      NULL,
      NULL,
      1,
      1.158299,
      0.882052,
      0.403914,
      1.172511,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.315214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.644872,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.132436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.145687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.273582,
      NULL,
      NULL,
      NULL,
      11.685536,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      11.163805,
      NULL,
      2,
      287.176547,
      437,
      3.607262,
      0.910816,
      NULL,
      0.762383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      3.167896,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060569,
      17.873512,
      NULL,
      0,
      0,
      1,
      0.815708,
      0,
      1.150471,
      0.788286,
      0.926987,
      0.746570,
      1,
      1.387783,
      1.854242,
      0.792772,
      0,
      0,
      1.907308,
      1.238693,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.226953,
      NULL,
      1,
      NULL,
      0.814338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021382,
      NULL,
      0.709389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.976527,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155631,
      0.291567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253886,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.824738,
      2.324661,
      NULL,
      0.558803,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.756607,
      2,
      5.930917,
      0,
      2,
      0,
      2.492459,
      8.726276,
      3,
      3.199048,
      1.298660,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.811358,
      0.073372,
      NULL,
      NULL,
      0.832351,
      NULL,
      0.337422,
      1.103507,
      NULL,
      NULL,
      1.477474,
      NULL,
      NULL,
      0.070118,
      NULL,
      NULL,
      0.575616,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.693484,
      NULL,
      2.150407,
      0,
      0.672533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.645753,
      NULL,
      1.914435,
      NULL,
      4,
      3,
      1,
      3,
      0.970295,
      2.860384,
      6.492585,
      24.151963,
      1,
      0,
      0.214786,
      '40200',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


