set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7838975';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.147359,
      2,
      1,
      1,
      0.695576,
      NULL,
      1.773590,
      0.101317,
      '323',
      '00104132',
      21.982761,
      28,
      '4011221',
      2,
      NULL,
      1,
      0,
      '4431',
      3.103980,
      0,
      NULL,
      NULL,
      ' 4-16-2000',
      NULL,
      170,
      NULL,
      0,
      0.673726,
      ' 5- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 4-29-1991',
      3.293672,
      1,
      0,
      0,
      0.754110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.903723,
      0.738108,
      0.587424,
      1.329537,
      1,
      NULL,
      0,
      1.669667,
      NULL,
      NULL,
      0.441275,
      1,
      NULL,
      3,
      1.930905,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.323717,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0.874501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.644237,
      0.147650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065995,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.447229,
      0.179587,
      1,
      1,
      1.886127,
      NULL,
      1.394981,
      1.331071,
      0,
      3.822173,
      NULL,
      0.142529,
      NULL,
      1.935448,
      1,
      1,
      NULL,
      1.126589,
      NULL,
      1.467420,
      1.268042,
      0.048094,
      0.471256,
      0,
      0.461455,
      0,
      2,
      1,
      0,
      1,
      1,
      3,
      0,
      1.524901,
      1,
      NULL,
      1,
      0.573100,
      0,
      0,
      0,
      1.355373,
      NULL,
      1,
      NULL,
      1,
      1.014969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805829,
      0.631992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.408483,
      3,
      0.909601,
      1.053748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.241362,
      NULL,
      NULL,
      2,
      0.880403,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295062,
      1.017477,
      1.989029,
      NULL,
      2.589090,
      3.063961,
      1.500935,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.961907,
      1.673600,
      1.007101,
      1,
      3.193049,
      1.359956,
      0.315624,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4.946964,
      NULL,
      0,
      0,
      3,
      3,
      NULL,
      NULL,
      2.550567,
      2,
      NULL,
      2.304073,
      4.159154,
      2,
      0.462690,
      4,
      NULL,
      0.551678,
      1,
      0,
      NULL,
      0.753870,
      NULL,
      1.855899,
      NULL,
      0.163879,
      0,
      NULL,
      0.864760,
      1.448617,
      5.003045,
      NULL,
      9,
      11.902396,
      NULL,
      2.453375,
      7,
      NULL,
      NULL,
      1,
      5.288194,
      0,
      2.670846,
      1.652709,
      30,
      NULL,
      0.440532,
      130.473738,
      NULL,
      NULL,
      NULL,
      0.038838,
      0.265665,
      1.501186,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.867316,
      '',
      '',
      NULL,
      1.553511,
      NULL,
      NULL,
      14.278513,
      0.462119,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.240421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.133318,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.560495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959246,
      NULL,
      NULL,
      1.301392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.459702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.045441,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      0,
      2,
      3.245140,
      1.409890,
      NULL,
      5,
      2.229483,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.340173,
      NULL,
      NULL,
      0.739628,
      NULL,
      NULL,
      0.058016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.302147,
      1.495030,
      0,
      NULL,
      NULL,
      1.214190,
      5,
      2.719372,
      2,
      NULL,
      NULL,
      NULL,
      1.161980,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0.074605,
      0,
      NULL,
      0.898956,
      0.171776,
      0,
      0,
      0,
      0.475417,
      1.111483,
      NULL,
      NULL,
      0,
      2.594690,
      1,
      5,
      3,
      3,
      NULL,
      NULL,
      1.681805,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      2.956159,
      0.768636,
      NULL,
      2.018134,
      NULL,
      NULL,
      22,
      NULL,
      NULL,
      0.211611,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.230667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.590842,
      NULL,
      NULL,
      3.254486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.337527,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      4,
      NULL,
      3,
      NULL,
      2,
      1.938705,
      0.153686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.807085,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.011623,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.594768,
      NULL,
      NULL,
      NULL,
      0.120165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707537,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      2,
      0,
      5,
      1.980049,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      9.131402,
      NULL,
      2.219431,
      207.909198,
      13,
      0,
      NULL,
      0.329222,
      76,
      23.888171,
      0,
      0.269521,
      NULL,
      NULL,
      1,
      0,
      1.338787,
      1.685471,
      0,
      1.160069,
      0.384365,
      0.386887,
      1,
      NULL,
      0,
      1.670585,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.531977,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355920,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.216779,
      1,
      NULL,
      1.086730,
      NULL,
      1.926669,
      0.518534,
      0.031910,
      1.143492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.707103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645411,
      1.005292,
      NULL,
      NULL,
      NULL,
      1.720257,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.007850,
      NULL,
      1.389645,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.683419,
      9,
      1.472742,
      3,
      3,
      3.021651,
      NULL,
      NULL,
      1.517106,
      0.124433,
      1,
      0.027923,
      0.899494,
      NULL,
      0.269748,
      1,
      0.681735,
      1,
      0.066038,
      1.124901,
      0.457558,
      0,
      0,
      1.643908,
      3.601868,
      NULL,
      1.921907,
      1.353640,
      2.710486,
      NULL,
      NULL,
      0.875568,
      0,
      NULL,
      0.698563,
      0,
      0.996393,
      NULL,
      NULL,
      0.991446,
      0,
      NULL,
      0,
      1,
      3.605141,
      1.974887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011486,
      NULL,
      NULL,
      1,
      0,
      0.784544,
      0,
      7.611559,
      2.458729,
      0.998308,
      NULL,
      NULL,
      29,
      NULL,
      5,
      3.532547,
      NULL,
      '03413',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.465844,
      '',
      '',
      '');
commit;
end;
/


