set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303656';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '0000003',
      0,
      1.384160,
      4,
      3,
      '3333',
      0,
      0.564309,
      NULL,
      NULL,
      ' 7- 4-1977',
      64.947568,
      NULL,
      5.133764,
      1.176808,
      2,
      ' 9-26-1974',
      NULL,
      3,
      197,
      NULL,
      0.994782,
      NULL,
      '11-20-1997',
      ' 7-14-1993',
      0.740417,
      0.803121,
      NULL,
      2,
      NULL,
      1,
      3,
      2.178460,
      NULL,
      NULL,
      NULL,
      NULL,
      5.793977,
      13.511410,
      NULL,
      7.887842,
      24,
      3.881694,
      3.164082,
      NULL,
      NULL,
      2,
      1.779435,
      0,
      1,
      1,
      1,
      6,
      0,
      0,
      0,
      12,
      10,
      4.958947,
      1.333404,
      NULL,
      1,
      1,
      NULL,
      1.160080,
      1,
      NULL,
      1,
      0.451837,
      0.252406,
      4,
      NULL,
      5,
      3,
      2,
      0.703269,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.294506,
      3.160942,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0.866026,
      0,
      3.812072,
      0.000555,
      0,
      0,
      1.971404,
      NULL,
      3,
      NULL,
      0.403059,
      2.126489,
      6,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830136,
      NULL,
      NULL,
      2.154167,
      0.838967,
      NULL,
      NULL,
      0,
      1.372708,
      1,
      0.370515,
      1.706012,
      0.454881,
      0,
      1,
      1.266177,
      0.339053,
      0,
      0,
      0,
      1.117430,
      0,
      NULL,
      1.905462,
      NULL,
      0.052112,
      0.578276,
      3,
      1,
      5,
      3.273020,
      1,
      1,
      0.564948,
      1,
      NULL,
      2.834400,
      0.338329,
      6.691947,
      NULL,
      1,
      6.901705,
      5.252106,
      NULL,
      0,
      7.366928,
      0.410929,
      4.603126,
      NULL,
      0.589882,
      0,
      ' 3- 5-1998',
      44,
      ' 4-11-1999',
      200.715650,
      2.634559,
      2.841969,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1.881834,
      0,
      1.368989,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884646,
      NULL,
      0.162617,
      2,
      1.172571,
      0.859640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.535127,
      0.728401,
      2,
      0,
      0.923162,
      3,
      0,
      1,
      0,
      1.923515,
      2,
      1.308200,
      0,
      NULL,
      NULL,
      0.581578,
      1.200171,
      0.942008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.580877,
      12.963985,
      2.364703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.705938,
      2.070646,
      0,
      1.968065,
      1,
      NULL,
      2.481220,
      3,
      1,
      3.818126,
      2.411896,
      3.865637,
      1.726159,
      1,
      1.402614,
      7,
      0.286159,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.759938,
      NULL,
      0.164548,
      1,
      0,
      NULL,
      NULL,
      7,
      0,
      1,
      6,
      3.509846,
      NULL,
      1.017020,
      0,
      1.449171,
      2,
      0,
      56,
      2,
      3,
      NULL,
      44.421704,
      19.266071,
      25,
      NULL,
      0,
      1.874446,
      '21131',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.775499,
      '',
      '',
      '',
      1.794040,
      16,
      56,
      8,
      NULL,
      NULL,
      9.321569,
      NULL,
      3,
      2.634053,
      3,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127011,
      NULL,
      NULL,
      1.913591,
      NULL,
      NULL,
      3,
      2,
      3.149464,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      NULL,
      NULL,
      0.897936,
      1.833705,
      2.859024,
      NULL,
      0,
      NULL,
      NULL,
      0.430747,
      0.690973,
      2,
      1,
      0.782889,
      NULL,
      NULL,
      NULL,
      0.074159,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      0.990183,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      2,
      3,
      0,
      1,
      0,
      1.892121,
      NULL,
      0,
      NULL,
      2.828354,
      1.627292,
      0.134220,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.457880,
      NULL,
      NULL,
      6.398739,
      1.903345,
      0.385703,
      1.727748,
      NULL,
      NULL,
      NULL,
      NULL,
      0.267699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.706551,
      1.986027,
      NULL,
      0.661622,
      0,
      0.996767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969790,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.069787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.122490,
      3.919316,
      NULL,
      0.071909,
      NULL,
      NULL,
      0,
      2.315492,
      2.965623,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      3,
      3,
      3,
      2.992366,
      NULL,
      NULL,
      2,
      1.537632,
      2.227096,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      6,
      1.245598,
      1.176641,
      4.635993,
      3.385904,
      5,
      0.240825,
      NULL,
      3.792201,
      1,
      0.351847,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      80,
      NULL,
      NULL,
      NULL,
      0.383808,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.900121,
      NULL,
      NULL,
      NULL,
      2.809416,
      NULL,
      NULL,
      NULL,
      1.222104,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.986471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.235127,
      NULL,
      NULL,
      NULL,
      0.899686,
      NULL,
      NULL,
      NULL,
      0.185684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800939,
      NULL,
      0,
      5.405197,
      2,
      8.686550,
      0,
      NULL,
      12,
      2,
      0,
      NULL,
      NULL,
      1.987933,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.637397,
      NULL,
      NULL,
      1.182766,
      NULL,
      0,
      138.003252,
      2,
      1.667367,
      0,
      0.974783,
      0,
      NULL,
      NULL,
      0,
      0,
      1.462568,
      1,
      1,
      0.643831,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.710889,
      1,
      9,
      2.336299,
      NULL,
      0,
      NULL,
      10.433030,
      0.810193,
      3.894139,
      1,
      0,
      1,
      NULL,
      NULL,
      1.994601,
      NULL,
      0,
      1.878199,
      NULL,
      0.625898,
      NULL,
      NULL,
      NULL,
      1.133944,
      NULL,
      1,
      1,
      NULL,
      1.431269,
      0.029511,
      NULL,
      0,
      0.571824,
      NULL,
      NULL,
      1.024031,
      NULL,
      NULL,
      3.733626,
      NULL,
      1.355817,
      3,
      NULL,
      2,
      0.348489,
      0.153518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643405,
      NULL,
      1,
      NULL,
      0.803992,
      NULL,
      3.433408,
      NULL,
      4,
      NULL,
      1.191779,
      3.235930,
      78.053448,
      1,
      1.456078,
      4,
      2,
      '40334',
      '',
      '',
      1.524446,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


