set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9944050';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.536945,
      5,
      3,
      3,
      NULL,
      0,
      0,
      '200',
      '20341332',
      74,
      80.425684,
      '0030230',
      2.679130,
      1.476366,
      1,
      NULL,
      '3302',
      5,
      1.364140,
      NULL,
      NULL,
      ' 0- 0-1974',
      NULL,
      NULL,
      NULL,
      3,
      2.528695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11-19-1996',
      ' 4- 5-1994',
      ' 2-26-1980',
      NULL,
      0,
      1,
      2,
      NULL,
      0.354613,
      3.597671,
      1,
      0,
      11.116741,
      4.685703,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.140267,
      2.089607,
      NULL,
      1.619985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      5.602620,
      3.122491,
      NULL,
      1,
      0.329897,
      0,
      1,
      NULL,
      2,
      0.381318,
      NULL,
      1,
      1,
      0.481143,
      7,
      0.423547,
      0.849799,
      1,
      1.051946,
      0.334495,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.854325,
      2.744457,
      9,
      3,
      0,
      0.535248,
      0,
      NULL,
      2.925170,
      1.594318,
      0,
      3.451010,
      0,
      1.250050,
      0,
      0.475515,
      2,
      1.617535,
      3,
      0,
      0,
      0,
      11,
      NULL,
      3.066432,
      NULL,
      1,
      NULL,
      NULL,
      0.512282,
      NULL,
      NULL,
      1,
      NULL,
      0.677052,
      1.053963,
      0,
      1.847649,
      0,
      NULL,
      1,
      0.579055,
      1,
      1,
      NULL,
      2,
      0,
      1,
      0,
      0.599298,
      1,
      NULL,
      0.344864,
      0.230381,
      4.704993,
      3.071837,
      1,
      1,
      1,
      0.135723,
      0,
      1,
      1,
      NULL,
      1.964218,
      1.532968,
      NULL,
      0,
      NULL,
      0.876936,
      8.795024,
      4,
      1,
      NULL,
      4.834670,
      4,
      NULL,
      0.744066,
      0.068648,
      1,
      NULL,
      1,
      ' 5-26-1987',
      47,
      2.871702,
      0,
      1.841117,
      3,
      1.372686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.623163,
      1.142197,
      1.291958,
      0,
      1.478238,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.552590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      4,
      NULL,
      NULL,
      4.694729,
      NULL,
      1.996407,
      0.297137,
      0.023402,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.236849,
      NULL,
      NULL,
      1.791089,
      2,
      8,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      1,
      3.891496,
      0.239626,
      1,
      3,
      0,
      1,
      2,
      3,
      3,
      3.852389,
      3,
      1.243850,
      0.173965,
      NULL,
      3.143997,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.122029,
      1,
      1,
      NULL,
      1.114865,
      2.626777,
      NULL,
      11,
      7.623718,
      NULL,
      0,
      5.659899,
      NULL,
      NULL,
      3,
      3.640140,
      1,
      2,
      1.523986,
      21.826936,
      1.622291,
      1,
      NULL,
      NULL,
      22,
      NULL,
      1.444270,
      NULL,
      1.062551,
      '41403',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      81,
      49.024782,
      2,
      NULL,
      NULL,
      4.361561,
      1.027466,
      0,
      1,
      2.683301,
      1.107890,
      NULL,
      NULL,
      1.174017,
      NULL,
      NULL,
      1.262520,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.325903,
      0,
      2.658113,
      NULL,
      NULL,
      NULL,
      1,
      0.117200,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.030593,
      NULL,
      NULL,
      NULL,
      3,
      5,
      1.658597,
      1,
      NULL,
      NULL,
      NULL,
      1.711909,
      NULL,
      NULL,
      NULL,
      3.562230,
      2.154867,
      3.346516,
      0,
      0,
      1.893595,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      3,
      0.228687,
      1,
      0,
      NULL,
      NULL,
      3,
      1.145674,
      NULL,
      NULL,
      3.748634,
      1,
      NULL,
      NULL,
      NULL,
      1.038033,
      NULL,
      3.105721,
      0.280361,
      1,
      NULL,
      5,
      5.056942,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299600,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.869543,
      NULL,
      NULL,
      1.007832,
      NULL,
      NULL,
      0.164595,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.956546,
      1.091578,
      1,
      1.154145,
      NULL,
      NULL,
      3.388194,
      1.698283,
      0.182236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451888,
      NULL,
      NULL,
      1,
      1,
      1.982230,
      NULL,
      0.414899,
      1.190594,
      1.048108,
      NULL,
      NULL,
      0.637142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.862602,
      NULL,
      0,
      1,
      2.296957,
      NULL,
      4.376736,
      NULL,
      3.055694,
      NULL,
      0,
      2,
      NULL,
      0.070120,
      NULL,
      1.584779,
      1.430801,
      3,
      2.494295,
      3.475251,
      3,
      NULL,
      1,
      0.747577,
      NULL,
      NULL,
      3.934259,
      NULL,
      5.721606,
      1.697028,
      1.708335,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      0.391164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.384531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980187,
      NULL,
      NULL,
      1.062496,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.225574,
      NULL,
      NULL,
      1,
      0.809328,
      0,
      0,
      0.237611,
      NULL,
      0.741012,
      NULL,
      NULL,
      2.763377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.561550,
      NULL,
      NULL,
      NULL,
      1.264538,
      NULL,
      NULL,
      NULL,
      0.381668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.897577,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2.990458,
      NULL,
      5.049577,
      6.076714,
      NULL,
      NULL,
      3.758686,
      1.086653,
      NULL,
      1.629359,
      1.434878,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.813830,
      NULL,
      1.685770,
      1.288364,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1.580105,
      0.514225,
      0.456641,
      1,
      1,
      0,
      1.332894,
      0.077310,
      0.034758,
      0.258572,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.850565,
      7.786825,
      2.715686,
      12.671522,
      4,
      2.581172,
      1.006551,
      5,
      9,
      1.063729,
      0.222283,
      1.879541,
      0,
      1.073092,
      NULL,
      1,
      1.495303,
      NULL,
      1.174714,
      3.587206,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.841113,
      NULL,
      NULL,
      0.147908,
      NULL,
      3.011663,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1.612599,
      1,
      NULL,
      0,
      1,
      NULL,
      2.184114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.481938,
      NULL,
      1,
      NULL,
      1,
      4.685951,
      5.651284,
      0.433913,
      NULL,
      NULL,
      30,
      NULL,
      3,
      4,
      NULL,
      NULL,
      '',
      '',
      0.449224,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


