set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9506730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      3.593015,
      1,
      NULL,
      0,
      '2332',
      NULL,
      0.435144,
      NULL,
      NULL,
      ' 6- 3-1978',
      63,
      NULL,
      1.860239,
      3.012148,
      3.310557,
      ' 8- 9-1986',
      27,
      1,
      191,
      75.418824,
      2.927652,
      ' 5- 8-1974',
      '10-12-2002',
      ' 9-25-1983',
      3,
      NULL,
      3,
      0,
      0.947771,
      2.511691,
      1,
      1.662895,
      0.548107,
      NULL,
      11,
      2,
      4,
      15.558495,
      26.134914,
      NULL,
      19.886343,
      1.911965,
      3.598079,
      0,
      0,
      NULL,
      1.563604,
      1.063617,
      NULL,
      NULL,
      1,
      0,
      0.605462,
      2.846929,
      1,
      0,
      NULL,
      12,
      2.303123,
      1.672233,
      1.629398,
      1.962127,
      5.351787,
      3.123673,
      NULL,
      1,
      1,
      1.986921,
      1,
      1.179549,
      NULL,
      NULL,
      NULL,
      3.833687,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.243341,
      NULL,
      NULL,
      7.304686,
      NULL,
      2,
      NULL,
      NULL,
      3,
      3.896008,
      3,
      0,
      1.674434,
      1,
      0.779950,
      1,
      3.283898,
      0.564199,
      NULL,
      1,
      NULL,
      0,
      5,
      2,
      0.867323,
      3.910870,
      0.682741,
      0,
      NULL,
      1.847495,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.191846,
      5.852176,
      6.448876,
      0,
      1.004705,
      5,
      7.055337,
      NULL,
      1.996223,
      7,
      NULL,
      2,
      NULL,
      4,
      0.189581,
      0,
      1,
      1.876478,
      1,
      NULL,
      0,
      NULL,
      1,
      1.990513,
      0.370424,
      0,
      3.817575,
      1,
      1,
      0,
      1,
      0.255314,
      NULL,
      1,
      0.404840,
      0,
      0,
      0.136637,
      NULL,
      2,
      NULL,
      4.215728,
      4,
      4.735088,
      1.313252,
      3,
      NULL,
      NULL,
      ' 8-11-1984',
      41.176014,
      ' 9-24-1989',
      NULL,
      3.157066,
      0.061202,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      1,
      0,
      0,
      2.619401,
      0.096043,
      1,
      2,
      3.808721,
      2.558084,
      4,
      NULL,
      NULL,
      1.046219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009264,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.517189,
      1.337534,
      0,
      1.314711,
      0,
      1,
      1.420320,
      1,
      1,
      1.512085,
      1,
      2.782136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.719329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276379,
      1,
      1.572279,
      0.416657,
      NULL,
      0,
      1,
      2,
      51,
      0.773572,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.472438,
      3,
      NULL,
      1.508965,
      2,
      NULL,
      0.282619,
      NULL,
      1.353185,
      2,
      NULL,
      2.259832,
      2,
      2,
      3.008483,
      0,
      0,
      1.451087,
      0.602798,
      1,
      1,
      1,
      0,
      1.497537,
      1.251219,
      1,
      1,
      0.483523,
      0,
      3.261482,
      1,
      1,
      1,
      7.479534,
      7,
      5.157816,
      4.314543,
      2,
      3.807430,
      NULL,
      0.981457,
      1,
      0.559872,
      10,
      3,
      3,
      NULL,
      57,
      NULL,
      NULL,
      5.788660,
      1.727502,
      3.349044,
      '41201',
      '',
      '',
      0.250203,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      13.524594,
      19.818319,
      12,
      2,
      20.133555,
      1,
      1,
      4,
      0.698286,
      NULL,
      NULL,
      1.482587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732050,
      NULL,
      0,
      NULL,
      3.653505,
      3,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      4,
      0,
      0,
      3.212474,
      1.354518,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.324114,
      NULL,
      2.020695,
      3.221309,
      2,
      NULL,
      1.600751,
      2,
      NULL,
      1,
      3.451918,
      2.461744,
      2,
      1,
      1.647610,
      0.451054,
      3.151498,
      NULL,
      0.941528,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2,
      1.969598,
      0.969639,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.809910,
      5,
      3,
      0,
      2.156211,
      1.513121,
      NULL,
      1,
      0.928905,
      NULL,
      NULL,
      NULL,
      3,
      1.101030,
      2,
      2.646370,
      3.628494,
      2.526581,
      0,
      2,
      1.485537,
      1.373532,
      NULL,
      NULL,
      6,
      NULL,
      1.859693,
      2,
      NULL,
      0.601865,
      1,
      NULL,
      3,
      3,
      0.595214,
      1,
      0.191496,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653585,
      1.616365,
      1,
      0.806460,
      0,
      0.957642,
      7,
      NULL,
      NULL,
      1.775203,
      NULL,
      NULL,
      2.498728,
      NULL,
      1.906059,
      1.772628,
      0.039924,
      1.007138,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      NULL,
      3.773772,
      1,
      1.119789,
      3,
      NULL,
      3,
      NULL,
      1,
      2,
      2,
      NULL,
      4.185086,
      3,
      0.616679,
      1.717850,
      NULL,
      NULL,
      1.989399,
      1,
      4,
      NULL,
      NULL,
      1,
      0.695984,
      1,
      NULL,
      NULL,
      4.384290,
      7,
      NULL,
      4,
      3,
      NULL,
      0,
      0.807011,
      NULL,
      NULL,
      NULL,
      NULL,
      1.868641,
      NULL,
      NULL,
      3,
      2.863712,
      NULL,
      2.259040,
      2.602177,
      NULL,
      0,
      1.962831,
      NULL,
      1,
      0.878811,
      NULL,
      3,
      3,
      NULL,
      2.205646,
      3.045658,
      NULL,
      2.507857,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.684724,
      1,
      0,
      2,
      NULL,
      1,
      0,
      6,
      NULL,
      NULL,
      NULL,
      7.626249,
      NULL,
      NULL,
      NULL,
      1.554194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.003303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.135329,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.299891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.169199,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.549808,
      NULL,
      1.804644,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.039184,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.964417,
      707,
      1,
      1,
      0,
      0.863342,
      1.331291,
      1,
      0.183067,
      1,
      0.357514,
      NULL,
      1.024162,
      NULL,
      0,
      1,
      0.415964,
      NULL,
      NULL,
      0,
      1.654299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.178737,
      1.753801,
      1.510342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816862,
      0.614336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.347047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713896,
      2.307880,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.660536,
      1.858861,
      1,
      0,
      0.973562,
      NULL,
      NULL,
      1.762613,
      0.846107,
      NULL,
      NULL,
      1.984997,
      0.978513,
      1.584306,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754536,
      1.728960,
      0,
      0,
      0.835796,
      1.955536,
      1,
      0,
      0.573280,
      1,
      1.890002,
      2.949516,
      0.359169,
      1.011473,
      NULL,
      1,
      NULL,
      1.045019,
      1.742512,
      NULL,
      1.376736,
      1,
      0.730320,
      0.958007,
      0.249921,
      0,
      0,
      1.789314,
      0,
      1.515896,
      NULL,
      1.367634,
      0,
      0,
      1,
      0,
      0,
      0,
      0.820522,
      0.302752,
      1.495064,
      NULL,
      NULL,
      0.070357,
      NULL,
      3,
      3.048154,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.495026,
      NULL,
      NULL,
      0,
      4,
      NULL,
      5.435850,
      0,
      NULL,
      NULL,
      94.819398,
      38,
      4.386200,
      NULL,
      1.010761,
      '03011',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.985297,
      '',
      '',
      '');
commit;
end;
/


