set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9223205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '4433120',
      3.564345,
      0,
      1,
      0,
      '0301',
      NULL,
      0.773273,
      NULL,
      NULL,
      ' 0- 2-1991',
      22.262803,
      NULL,
      1,
      0.877051,
      0,
      ' 0-22-1983',
      66,
      0,
      146,
      NULL,
      3,
      ' 6- 2-1982',
      ' 5-20-2003',
      NULL,
      0.782673,
      2,
      NULL,
      3.319755,
      1,
      NULL,
      1.553905,
      1.339117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.379652,
      13,
      3.070368,
      13,
      3.120060,
      0,
      0.842893,
      0.278597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.816118,
      3,
      3.543773,
      0,
      1,
      1,
      0,
      0.258994,
      NULL,
      NULL,
      NULL,
      1,
      1.547891,
      NULL,
      0,
      4.357332,
      0,
      2.362360,
      1,
      0.282159,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.014898,
      0,
      1,
      0.988309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801037,
      NULL,
      0,
      0,
      2,
      5,
      NULL,
      1.393088,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.282386,
      1.800574,
      NULL,
      1.165488,
      NULL,
      3,
      5,
      NULL,
      1.566125,
      2,
      4,
      0.096270,
      1,
      NULL,
      1.990100,
      1,
      NULL,
      5,
      5,
      4,
      0,
      5,
      2.309194,
      1,
      1.720706,
      NULL,
      1.658309,
      3.178370,
      0.840431,
      0,
      0.629662,
      ' 9- 0-1993',
      1032,
      ' 6- 0-1980',
      11.602731,
      1,
      0.129961,
      1.469019,
      3.816966,
      1.280991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.310871,
      NULL,
      0.025319,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.476906,
      1.537075,
      0.984130,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548959,
      1.524690,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.203801,
      0,
      1.409637,
      0,
      NULL,
      1,
      1.772810,
      1,
      NULL,
      1.449796,
      1.680559,
      NULL,
      NULL,
      NULL,
      1.652869,
      NULL,
      NULL,
      1,
      3,
      1.498860,
      NULL,
      3.386480,
      2,
      NULL,
      1.104666,
      0,
      2.588617,
      NULL,
      NULL,
      1.329772,
      1,
      1,
      0,
      3.396827,
      1.211329,
      1,
      1,
      1,
      1,
      1.389634,
      0.814200,
      1,
      0,
      NULL,
      1,
      1.822363,
      5.036495,
      NULL,
      1.496657,
      NULL,
      11.392756,
      6.063021,
      5.995843,
      3.820306,
      5,
      NULL,
      NULL,
      1,
      13.308065,
      1.758234,
      0,
      NULL,
      81.837122,
      1.406609,
      54,
      3,
      0,
      2,
      '33030',
      '',
      NULL,
      1.983512,
      '',
      '',
      '',
      0.604761,
      NULL,
      '',
      '',
      0,
      5,
      NULL,
      40,
      1.720863,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818501,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.972785,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.934633,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.665568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.268285,
      NULL,
      NULL,
      1.640031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      3,
      NULL,
      0,
      0.335504,
      NULL,
      NULL,
      3.392671,
      3.676040,
      0.340912,
      2.133993,
      1.468022,
      1,
      1.587129,
      NULL,
      NULL,
      3,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.383679,
      1,
      1.379682,
      NULL,
      NULL,
      0.139318,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.080516,
      3.327176,
      2,
      1,
      NULL,
      NULL,
      5.199531,
      2.643127,
      2,
      3,
      0,
      NULL,
      3.132651,
      0,
      NULL,
      2,
      2,
      3.790078,
      3.069454,
      1.213679,
      3.364156,
      2.610832,
      1.851822,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      1,
      3.337684,
      NULL,
      2,
      0.260177,
      NULL,
      NULL,
      0.701659,
      0.873453,
      0,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      1,
      1,
      1,
      0.819541,
      1.007230,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.568592,
      1.631313,
      0,
      1.570514,
      0.623808,
      0.248372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771050,
      NULL,
      NULL,
      NULL,
      1.924752,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.998542,
      NULL,
      NULL,
      0.438707,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.281022,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.636429,
      1,
      0.908317,
      1.523617,
      0.712978,
      0.599625,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0.497273,
      0.964286,
      NULL,
      1.089049,
      NULL,
      0,
      1.918336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.882618,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.488889,
      0.780554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496429,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.895752,
      NULL,
      1.512043,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.970720,
      1,
      NULL,
      1.917414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.768256,
      NULL,
      0,
      0,
      2,
      0,
      1,
      0.610782,
      NULL,
      0,
      1,
      2.479977,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853062,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.076467,
      NULL,
      NULL,
      2.031550,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.362673,
      NULL,
      0.843440,
      NULL,
      6.809001,
      7.638975,
      3,
      1,
      1,
      1,
      7.292191,
      62,
      2.919994,
      4,
      1,
      '34224',
      '',
      '',
      1.162658,
      '',
      '',
      '',
      1.672461,
      '',
      '',
      '');
commit;
end;
/


