set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8529806';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      NULL,
      1.955465,
      NULL,
      2,
      3,
      '2343',
      2.312566,
      0.941911,
      NULL,
      NULL,
      ' 9-29-1988',
      64.730030,
      NULL,
      4.994818,
      2,
      1.136615,
      ' 2-19-2000',
      NULL,
      2,
      50,
      111,
      3.168375,
      '11-27-1998',
      ' 0-11-1985',
      ' 3-24-1984',
      2.607559,
      2.221749,
      NULL,
      NULL,
      1.439663,
      1.052371,
      3.130379,
      1.493731,
      1.934724,
      26,
      3,
      5,
      2,
      NULL,
      21,
      3.423651,
      7,
      1.641712,
      3,
      2.461899,
      0,
      1.677677,
      0.276981,
      NULL,
      NULL,
      0,
      NULL,
      0.155386,
      0,
      1,
      NULL,
      1.005141,
      0,
      2.224082,
      1.063339,
      7.731022,
      NULL,
      9.405245,
      NULL,
      1.496675,
      1.817742,
      10.527105,
      0,
      1.416641,
      0.003175,
      3,
      0.072999,
      NULL,
      NULL,
      0.142883,
      1,
      1,
      0.252174,
      NULL,
      NULL,
      2,
      2.643956,
      1.133440,
      1,
      0,
      0.865266,
      1.998516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887495,
      0.929082,
      1,
      0,
      1.554100,
      NULL,
      1.620109,
      1.388887,
      0,
      NULL,
      0,
      1.881038,
      0.040049,
      NULL,
      NULL,
      0,
      1.968669,
      NULL,
      0,
      5.537234,
      1.164208,
      1.554478,
      0.266519,
      NULL,
      1.756553,
      1,
      1.354364,
      2,
      0,
      NULL,
      7.116913,
      3,
      0,
      0,
      2.635548,
      6.391011,
      7.100842,
      0.790844,
      11.857135,
      0.297510,
      5,
      5,
      NULL,
      0,
      0.964657,
      1,
      ' 7- 3-1987',
      867.866170,
      ' 2- 2-2002',
      88.184468,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688462,
      1,
      1,
      0,
      1.172985,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.576661,
      NULL,
      NULL,
      2,
      2,
      1.830108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.707061,
      1,
      NULL,
      NULL,
      NULL,
      2.521224,
      1.711274,
      0.488639,
      7,
      1.649195,
      0.655400,
      0.546346,
      0.144585,
      NULL,
      NULL,
      0.796791,
      7.215796,
      NULL,
      1,
      0.301391,
      1,
      NULL,
      NULL,
      289,
      ' 2-16-2000',
      585.906683,
      2,
      3.385193,
      0.729912,
      1,
      0.900457,
      NULL,
      NULL,
      0.068035,
      1.475995,
      0.491900,
      0.970614,
      136,
      2,
      1.343717,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      2.963199,
      2,
      NULL,
      NULL,
      3,
      NULL,
      0.193159,
      NULL,
      0,
      1,
      0.461275,
      1,
      5.779269,
      1.584549,
      0.053063,
      1,
      NULL,
      1.143316,
      NULL,
      0,
      1.265438,
      0.772854,
      0.200496,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.686364,
      NULL,
      12,
      15,
      37,
      0,
      1,
      1,
      '03310',
      '',
      NULL,
      1.421571,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.835606,
      13.378197,
      237.896541,
      45,
      0,
      44.061543,
      5,
      3,
      1.452258,
      3.141721,
      1.778081,
      3,
      0.937098,
      NULL,
      NULL,
      3.895680,
      0.091077,
      0.416029,
      0.303899,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.410578,
      0.331573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793332,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.511265,
      NULL,
      NULL,
      1.433275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503841,
      NULL,
      NULL,
      1.821630,
      NULL,
      NULL,
      1.905578,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745041,
      NULL,
      NULL,
      1.913753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.159112,
      NULL,
      NULL,
      1.649612,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.301473,
      NULL,
      NULL,
      0.006018,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7,
      0.852729,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.075892,
      0,
      0.342280,
      2,
      1.246456,
      1.231470,
      NULL,
      1.243872,
      0,
      0.634051,
      NULL,
      0.789603,
      NULL,
      2,
      1.422602,
      NULL,
      NULL,
      NULL,
      1.992863,
      NULL,
      NULL,
      2.727683,
      NULL,
      2.249942,
      NULL,
      3,
      0.970502,
      2.159716,
      NULL,
      7.243773,
      0.850109,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.697118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.858885,
      NULL,
      0.075883,
      2.937429,
      1,
      2,
      NULL,
      3.359797,
      5.488799,
      2,
      NULL,
      233,
      3.836779,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.844876,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.977344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.713013,
      NULL,
      NULL,
      NULL,
      2.070862,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      1.516157,
      1.209762,
      NULL,
      1.027492,
      0,
      NULL,
      NULL,
      1.499555,
      NULL,
      2.138441,
      NULL,
      0.810924,
      NULL,
      0.642109,
      NULL,
      11,
      0.996026,
      5,
      NULL,
      5,
      0.189754,
      NULL,
      NULL,
      NULL,
      0.176452,
      NULL,
      161.701520,
      1.395063,
      7.743442,
      NULL,
      0.224079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      13.461058,
      4,
      1,
      NULL,
      NULL,
      0.330638,
      NULL,
      1.690809,
      1.423714,
      0.022797,
      1,
      0,
      1.103923,
      1.300496,
      0.918330,
      1,
      1.342108,
      1,
      0.811117,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0.764183,
      0.620352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.558500,
      0.345062,
      NULL,
      NULL,
      1,
      2.240251,
      0,
      0,
      0.955337,
      NULL,
      1.864782,
      1,
      3,
      1.475765,
      1,
      1,
      3,
      0,
      1,
      NULL,
      0,
      1.670783,
      0,
      0,
      0.383655,
      1,
      0.188582,
      1.327327,
      0,
      NULL,
      NULL,
      NULL,
      0.067567,
      1,
      1,
      0.970060,
      NULL,
      NULL,
      1.512333,
      1,
      1,
      1,
      3.984793,
      0.417252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.116205,
      1,
      NULL,
      1.415736,
      NULL,
      0.056893,
      NULL,
      0.681126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076388,
      3,
      NULL,
      '',
      '',
      0.524958,
      '',
      '',
      '',
      1.976444,
      '',
      '',
      '');
commit;
end;
/


