set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '0011130',
      2.038435,
      0,
      2,
      1,
      '0304',
      2.379035,
      0.598244,
      NULL,
      NULL,
      ' 0- 9-2003',
      12.377331,
      NULL,
      2.253440,
      3,
      1.523550,
      ' 6-13-1991',
      61.317366,
      2.653710,
      235.184731,
      95.801591,
      1.631266,
      NULL,
      NULL,
      NULL,
      3,
      2.949451,
      0,
      1.688882,
      0.489122,
      0.605604,
      1.207615,
      0.177801,
      1.133160,
      131.515548,
      NULL,
      16.346080,
      4,
      164.955650,
      43,
      6.926083,
      4,
      4,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1.965412,
      1,
      1,
      0.212367,
      1,
      61.291531,
      4,
      5.191835,
      0,
      NULL,
      3,
      1,
      0,
      0.163324,
      NULL,
      0.887690,
      NULL,
      5,
      4.068490,
      1,
      1,
      0.078931,
      0.679821,
      NULL,
      3.724745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550152,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549749,
      0,
      3.676506,
      1.211730,
      NULL,
      1,
      1.985207,
      5,
      1.802597,
      1.367356,
      1,
      0.564475,
      0,
      9.932082,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      5.310706,
      2,
      0,
      NULL,
      2,
      5,
      3.700651,
      6,
      1.886410,
      7,
      7.499959,
      5,
      4,
      3,
      6.650140,
      4,
      6,
      0,
      NULL,
      7.865375,
      2.132401,
      NULL,
      2.182941,
      6,
      6,
      NULL,
      1,
      ' 6- 5-1999',
      1909.675118,
      ' 3-15-1977',
      573,
      1.335733,
      5,
      0,
      2,
      2.969567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.055984,
      3,
      2,
      0,
      3.339351,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1.223914,
      NULL,
      NULL,
      NULL,
      1.788968,
      3.908724,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0.161059,
      2.370631,
      NULL,
      0.659097,
      14664,
      NULL,
      0.229608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.277980,
      0.681279,
      NULL,
      NULL,
      1.939644,
      5,
      13.700595,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.405169,
      NULL,
      34.942908,
      10.201655,
      14,
      2.801651,
      1,
      5.509336,
      '24412',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0,
      '3200',
      '',
      '',
      1.267843,
      3,
      350.654227,
      0,
      0.541299,
      NULL,
      NULL,
      NULL,
      NULL,
      3.293900,
      3.840878,
      1.927618,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.078698,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.842285,
      NULL,
      NULL,
      3,
      1.812555,
      0.170275,
      NULL,
      NULL,
      3.484641,
      0.860330,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.749324,
      1.373642,
      NULL,
      NULL,
      2.659360,
      NULL,
      0.872639,
      NULL,
      1.486812,
      0,
      1.857241,
      0,
      0,
      0.088550,
      NULL,
      NULL,
      0,
      2.647045,
      2,
      1,
      1,
      NULL,
      1.040143,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.674085,
      NULL,
      NULL,
      0,
      3.703370,
      NULL,
      NULL,
      1.639329,
      NULL,
      NULL,
      NULL,
      0.499295,
      NULL,
      NULL,
      NULL,
      3,
      2.496487,
      1,
      1,
      NULL,
      NULL,
      2.822397,
      3,
      NULL,
      1.238110,
      NULL,
      NULL,
      NULL,
      7.889949,
      5,
      3,
      3,
      NULL,
      0.604798,
      0.136145,
      1,
      6,
      0,
      4.205638,
      1.089818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987814,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.915566,
      0,
      NULL,
      2,
      1.765635,
      1,
      9,
      NULL,
      0,
      NULL,
      4.604965,
      9,
      7.150673,
      4.989703,
      6,
      1.381859,
      NULL,
      NULL,
      1,
      0.841268,
      NULL,
      1,
      NULL,
      NULL,
      4.372051,
      5,
      6,
      2,
      NULL,
      2.941309,
      1,
      NULL,
      NULL,
      0.665093,
      NULL,
      0,
      0,
      2.235176,
      3.747950,
      5.324919,
      8,
      0.361909,
      6,
      0.666041,
      6.801249,
      2,
      NULL,
      NULL,
      1.096559,
      NULL,
      0.657494,
      0.196034,
      1.761254,
      0.010898,
      NULL,
      NULL,
      1.866211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.451304,
      NULL,
      NULL,
      1.808323,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      1.086265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607516,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.216475,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.567886,
      3,
      0,
      NULL,
      NULL,
      5.678060,
      NULL,
      NULL,
      NULL,
      29.163268,
      NULL,
      NULL,
      NULL,
      1.922803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.113722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765229,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      134,
      0.752693,
      NULL,
      NULL,
      0.094741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.770588,
      546,
      299,
      NULL,
      NULL,
      2.675662,
      127,
      1031.550557,
      1.333309,
      1,
      1.165194,
      0,
      1,
      0,
      NULL,
      1.534530,
      0.684996,
      1.347652,
      0.629293,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366274,
      0,
      0.875478,
      0.278235,
      NULL,
      2.585900,
      NULL,
      0,
      7,
      1.777032,
      0.411555,
      0.531814,
      19,
      17.290818,
      NULL,
      3.393947,
      1.264127,
      NULL,
      NULL,
      3.627263,
      NULL,
      12,
      15.175847,
      NULL,
      NULL,
      1.929736,
      NULL,
      3.568849,
      0,
      NULL,
      NULL,
      1.947631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0.961283,
      NULL,
      0.269533,
      1,
      1.733822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      13,
      NULL,
      0.837664,
      NULL,
      1.592505,
      NULL,
      0,
      NULL,
      12,
      NULL,
      0,
      NULL,
      15.450115,
      NULL,
      0.176368,
      NULL,
      16,
      NULL,
      3.876785,
      NULL,
      2,
      NULL,
      10,
      NULL,
      31.440555,
      0,
      NULL,
      1,
      NULL,
      1.305502,
      NULL,
      NULL,
      NULL,
      1.066227,
      1.916288,
      12,
      1.528443,
      1,
      NULL,
      23,
      30,
      NULL,
      1,
      4,
      NULL,
      '42312',
      '13041',
      0.019956,
      '',
      '',
      '',
      3.947378,
      '4131',
      NULL,
      '');
commit;
end;
/


