set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8236936';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '2130204',
      NULL,
      1.561160,
      2,
      3,
      '2221',
      3.963458,
      0.253413,
      0.209679,
      21.890838,
      ' 6- 8-2000',
      9,
      NULL,
      1,
      NULL,
      1,
      '11- 4-1983',
      NULL,
      1,
      NULL,
      9.707967,
      2.347567,
      ' 1-26-1996',
      ' 2-21-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      12.299996,
      1.877215,
      NULL,
      238,
      10.725393,
      15.605911,
      NULL,
      6.919791,
      NULL,
      6.423823,
      7.670430,
      4.534632,
      0,
      NULL,
      0.794427,
      3,
      NULL,
      NULL,
      1.925111,
      0.938714,
      0,
      1,
      0.633496,
      0.757017,
      0,
      2.254781,
      1,
      2.576189,
      NULL,
      5.447566,
      0.736742,
      0.443776,
      4.732284,
      1,
      NULL,
      NULL,
      1.148386,
      1.260742,
      3.346698,
      0.175357,
      0.217753,
      8,
      1,
      2,
      NULL,
      2.686259,
      1,
      NULL,
      NULL,
      1.423037,
      NULL,
      NULL,
      4,
      0.597077,
      NULL,
      0,
      1,
      3.461579,
      1.486010,
      0.166625,
      0,
      NULL,
      0,
      3,
      2.860665,
      1,
      1.714641,
      1.425225,
      1.610728,
      0.300762,
      1.195045,
      NULL,
      10.326866,
      1.586171,
      6,
      1,
      0.848429,
      2.358385,
      0.098103,
      NULL,
      NULL,
      1.733553,
      NULL,
      NULL,
      NULL,
      1,
      7.964732,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      4,
      4,
      NULL,
      6.233043,
      1.803452,
      1.215765,
      NULL,
      0.513938,
      0.780090,
      NULL,
      1,
      NULL,
      0.467927,
      1.175438,
      1,
      1.771042,
      1,
      2,
      1.112121,
      0,
      0.953419,
      0.224431,
      0.953065,
      2.097601,
      0,
      1,
      8.884100,
      NULL,
      5.457239,
      1.725580,
      1,
      7,
      4.270649,
      7.802685,
      NULL,
      2,
      5.240473,
      1.445119,
      ' 1-25-1975',
      NULL,
      NULL,
      1.990905,
      3.907036,
      0,
      0.494110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      8.882831,
      0,
      0,
      3,
      2.169779,
      0.985776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303538,
      NULL,
      15,
      1,
      NULL,
      6.657235,
      0,
      1.547647,
      0.742937,
      1,
      4,
      4,
      1.456380,
      NULL,
      NULL,
      NULL,
      NULL,
      5.126031,
      1,
      0.364207,
      9.885103,
      4,
      NULL,
      NULL,
      1.115224,
      NULL,
      NULL,
      0.683048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.382663,
      0,
      0.736729,
      2.811730,
      3.635141,
      1.237292,
      1,
      NULL,
      24.390988,
      0,
      NULL,
      106,
      1551.451610,
      1800.480803,
      NULL,
      1,
      0.822819,
      0.196983,
      7.094569,
      0.583102,
      NULL,
      2,
      2.105569,
      3,
      3.344351,
      NULL,
      2.559841,
      0,
      NULL,
      4,
      2,
      0.885947,
      0.911667,
      1.685021,
      0,
      1,
      NULL,
      1.559939,
      NULL,
      0.331731,
      1,
      1.084540,
      3.527418,
      0,
      4,
      1,
      4.816035,
      7,
      3,
      1,
      NULL,
      5,
      4.261108,
      0.048423,
      0,
      0,
      3.570904,
      1.251261,
      50.830342,
      3,
      0.319877,
      NULL,
      50.363261,
      21,
      26.970987,
      1,
      0.053868,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      3,
      NULL,
      25.743865,
      2.079656,
      1.257383,
      1.376099,
      0,
      12,
      4,
      3,
      3.909588,
      1.266068,
      NULL,
      NULL,
      NULL,
      0.824561,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      3,
      1.565586,
      3.093603,
      0.755888,
      0.992410,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.672970,
      2.906409,
      NULL,
      NULL,
      0.274212,
      1.929731,
      NULL,
      NULL,
      1.496197,
      NULL,
      NULL,
      NULL,
      8.256185,
      2.382893,
      0.325076,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409475,
      NULL,
      NULL,
      NULL,
      2.077971,
      1.829571,
      NULL,
      1.775704,
      NULL,
      0,
      0.467545,
      NULL,
      NULL,
      1.918482,
      3.982716,
      3.019634,
      NULL,
      0.084497,
      1,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      0,
      1.631810,
      0.915364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.927613,
      NULL,
      4.508496,
      8,
      1.283020,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.870287,
      1,
      3.989539,
      3.373210,
      NULL,
      1.826635,
      NULL,
      NULL,
      4,
      NULL,
      5.919525,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.930778,
      NULL,
      1,
      6,
      1.703966,
      NULL,
      NULL,
      1.128365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.485209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920368,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.066006,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      7,
      4.438668,
      3.435962,
      NULL,
      NULL,
      3.306260,
      2,
      2,
      0,
      NULL,
      2,
      3.239739,
      3.799504,
      0.522141,
      2.296313,
      NULL,
      8,
      2,
      0,
      0.482855,
      NULL,
      0.132772,
      3,
      1.672476,
      3.347827,
      2.628385,
      NULL,
      1.552128,
      1.769161,
      6.926812,
      NULL,
      0.688901,
      NULL,
      NULL,
      4.838077,
      NULL,
      3.829448,
      NULL,
      0.613111,
      NULL,
      NULL,
      0.622746,
      NULL,
      3.241727,
      NULL,
      NULL,
      4.207276,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.217409,
      NULL,
      NULL,
      0.053658,
      NULL,
      NULL,
      1.180613,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.568479,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.156962,
      NULL,
      NULL,
      1,
      1.049011,
      3.495004,
      0.305477,
      1.867338,
      3.669281,
      NULL,
      NULL,
      4.464187,
      1.692786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.918761,
      NULL,
      NULL,
      NULL,
      1.087049,
      NULL,
      NULL,
      NULL,
      3.594159,
      3.128696,
      NULL,
      NULL,
      0,
      1.886422,
      NULL,
      NULL,
      1.480822,
      2,
      NULL,
      NULL,
      0.715380,
      0,
      NULL,
      NULL,
      1.303701,
      0,
      NULL,
      NULL,
      0,
      0.849682,
      NULL,
      NULL,
      0.987619,
      1.184023,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.641928,
      1.473797,
      NULL,
      NULL,
      2.712162,
      NULL,
      NULL,
      NULL,
      2.868522,
      0.781300,
      NULL,
      NULL,
      1.686368,
      NULL,
      NULL,
      NULL,
      0.875027,
      2.679735,
      NULL,
      NULL,
      1.174136,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      3,
      8,
      1.351818,
      2,
      0,
      10,
      NULL,
      0.799892,
      20,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1406.733418,
      NULL,
      2.103458,
      6.103982,
      NULL,
      NULL,
      NULL,
      NULL,
      2.878449,
      12,
      0.195794,
      184.756645,
      126.540185,
      0,
      1,
      0,
      NULL,
      1.061772,
      0.968328,
      NULL,
      2,
      0,
      0,
      0,
      2,
      1.531684,
      0.852637,
      NULL,
      1.997383,
      0,
      3.281914,
      NULL,
      NULL,
      NULL,
      1.421348,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.826507,
      NULL,
      3.793357,
      NULL,
      3,
      NULL,
      48.857000,
      1,
      2.760511,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.914757,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.680677,
      NULL,
      0.849715,
      NULL,
      1.810624,
      0,
      1.584589,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835996,
      0.074605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.398799,
      NULL,
      NULL,
      NULL,
      0.530155,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.378014,
      0,
      0.681891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.544067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196527,
      1.414101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.603561,
      NULL,
      3.943267,
      2,
      1.361413,
      11,
      0.225833,
      2,
      1.812830,
      0.048338,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.760595,
      NULL,
      1.596710,
      NULL,
      NULL,
      1.526480,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.810237,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.988188,
      2,
      NULL,
      0.717359,
      1.571547,
      NULL,
      2,
      1,
      1.038902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      1.200190,
      3.831672,
      0,
      3.370465,
      53.662662,
      87,
      0,
      1,
      3.855363,
      '41443',
      '10432',
      '',
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


