set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4810533';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      '02',
      37.276811,
      10.454097,
      '1024403',
      2.691114,
      1,
      1,
      3,
      NULL,
      1.079065,
      0.766008,
      NULL,
      NULL,
      ' 0- 5-1997',
      1,
      36,
      NULL,
      3,
      NULL,
      ' 6-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      0.901532,
      ' 1-29-1989',
      ' 1-18-1994',
      ' 5- 1-1997',
      1.662999,
      0,
      NULL,
      0.328536,
      1.278157,
      1.003833,
      2.009119,
      NULL,
      1.020288,
      679.540707,
      11.984668,
      19.568163,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3.371018,
      1,
      NULL,
      1.990152,
      1.161686,
      NULL,
      NULL,
      1,
      1.879733,
      1.695617,
      1,
      0,
      0,
      139.138382,
      11,
      7,
      4,
      3,
      2.618028,
      1,
      1.557500,
      1.819278,
      NULL,
      3.918421,
      7,
      0,
      2.823078,
      NULL,
      0.594647,
      1,
      0.241390,
      3,
      5.062585,
      4,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3.156037,
      1,
      1.948247,
      NULL,
      0,
      NULL,
      1.986787,
      1.232023,
      1,
      0,
      0,
      1,
      1.404415,
      0,
      NULL,
      1,
      1.744999,
      NULL,
      1.625676,
      NULL,
      3,
      0.804481,
      0,
      0.463122,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.779178,
      2.868577,
      NULL,
      0,
      1.295980,
      5.050389,
      3.391204,
      4,
      1.596108,
      3.773167,
      NULL,
      3.530344,
      1.411689,
      8.714089,
      1.317383,
      0.959714,
      1.253879,
      1.131879,
      0,
      NULL,
      1.279466,
      1.340428,
      6,
      1.252147,
      0.028826,
      NULL,
      6,
      7,
      1.596699,
      1,
      0.811505,
      0.849818,
      1.208962,
      6.302014,
      NULL,
      8.418702,
      0,
      4.575932,
      5.542005,
      8.650068,
      2,
      1.026045,
      1,
      3.376742,
      NULL,
      NULL,
      1,
      1,
      ' 0-21-1986',
      1315.616206,
      ' 0- 7-1976',
      NULL,
      1,
      1.182927,
      1.888741,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.761227,
      4.971453,
      1.604325,
      2.608930,
      1,
      2.249993,
      2,
      6,
      1,
      0.589995,
      1.130638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.683461,
      5,
      3,
      1,
      6.215558,
      9,
      1,
      2,
      4,
      0,
      NULL,
      0.612925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      0.585702,
      0,
      167.808152,
      1,
      1.359820,
      NULL,
      NULL,
      NULL,
      1,
      1.048256,
      3.303746,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.632369,
      3,
      2.832352,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.493855,
      0.623086,
      1.343184,
      1.159854,
      1,
      1.788900,
      NULL,
      NULL,
      NULL,
      1,
      11,
      6,
      2,
      3.027027,
      2,
      0.601898,
      3.129297,
      2,
      4.479517,
      3,
      3,
      2.057574,
      NULL,
      0,
      2.603108,
      49,
      NULL,
      20.623696,
      24,
      2.233401,
      NULL,
      0,
      '0314',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.769442,
      '',
      '',
      '',
      0.913515,
      6,
      188.833576,
      0,
      1,
      NULL,
      57,
      0.769310,
      9.946877,
      3.508201,
      3,
      NULL,
      0.343947,
      NULL,
      NULL,
      0.334938,
      NULL,
      NULL,
      0.244017,
      0,
      2,
      1,
      3.266431,
      0,
      0.166884,
      NULL,
      NULL,
      1.016961,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.899231,
      NULL,
      NULL,
      1.758831,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.487162,
      NULL,
      NULL,
      9.559186,
      NULL,
      5.972270,
      0.342083,
      0,
      NULL,
      NULL,
      NULL,
      1.700228,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      1.097558,
      3.683178,
      1.007727,
      2.038401,
      1,
      3.126783,
      1,
      NULL,
      0.471133,
      NULL,
      NULL,
      3.302135,
      2.787593,
      3,
      NULL,
      3,
      1,
      1.483172,
      1,
      0.485238,
      1,
      0.077248,
      1.829364,
      NULL,
      NULL,
      1.760884,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.304461,
      NULL,
      NULL,
      NULL,
      1.909297,
      NULL,
      NULL,
      3.894152,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1.355469,
      NULL,
      NULL,
      6,
      5,
      NULL,
      NULL,
      NULL,
      3.359264,
      0.360860,
      2,
      3.601931,
      6,
      8,
      4,
      0.534163,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.521382,
      NULL,
      NULL,
      0.718770,
      NULL,
      NULL,
      0.753082,
      NULL,
      NULL,
      NULL,
      0.559726,
      1.152477,
      0,
      3.115360,
      2,
      3,
      3.810114,
      2.965067,
      3,
      5,
      0.269016,
      5.343548,
      3.650868,
      NULL,
      0.310671,
      0.121560,
      1,
      3,
      0.589357,
      0.735569,
      1,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      1.542196,
      0.578608,
      0.155910,
      5.804734,
      6,
      NULL,
      6,
      2.497638,
      3.735834,
      0.532983,
      5.601847,
      0.630939,
      1.730277,
      0.789193,
      NULL,
      0.611591,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.729278,
      NULL,
      NULL,
      0.431355,
      NULL,
      NULL,
      2.610031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.864726,
      NULL,
      1,
      1,
      1,
      0,
      3.333715,
      NULL,
      NULL,
      0.653508,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.572651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.508287,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      1.348296,
      NULL,
      NULL,
      7,
      2,
      NULL,
      NULL,
      1.971512,
      2.000337,
      7.421702,
      4.067226,
      NULL,
      300,
      176,
      0.885775,
      29.992577,
      0.088113,
      0.515909,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.883512,
      NULL,
      NULL,
      NULL,
      NULL,
      0.627357,
      79.122513,
      NULL,
      0.193727,
      NULL,
      NULL,
      0,
      1.720354,
      0,
      0,
      1.349561,
      1.406548,
      NULL,
      1.786005,
      1,
      1.209166,
      NULL,
      0,
      0.944540,
      0.033646,
      1.832069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262585,
      2.780247,
      3,
      NULL,
      NULL,
      3,
      5.685486,
      3.501243,
      7,
      1.591265,
      1.687025,
      2.639776,
      0.079527,
      0,
      1.140831,
      1.687721,
      1,
      NULL,
      NULL,
      3,
      0,
      0.747355,
      1.348502,
      1.906266,
      1,
      1.948537,
      0,
      1,
      NULL,
      1.201974,
      NULL,
      1.812665,
      NULL,
      NULL,
      0.700719,
      3.317647,
      1.192793,
      1,
      3.618006,
      1,
      2,
      1,
      NULL,
      1,
      3.156264,
      3.010418,
      NULL,
      0.306984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.503164,
      1,
      0,
      9,
      NULL,
      15,
      1.846523,
      3,
      3.597354,
      32,
      32,
      NULL,
      NULL,
      1,
      '0413',
      '',
      '',
      1,
      '',
      '',
      '',
      0.023436,
      '',
      '',
      '');
commit;
end;
/


