set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926229';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '2410433',
      1,
      0,
      3,
      0,
      NULL,
      3.883638,
      0.947864,
      NULL,
      NULL,
      ' 9-17-1975',
      2.262678,
      NULL,
      0,
      0,
      0.993754,
      '11- 4-1985',
      40,
      NULL,
      305,
      NULL,
      0,
      ' 5-24-1984',
      NULL,
      ' 1-18-1986',
      NULL,
      0.123206,
      1.510978,
      1,
      0.322210,
      1,
      0.660360,
      1.286945,
      0.200214,
      NULL,
      5.374639,
      10,
      1,
      2.203222,
      18.593733,
      NULL,
      32,
      7,
      1,
      NULL,
      3.315349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.798094,
      NULL,
      4,
      2,
      4.613830,
      1.404645,
      0.329797,
      3,
      0,
      1,
      1.203002,
      NULL,
      1,
      1,
      1.851114,
      NULL,
      NULL,
      1,
      3,
      0,
      1.970195,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.501672,
      NULL,
      NULL,
      1.127830,
      1,
      NULL,
      1.485554,
      0.494068,
      2,
      1.657880,
      1,
      1,
      0.427836,
      1,
      0,
      NULL,
      1.141045,
      0,
      2.468248,
      0.477998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.472458,
      NULL,
      NULL,
      0.036063,
      1,
      1.715873,
      1,
      4.765938,
      NULL,
      0,
      0.384238,
      1,
      NULL,
      1.102030,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.922762,
      1,
      1,
      1,
      0,
      2.179114,
      NULL,
      NULL,
      1.319921,
      1.741460,
      1,
      2.066358,
      4,
      0.036481,
      3,
      5,
      1.992011,
      6.182080,
      5,
      7.561298,
      4.691246,
      2,
      1,
      NULL,
      1.277625,
      1.206160,
      1.102891,
      NULL,
      140.535759,
      ' 8-21-1975',
      317.537919,
      NULL,
      1,
      0.376126,
      1.706642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968554,
      NULL,
      0,
      0.110256,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112884,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917292,
      0,
      1.262374,
      1,
      0.919909,
      1,
      1.809775,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.676021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543357,
      0,
      1,
      3,
      2,
      1.754475,
      1,
      1,
      20,
      3.717411,
      1.286468,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260060,
      1,
      3.209961,
      1,
      1,
      1.417040,
      3,
      3,
      NULL,
      3.293264,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1.425865,
      NULL,
      2.453529,
      0.533593,
      0.081441,
      0.033747,
      0.534826,
      1.028354,
      NULL,
      NULL,
      1.656589,
      1,
      1.091853,
      1.938795,
      1.864267,
      7.629864,
      0.150000,
      NULL,
      7.178584,
      11.745175,
      NULL,
      3,
      NULL,
      2,
      2,
      0.915284,
      0,
      51,
      NULL,
      2,
      NULL,
      51,
      91,
      NULL,
      0.514578,
      0,
      2.584262,
      '03420',
      '',
      NULL,
      1.212087,
      '',
      '',
      '',
      1.579374,
      '',
      '',
      '',
      2.331706,
      6,
      157,
      4.280774,
      1.886374,
      23.261620,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0.531523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.267718,
      2.391002,
      NULL,
      1.661760,
      NULL,
      0.248962,
      NULL,
      NULL,
      2.298888,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.021327,
      NULL,
      NULL,
      0.862102,
      1.877370,
      0.859197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      6.774770,
      3.104601,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.524248,
      2.749429,
      0,
      0.775092,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.621589,
      NULL,
      1,
      2,
      3,
      1.606543,
      3,
      2,
      2.160171,
      1.552414,
      NULL,
      3,
      0,
      0.675247,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.974671,
      0,
      1,
      7.102329,
      3.020600,
      3,
      1.954985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.880613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.892623,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.023195,
      NULL,
      NULL,
      0.230336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819351,
      NULL,
      NULL,
      0.304731,
      NULL,
      NULL,
      3.627225,
      0.731452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.094749,
      NULL,
      NULL,
      0.208430,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.850050,
      2,
      NULL,
      1.554517,
      NULL,
      NULL,
      NULL,
      6.423800,
      3.854115,
      3,
      NULL,
      NULL,
      0.026773,
      3.301038,
      NULL,
      1,
      NULL,
      NULL,
      0.424477,
      0.477113,
      3.088420,
      7,
      4,
      2.206992,
      4,
      NULL,
      0,
      2,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101037,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.271342,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.597036,
      NULL,
      NULL,
      3.683616,
      NULL,
      NULL,
      0,
      1,
      3,
      2.826680,
      NULL,
      NULL,
      NULL,
      2.840126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.268121,
      0,
      NULL,
      NULL,
      0.289820,
      NULL,
      NULL,
      NULL,
      3.556555,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.672020,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.504909,
      NULL,
      NULL,
      NULL,
      0.726499,
      NULL,
      NULL,
      NULL,
      0.866230,
      0,
      NULL,
      NULL,
      1.882642,
      1.865220,
      NULL,
      NULL,
      0.462493,
      3,
      NULL,
      NULL,
      1,
      0.603331,
      NULL,
      NULL,
      1.759535,
      1.280950,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1.602230,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      36,
      NULL,
      0,
      NULL,
      NULL,
      1.216259,
      NULL,
      NULL,
      2.978927,
      31.088637,
      3,
      0,
      31.584053,
      7,
      0,
      13.411983,
      1041,
      3,
      NULL,
      0,
      195.860683,
      9,
      0.096676,
      1,
      1,
      3,
      1.453078,
      NULL,
      0,
      0.799391,
      NULL,
      0,
      0.089098,
      2,
      1,
      0.826491,
      0,
      0.826469,
      1,
      2,
      NULL,
      1.172851,
      NULL,
      1.688210,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.633333,
      NULL,
      0,
      NULL,
      0.510464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.904177,
      NULL,
      0,
      NULL,
      NULL,
      2.173002,
      0.226982,
      3.013818,
      0,
      1,
      0,
      0,
      0.508118,
      NULL,
      0.283482,
      1,
      2,
      1.027078,
      0.346018,
      0,
      NULL,
      0.653098,
      0,
      0.060546,
      1.489898,
      0,
      1.805142,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1.266917,
      1,
      0,
      2,
      NULL,
      0.667246,
      0,
      0,
      NULL,
      1.963632,
      NULL,
      NULL,
      2.175319,
      1,
      NULL,
      1,
      0,
      3,
      3,
      NULL,
      3,
      3.469759,
      NULL,
      1.488607,
      0.597120,
      1.994557,
      1.354485,
      1,
      NULL,
      NULL,
      2.649155,
      0.500077,
      NULL,
      1,
      1.826355,
      0.194378,
      NULL,
      8,
      3.636473,
      NULL,
      1.784594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.062989,
      0.866315,
      0,
      1,
      1.016201,
      1,
      NULL,
      NULL,
      11.743568,
      NULL,
      0.878644,
      0,
      24.319731,
      NULL,
      1.525511,
      1,
      1,
      '11014',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL);
commit;
end;
/


