set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '31',
      19,
      8.115159,
      '4032121',
      3.676789,
      1,
      1,
      2,
      '2011',
      0,
      1,
      NULL,
      NULL,
      ' 4-15-1989',
      38,
      57.164988,
      NULL,
      0.401268,
      1,
      ' 5- 9-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 3-27-1980',
      ' 4-26-2002',
      NULL,
      1.953065,
      1,
      0.251824,
      1.127337,
      1.209620,
      2.329711,
      2,
      0,
      0.465225,
      17.363867,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.659490,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325135,
      1.002895,
      NULL,
      NULL,
      5.335544,
      NULL,
      1.989003,
      0,
      3,
      NULL,
      NULL,
      2.840065,
      1.555865,
      0.966634,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.590348,
      1,
      2.555397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.371063,
      1,
      1.368810,
      0.942022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149628,
      1,
      1,
      1.088605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.219830,
      NULL,
      7,
      NULL,
      0,
      0,
      1.743058,
      1,
      0.541764,
      1,
      NULL,
      1,
      0.503652,
      1.520046,
      1,
      1.564687,
      1.862327,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      3,
      1.626095,
      1,
      1,
      1,
      NULL,
      1,
      0.313491,
      NULL,
      NULL,
      NULL,
      9,
      6,
      3.070410,
      2.149826,
      NULL,
      9,
      9,
      2,
      NULL,
      2.477994,
      NULL,
      3,
      ' 2-19-1995',
      116,
      ' 0-13-1999',
      6,
      3,
      0.734035,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.641449,
      0.429421,
      0.147069,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      8,
      1.375557,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.275687,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.098731,
      0,
      2.258703,
      NULL,
      0,
      6.370998,
      2,
      NULL,
      NULL,
      NULL,
      1.504490,
      2.508421,
      1.203905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.982825,
      31,
      1.258436,
      1,
      NULL,
      NULL,
      NULL,
      2.559653,
      1.696624,
      2,
      3.431528,
      NULL,
      2.659709,
      3.107554,
      NULL,
      1.610051,
      0.392961,
      0.777302,
      1,
      3,
      0.349963,
      2,
      NULL,
      0.877689,
      NULL,
      1.861583,
      3,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.920367,
      0,
      NULL,
      0,
      9.086526,
      7,
      0.875453,
      NULL,
      NULL,
      0,
      NULL,
      0.085706,
      4.682851,
      2.364317,
      1.074598,
      NULL,
      21.888153,
      NULL,
      NULL,
      7,
      NULL,
      27.974933,
      31,
      NULL,
      NULL,
      0.872074,
      '1410',
      '30422',
      '',
      0.121641,
      NULL,
      NULL,
      '',
      3.556751,
      '24203',
      NULL,
      '',
      0,
      15,
      35,
      11.134398,
      0.110379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073521,
      NULL,
      NULL,
      1.188804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.462818,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751333,
      NULL,
      NULL,
      0.549103,
      NULL,
      NULL,
      1.877870,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.244267,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.500074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705864,
      0,
      0,
      1,
      3,
      2,
      1.288565,
      NULL,
      NULL,
      3.530303,
      0,
      3.768869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858077,
      NULL,
      NULL,
      0.448709,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.376644,
      1,
      2.854289,
      1.106006,
      NULL,
      1.425809,
      7,
      NULL,
      1.465011,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3.462044,
      3.048759,
      2.712594,
      1,
      0.463069,
      1.607505,
      NULL,
      NULL,
      0,
      NULL,
      2,
      5.861631,
      2,
      1.456249,
      1,
      NULL,
      3.572062,
      2.169367,
      2,
      NULL,
      2.733576,
      0,
      1.546065,
      2.959618,
      9,
      3.019121,
      7,
      1,
      6,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.043122,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      1,
      1,
      1.969132,
      0.338018,
      1,
      NULL,
      NULL,
      NULL,
      14.853163,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.184660,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.783513,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.519460,
      NULL,
      NULL,
      NULL,
      0.353011,
      NULL,
      NULL,
      NULL,
      3.296105,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.853864,
      NULL,
      NULL,
      NULL,
      3.770451,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.622414,
      343.280517,
      0.208670,
      2,
      701,
      1.325443,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.750306,
      0.089589,
      1.401636,
      0,
      1,
      0,
      0.623997,
      1,
      NULL,
      1.902357,
      NULL,
      NULL,
      0.730822,
      1.694975,
      0.812273,
      0,
      0.133109,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.301635,
      0.521612,
      2,
      NULL,
      2,
      4.685341,
      NULL,
      11.648624,
      1,
      2.726953,
      1.816759,
      NULL,
      1.712517,
      NULL,
      0,
      1.986920,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      1.045635,
      0.634031,
      NULL,
      2,
      0.000628,
      NULL,
      1,
      1.105973,
      NULL,
      0.430976,
      2,
      NULL,
      3,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3.845186,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471000,
      NULL,
      0,
      NULL,
      1.646002,
      NULL,
      1.182746,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      30,
      153.698427,
      0.084111,
      4.982390,
      5.482428,
      NULL,
      '24200',
      '',
      0,
      '',
      '',
      '',
      3,
      '44044',
      '',
      '');
commit;
end;
/


