set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9670225';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30',
      '33',
      NULL,
      5.947158,
      '4203340',
      1,
      NULL,
      NULL,
      2,
      '1344',
      4.471650,
      1.356527,
      NULL,
      NULL,
      ' 5-16-1975',
      178.005880,
      1,
      NULL,
      2,
      0.142040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-26-2001',
      NULL,
      '10-29-1995',
      NULL,
      3.707774,
      0,
      0,
      1.396665,
      0,
      2.596590,
      2.235471,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.882537,
      NULL,
      1.519077,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1.441576,
      0,
      1.902278,
      0.481288,
      1.397170,
      5.198078,
      2.406708,
      1,
      9,
      1,
      0.333677,
      5,
      2.868979,
      10.443026,
      0.920471,
      6,
      7,
      0.640289,
      8,
      4.372573,
      6.449319,
      0.759481,
      4.050710,
      2.806594,
      3.139018,
      3.949350,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0,
      3.052208,
      2.982046,
      0,
      1,
      3,
      1.874341,
      2,
      0,
      0,
      NULL,
      1,
      3.518535,
      1.520998,
      2.813481,
      2.380180,
      4,
      3,
      NULL,
      2.372433,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      0.012530,
      NULL,
      NULL,
      7,
      0,
      7,
      NULL,
      6,
      7,
      9,
      3,
      4,
      7,
      NULL,
      3,
      1,
      NULL,
      1,
      0.389648,
      NULL,
      0,
      1.563162,
      NULL,
      1,
      3,
      0.245388,
      4,
      NULL,
      4,
      1,
      NULL,
      NULL,
      1,
      6,
      2,
      1,
      6.254569,
      NULL,
      NULL,
      5.955317,
      NULL,
      NULL,
      NULL,
      5,
      7,
      1,
      11.732767,
      9,
      10.101782,
      3,
      3.596420,
      NULL,
      NULL,
      ' 6- 7-1979',
      NULL,
      NULL,
      0.682742,
      NULL,
      6.999539,
      2,
      NULL,
      2,
      NULL,
      1.951064,
      1.442305,
      0,
      7,
      8.455101,
      6,
      4,
      NULL,
      10,
      11,
      NULL,
      12.815443,
      3.504904,
      ' 8-16-1989',
      3,
      ' 3- 9-1977',
      NULL,
      1,
      NULL,
      0.934390,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.986036,
      NULL,
      2.632620,
      3,
      3.600906,
      5.625144,
      1,
      5,
      1.615546,
      1,
      2.208794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.463982,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.740070,
      0,
      0,
      2,
      NULL,
      NULL,
      1.952545,
      1,
      11.460258,
      1.012361,
      0.524277,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      1.694786,
      NULL,
      1.851458,
      1,
      0,
      2,
      NULL,
      NULL,
      2.215403,
      2,
      0.937150,
      0.360937,
      3,
      0.486757,
      NULL,
      1.841625,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.771315,
      0.674143,
      0,
      1.187233,
      NULL,
      7.736422,
      1,
      0,
      1,
      4,
      NULL,
      1,
      0.271102,
      NULL,
      2,
      4.242497,
      0.993745,
      3,
      NULL,
      54.974526,
      1.526131,
      2,
      4,
      NULL,
      0,
      56.247717,
      1.124500,
      NULL,
      2,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0,
      '33224',
      '',
      '',
      2.466910,
      3.281069,
      NULL,
      5,
      NULL,
      29.052804,
      2,
      3,
      3,
      NULL,
      3,
      3.443503,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444688,
      NULL,
      0.992538,
      NULL,
      2.596087,
      NULL,
      2.091456,
      NULL,
      3,
      1.246858,
      1.414082,
      0.346275,
      NULL,
      1,
      NULL,
      3,
      0,
      0,
      0.377758,
      1.602388,
      0.616068,
      1,
      0.170193,
      0.887128,
      1,
      0.076941,
      NULL,
      NULL,
      8,
      0.925733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.333669,
      2,
      3,
      1.226171,
      0.775798,
      0,
      2.022157,
      NULL,
      1,
      2.226531,
      0.307722,
      2,
      1,
      1.389044,
      0.949495,
      NULL,
      2.718618,
      3.098645,
      3.234002,
      NULL,
      0,
      3,
      NULL,
      1,
      2,
      0,
      NULL,
      3.264294,
      0.802396,
      NULL,
      NULL,
      3.207459,
      0,
      7,
      7,
      0.613839,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981683,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742520,
      0,
      1.671732,
      NULL,
      0,
      2,
      2.649017,
      1.633460,
      NULL,
      NULL,
      1,
      8.638265,
      2,
      0,
      1,
      0,
      1,
      2.933578,
      1.629863,
      2,
      0,
      5.666565,
      3.606647,
      1,
      NULL,
      NULL,
      1.397009,
      NULL,
      NULL,
      1.407923,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.662429,
      1,
      2.477840,
      1.030402,
      0.969818,
      3,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      1,
      2,
      NULL,
      0.194351,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      7.273722,
      NULL,
      NULL,
      1,
      1.790475,
      1.467554,
      1,
      NULL,
      NULL,
      0.604645,
      3,
      3.686848,
      2,
      0,
      3,
      3.000617,
      7.348651,
      1.282573,
      2.599617,
      NULL,
      NULL,
      3,
      3.548747,
      3.599052,
      1.123471,
      1.906267,
      1,
      NULL,
      NULL,
      1.520195,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.562968,
      NULL,
      NULL,
      0.720907,
      NULL,
      NULL,
      7.155822,
      NULL,
      NULL,
      2.328560,
      0.624256,
      0.145207,
      1.786423,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.866019,
      NULL,
      NULL,
      NULL,
      26.505396,
      NULL,
      NULL,
      NULL,
      0.399678,
      NULL,
      NULL,
      NULL,
      0.964005,
      NULL,
      NULL,
      NULL,
      1.101472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.940171,
      NULL,
      NULL,
      NULL,
      2.892333,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.242427,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.859586,
      NULL,
      NULL,
      NULL,
      1.835457,
      NULL,
      NULL,
      NULL,
      0.646807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.162728,
      NULL,
      NULL,
      NULL,
      0,
      48,
      12.841566,
      3,
      14,
      NULL,
      1,
      NULL,
      NULL,
      2.843024,
      0,
      1.685631,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.389936,
      319.755229,
      14.794990,
      0.185605,
      1.114115,
      1.231427,
      0.742990,
      0.142789,
      NULL,
      1,
      NULL,
      NULL,
      3.491196,
      1,
      2.075966,
      0.197621,
      1.544990,
      1.330052,
      1,
      1,
      3.198482,
      NULL,
      1,
      NULL,
      1.192163,
      NULL,
      1.187774,
      NULL,
      1.059013,
      NULL,
      1.625520,
      NULL,
      6.218900,
      NULL,
      NULL,
      7,
      NULL,
      0.425519,
      1,
      NULL,
      NULL,
      0.203050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.270170,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.847837,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.533635,
      NULL,
      1,
      3,
      NULL,
      0.372978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.025082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129014,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.363073,
      NULL,
      3,
      NULL,
      2,
      NULL,
      6.159860,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.175423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796087,
      3.580891,
      2,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640594,
      1.618009,
      0,
      1.173879,
      0.309195,
      1,
      0.224390,
      NULL,
      1,
      0.361748,
      3,
      0.884844,
      1.664793,
      3,
      NULL,
      1.437258,
      3.376629,
      NULL,
      1,
      2.152297,
      NULL,
      NULL,
      0.917391,
      NULL,
      1.122337,
      1,
      NULL,
      1.697940,
      1,
      NULL,
      1.673978,
      NULL,
      NULL,
      1,
      0.443307,
      NULL,
      0.745398,
      1,
      NULL,
      1.647070,
      2,
      NULL,
      1.324027,
      1.038369,
      NULL,
      NULL,
      1,
      1.076981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217906,
      NULL,
      1,
      NULL,
      0.046444,
      NULL,
      0,
      2.308079,
      0.819851,
      1.989797,
      NULL,
      NULL,
      92,
      NULL,
      0.515805,
      NULL,
      1,
      '13344',
      '42220',
      '',
      NULL,
      '',
      '',
      '',
      2.641754,
      '30312',
      NULL,
      NULL);
commit;
end;
/


