set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      1,
      '0023',
      3,
      0,
      NULL,
      NULL,
      '10-26-1996',
      23.669914,
      NULL,
      3,
      2,
      0,
      ' 3- 0-1982',
      27.944548,
      3.058699,
      13.999227,
      NULL,
      3,
      NULL,
      NULL,
      ' 5-14-1976',
      NULL,
      NULL,
      1.387192,
      0.444643,
      NULL,
      2,
      NULL,
      1.793947,
      NULL,
      NULL,
      NULL,
      8.816849,
      0,
      16,
      8.760230,
      4,
      28,
      1.929122,
      NULL,
      6.856084,
      1.935976,
      2,
      NULL,
      NULL,
      0,
      1,
      0.893887,
      NULL,
      NULL,
      0,
      0.388744,
      3.399819,
      4.332665,
      9,
      NULL,
      3.975014,
      1,
      1.263158,
      0.367399,
      1,
      1,
      6,
      NULL,
      NULL,
      1.953064,
      0,
      1.732264,
      1,
      1,
      2.102400,
      NULL,
      0.631824,
      1.764486,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.440508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.237278,
      1.306809,
      0,
      1.701249,
      4,
      0.029479,
      0,
      2.635735,
      1.069772,
      1,
      0,
      2,
      NULL,
      1,
      1,
      0.671305,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1.564326,
      2,
      0,
      0.671435,
      3.649480,
      NULL,
      1,
      1,
      5,
      1,
      0.347167,
      NULL,
      1,
      1,
      2.228693,
      NULL,
      1.653255,
      0.068307,
      8.776986,
      NULL,
      NULL,
      3,
      3,
      ' 1-15-1996',
      115,
      NULL,
      63,
      3,
      NULL,
      1.132923,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.820595,
      1.978434,
      0,
      1.833402,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8,
      0.170446,
      NULL,
      6,
      0.499416,
      1,
      1.948790,
      1.770099,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.322340,
      0.040408,
      4.924402,
      0.063220,
      1,
      1.647494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.686722,
      1,
      NULL,
      0,
      1,
      0.894908,
      0.945333,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.529019,
      0.380727,
      3.040492,
      1.643522,
      0.483552,
      NULL,
      NULL,
      2.859742,
      0.239992,
      2,
      NULL,
      3.190527,
      0,
      NULL,
      0.375183,
      NULL,
      NULL,
      1.852965,
      0.028988,
      1,
      1.161108,
      0,
      NULL,
      1.766890,
      0.801527,
      1.061390,
      0,
      0.530022,
      2,
      NULL,
      0,
      0.739364,
      8,
      3,
      6.575846,
      3.778981,
      NULL,
      3.307989,
      NULL,
      1,
      3.328058,
      0.139006,
      NULL,
      38.326896,
      2,
      0,
      6,
      NULL,
      NULL,
      NULL,
      3.214666,
      NULL,
      1,
      '33411',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      NULL,
      37,
      NULL,
      18.384996,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.580937,
      NULL,
      0.678604,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683890,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.112232,
      NULL,
      0.748773,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105656,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.771538,
      NULL,
      NULL,
      4.328877,
      1.352358,
      0.153826,
      NULL,
      0.118904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520205,
      NULL,
      NULL,
      0.323028,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.805404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792198,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.232189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.536016,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.616715,
      NULL,
      NULL,
      1.810587,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.501177,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.831940,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      5.873071,
      3.914830,
      1.909451,
      NULL,
      NULL,
      NULL,
      1.414320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.491496,
      0.007249,
      3.627959,
      1.729881,
      NULL,
      NULL,
      3.381774,
      3,
      0,
      2.711376,
      NULL,
      3,
      NULL,
      1.579872,
      0,
      NULL,
      2,
      5.522615,
      7,
      3,
      3.108706,
      2,
      0,
      1,
      3,
      NULL,
      1,
      0,
      0.385420,
      1,
      1.401975,
      3.559279,
      NULL,
      NULL,
      0.604215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.201650,
      NULL,
      NULL,
      0.957380,
      NULL,
      NULL,
      1.702193,
      NULL,
      NULL,
      0.857935,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.303614,
      NULL,
      1,
      0.649757,
      1.478008,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.244243,
      NULL,
      NULL,
      NULL,
      0.046805,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.760106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.357934,
      1.937468,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      1.679674,
      NULL,
      NULL,
      1.325183,
      0,
      NULL,
      NULL,
      2,
      1.986697,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.628938,
      NULL,
      2,
      1.984588,
      0,
      NULL,
      NULL,
      0.687330,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.893295,
      NULL,
      NULL,
      1.050819,
      NULL,
      0.208848,
      1.444721,
      NULL,
      0.952809,
      1,
      NULL,
      0,
      0,
      0.140328,
      0,
      NULL,
      1.688128,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0.499847,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.877042,
      2.023301,
      3,
      7,
      NULL,
      0.862747,
      0.167953,
      2,
      4,
      2,
      2.937403,
      3,
      1.363641,
      0,
      NULL,
      0.645640,
      NULL,
      0.722762,
      1,
      1.763141,
      0.718980,
      0,
      0,
      0.714700,
      NULL,
      1,
      0,
      1,
      0,
      2.200469,
      0,
      3.516031,
      0.102211,
      NULL,
      3,
      1.073781,
      1.744416,
      1.143899,
      1,
      0.819119,
      0.454194,
      1.810738,
      1.740399,
      1.586857,
      1,
      NULL,
      3,
      1.396340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418382,
      1.203565,
      0,
      1,
      NULL,
      1,
      NULL,
      5.859708,
      4,
      NULL,
      NULL,
      NULL,
      114.468997,
      66.519821,
      1,
      0.142733,
      1.704858,
      '01341',
      '',
      '',
      1.015188,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


