set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '3304101',
      3,
      0.783796,
      0,
      0,
      '1341',
      3.062743,
      1.432203,
      NULL,
      NULL,
      ' 8- 8-1976',
      29.652763,
      NULL,
      3.581723,
      3,
      3.403931,
      ' 7-19-1997',
      NULL,
      NULL,
      231,
      107,
      3.356475,
      ' 8- 4-1975',
      ' 9-27-1997',
      ' 8-15-1994',
      3,
      1,
      3,
      NULL,
      1.987549,
      0.450995,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      16.126101,
      17,
      5.289275,
      27,
      2,
      5,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      0.788667,
      0.440878,
      0,
      0,
      1,
      0,
      5.046777,
      3,
      1.838122,
      1.906172,
      1.844530,
      NULL,
      1,
      2,
      1,
      0,
      0.822192,
      1,
      NULL,
      0,
      3,
      0,
      5.053165,
      1.384768,
      1.161895,
      0.938379,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      4.178633,
      NULL,
      0,
      1,
      2.794207,
      2,
      3.554015,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.077350,
      0.956647,
      1,
      1,
      1.222209,
      7,
      0.524026,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.426899,
      1.056754,
      0.270052,
      0,
      3.857561,
      0.614486,
      0,
      NULL,
      NULL,
      NULL,
      2.591989,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.258037,
      1,
      NULL,
      NULL,
      1,
      0.906872,
      0.227063,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      0.290833,
      0,
      5.212788,
      1,
      0,
      1.157904,
      NULL,
      NULL,
      7,
      4,
      3,
      NULL,
      0.002749,
      2,
      3.650867,
      2.102398,
      1,
      NULL,
      1.379747,
      ' 7-15-1994',
      126.421338,
      ' 5-14-1985',
      16,
      0.160129,
      NULL,
      1,
      2,
      0.718049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1.496851,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.473386,
      NULL,
      4,
      0,
      1.079340,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.826138,
      0.960632,
      1,
      3.908699,
      1,
      5.137323,
      NULL,
      4,
      1,
      NULL,
      2.601727,
      0,
      2,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.731557,
      1.859395,
      0,
      1.685423,
      0,
      0,
      NULL,
      2.984840,
      16.720830,
      0,
      1.055436,
      NULL,
      NULL,
      NULL,
      0.295872,
      0.753910,
      2,
      1.800441,
      2,
      1,
      NULL,
      2.299877,
      3,
      2.198167,
      NULL,
      1.548392,
      1.227590,
      3.795362,
      0.769894,
      NULL,
      3,
      0.897967,
      0,
      0,
      NULL,
      0.787302,
      1,
      1.241997,
      0.675448,
      1,
      0.587539,
      NULL,
      0,
      3,
      2.238688,
      1.968416,
      9.189450,
      8.166466,
      NULL,
      2.091326,
      9,
      NULL,
      1,
      0,
      NULL,
      1.281491,
      1.171225,
      3.541316,
      34.658055,
      1,
      0,
      NULL,
      22.834491,
      2,
      64.692912,
      3.459863,
      0,
      NULL,
      '33234',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      21,
      23.492646,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522750,
      3.074686,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895124,
      NULL,
      NULL,
      1.661409,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.430211,
      NULL,
      3,
      0,
      1.795114,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.582867,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.374616,
      1,
      0.401225,
      3,
      NULL,
      NULL,
      0.409511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.383842,
      NULL,
      NULL,
      0.490257,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.062279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.121627,
      0.868049,
      4.036808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.917423,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2.061637,
      0.476647,
      0,
      0.157242,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.302791,
      NULL,
      0,
      3.746161,
      0.313891,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.796398,
      NULL,
      1.989214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.439245,
      0,
      NULL,
      0,
      NULL,
      0.727428,
      0.173568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.311431,
      NULL,
      6.948249,
      NULL,
      NULL,
      0,
      3.631464,
      2,
      3,
      1,
      0.872306,
      NULL,
      NULL,
      NULL,
      1.349520,
      NULL,
      1.248782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416746,
      96.793363,
      0.925206,
      0,
      0.453726,
      1.767030,
      1.365158,
      0.436148,
      0.059430,
      NULL,
      0.663696,
      1.563214,
      1.333510,
      NULL,
      NULL,
      NULL,
      0,
      0.089349,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      7,
      1.752750,
      NULL,
      0.001087,
      2,
      NULL,
      3,
      2.923580,
      NULL,
      0.652081,
      1,
      0,
      1,
      0,
      1.442515,
      1.823240,
      1,
      2.688856,
      NULL,
      1,
      0.907722,
      2.487454,
      3,
      0,
      1.076367,
      0,
      1.825642,
      0,
      0,
      2.768796,
      0,
      1,
      NULL,
      1,
      0.190814,
      0.425940,
      0.288770,
      NULL,
      NULL,
      1.912816,
      1.318190,
      1,
      3.812619,
      2.668501,
      1.240003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.253749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.637314,
      1.149970,
      1,
      0.948829,
      0,
      1.890620,
      7.184987,
      7.811363,
      1.223050,
      NULL,
      NULL,
      NULL,
      116,
      3,
      1,
      1,
      '22232',
      NULL,
      '',
      0.968027,
      '',
      '',
      NULL,
      1.096380,
      '',
      '',
      '');
commit;
end;
/


