set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '3304200',
      1.304800,
      1.603612,
      NULL,
      1,
      '4014',
      2.031744,
      1,
      NULL,
      NULL,
      ' 4-23-1977',
      7,
      NULL,
      NULL,
      1.101991,
      0,
      NULL,
      9.434505,
      2,
      248.918876,
      NULL,
      NULL,
      ' 8-15-1997',
      NULL,
      '10- 5-1996',
      3.424958,
      3.763728,
      1.030226,
      3,
      1,
      1,
      3.330360,
      NULL,
      1.807851,
      0,
      1,
      16,
      3,
      1.453396,
      9.978557,
      3,
      2,
      8,
      NULL,
      8.590722,
      1.429532,
      0,
      1,
      0,
      0,
      0,
      1.061916,
      1,
      0,
      0.481419,
      NULL,
      1,
      3.287199,
      3.032227,
      3.690888,
      6.060727,
      1.634498,
      1.488520,
      NULL,
      8.304360,
      NULL,
      8,
      7.142582,
      7,
      0.289223,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2.563155,
      0,
      NULL,
      NULL,
      0.118905,
      NULL,
      NULL,
      7,
      5,
      7.792151,
      NULL,
      1,
      1.750872,
      3,
      NULL,
      0.924490,
      2,
      0,
      0.247809,
      0.261860,
      2,
      1.041317,
      NULL,
      NULL,
      0.442672,
      0,
      8.055916,
      0.626064,
      9,
      7.965785,
      NULL,
      0,
      2,
      1.275574,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.383989,
      NULL,
      3,
      1.393028,
      5,
      2,
      5,
      NULL,
      0.122359,
      1.234420,
      3,
      1,
      0.505062,
      2,
      0.069282,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      0.242979,
      4.674323,
      NULL,
      0.584202,
      1.617532,
      0,
      2,
      4,
      3.806305,
      0.307372,
      NULL,
      1,
      0,
      1.940278,
      0,
      11,
      2,
      2,
      10,
      6,
      3,
      0,
      NULL,
      0.047876,
      3.304211,
      NULL,
      1.547962,
      '11-15-1976',
      135,
      NULL,
      22.580703,
      NULL,
      2,
      0,
      5.851411,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.991133,
      0,
      5,
      7.794544,
      2.758754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.642734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.249076,
      0.934059,
      NULL,
      0,
      9.853529,
      3,
      1.503483,
      NULL,
      NULL,
      NULL,
      3,
      1,
      6,
      2,
      0,
      1.704595,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281063,
      0.355400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808870,
      0,
      0,
      0.994444,
      1.219364,
      1.958135,
      1.979448,
      1.166204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.934365,
      0,
      2.113030,
      0,
      1.300004,
      0.934305,
      1.903537,
      3,
      3,
      2.649531,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.807623,
      4,
      0,
      1,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0.559789,
      0,
      0,
      0,
      5.942929,
      0.204038,
      6.539822,
      1.550097,
      0.051531,
      NULL,
      1,
      2,
      4.161320,
      0.516809,
      NULL,
      2.950725,
      0.089294,
      3.404598,
      45,
      1.417240,
      0,
      NULL,
      18,
      29,
      74,
      1.451073,
      NULL,
      3,
      '34111',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      29.069918,
      12,
      1.949077,
      3,
      NULL,
      1.593642,
      NULL,
      3,
      NULL,
      2,
      1,
      1.988980,
      NULL,
      NULL,
      2.275649,
      1.111801,
      0.719953,
      3.152255,
      0,
      3,
      1.266766,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2.323401,
      2,
      0,
      2,
      1.895836,
      NULL,
      3,
      2,
      NULL,
      0.175612,
      NULL,
      NULL,
      1,
      2.364906,
      3.627831,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622387,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297097,
      1.706334,
      2,
      3.639384,
      1,
      2.885920,
      0.216319,
      1,
      3.623066,
      3,
      0,
      2.327566,
      2,
      2.209938,
      3.071620,
      0,
      1,
      0,
      3,
      NULL,
      2,
      0.994721,
      NULL,
      3.385529,
      NULL,
      0,
      1,
      1.539574,
      NULL,
      NULL,
      1.667941,
      NULL,
      1,
      9.838575,
      4,
      0.552836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.191659,
      NULL,
      NULL,
      3.149205,
      1,
      0.833479,
      NULL,
      3,
      0.543222,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.848423,
      2,
      1.886223,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.457977,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418949,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.966225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624236,
      2.109085,
      NULL,
      2,
      4.228739,
      1.142339,
      3,
      6.631467,
      0.424322,
      0.630360,
      4.288255,
      NULL,
      1,
      1,
      0.831109,
      2,
      3,
      NULL,
      3,
      NULL,
      1,
      9,
      NULL,
      4,
      NULL,
      2.315439,
      2,
      2.856515,
      2,
      2.296151,
      2.676264,
      0.312039,
      NULL,
      2,
      NULL,
      1,
      2.433777,
      6.434385,
      7.266095,
      7.348868,
      NULL,
      0.046362,
      3.122220,
      2,
      2.215772,
      0.772831,
      0.295641,
      0.282194,
      0.819007,
      0,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.259529,
      NULL,
      NULL,
      1.698484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.946965,
      NULL,
      NULL,
      0.414915,
      0.592864,
      1,
      1,
      1,
      0.145490,
      1.486337,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.175292,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.070160,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.580807,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      248.088640,
      16,
      1,
      1.955562,
      0.868620,
      NULL,
      1,
      NULL,
      1.044616,
      0.444285,
      NULL,
      NULL,
      0,
      2.431023,
      0.404163,
      3.100266,
      0,
      0,
      0,
      NULL,
      NULL,
      2.067045,
      NULL,
      3.152527,
      NULL,
      0.648978,
      NULL,
      2.271180,
      NULL,
      NULL,
      NULL,
      64.832315,
      NULL,
      3,
      NULL,
      25.193956,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594257,
      NULL,
      NULL,
      NULL,
      0.225624,
      NULL,
      1.411801,
      NULL,
      1.854352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.489803,
      NULL,
      0,
      NULL,
      NULL,
      3.433383,
      0.914717,
      1.546845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891309,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.710414,
      NULL,
      1.717577,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.099771,
      NULL,
      1.522961,
      NULL,
      NULL,
      NULL,
      1.430734,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.041591,
      1.408512,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412399,
      NULL,
      NULL,
      NULL,
      0.118153,
      NULL,
      1.984352,
      NULL,
      1,
      1,
      1.198760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.899707,
      3,
      0.496481,
      2,
      NULL,
      2.173556,
      2.545926,
      1,
      7,
      2,
      3.121724,
      0,
      1,
      3,
      NULL,
      0.143743,
      2,
      NULL,
      3.313678,
      3,
      NULL,
      1,
      0.711631,
      NULL,
      NULL,
      NULL,
      NULL,
      0.442190,
      0,
      NULL,
      0,
      0,
      NULL,
      0.163229,
      1,
      NULL,
      NULL,
      1.884883,
      NULL,
      2.494400,
      3.216277,
      NULL,
      0.499263,
      0.476407,
      NULL,
      NULL,
      0.153502,
      1.555411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789109,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.514508,
      2,
      0.936307,
      NULL,
      NULL,
      36.948967,
      NULL,
      4.958702,
      NULL,
      5,
      '02404',
      '34443',
      NULL,
      1.448663,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


