set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602311';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.130179,
      NULL,
      0,
      1.763717,
      0,
      2.171024,
      3,
      2,
      '420',
      '13040014',
      NULL,
      49,
      '1321214',
      3.257207,
      NULL,
      2,
      NULL,
      '4234',
      2.342972,
      NULL,
      NULL,
      NULL,
      ' 6-17-1982',
      199.349985,
      258,
      NULL,
      3.784979,
      NULL,
      '11-14-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.662230,
      2,
      1,
      0.974025,
      NULL,
      1.961219,
      NULL,
      NULL,
      NULL,
      9.093988,
      4.719851,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.793493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522353,
      0.282547,
      NULL,
      2,
      6,
      0,
      0,
      0.939640,
      2,
      0,
      4,
      2,
      5,
      NULL,
      1,
      NULL,
      7.961885,
      0,
      2.551178,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.746953,
      NULL,
      4,
      2.543337,
      NULL,
      1.009305,
      1.011799,
      0,
      0,
      2.607631,
      NULL,
      2,
      1,
      NULL,
      1.522502,
      NULL,
      0,
      1.953788,
      NULL,
      1,
      1,
      0.151976,
      4,
      0,
      3.280110,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288220,
      0,
      0,
      4,
      3,
      4.364363,
      0,
      0.345423,
      NULL,
      NULL,
      0,
      0,
      1.734779,
      0.616308,
      1,
      1.693347,
      1,
      1.589366,
      1.809278,
      NULL,
      1.559049,
      NULL,
      5,
      4.637161,
      1.374715,
      1,
      4,
      2,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1.956126,
      NULL,
      2,
      5,
      4.782877,
      3.334401,
      1,
      0,
      0,
      3,
      1.411833,
      0,
      0,
      0.890251,
      NULL,
      522,
      '11-22-1995',
      824,
      NULL,
      0.586713,
      1.623798,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.558143,
      1.974131,
      0.962982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.025328,
      1.366336,
      0.179089,
      2.859418,
      0.518367,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.669380,
      NULL,
      NULL,
      0,
      1.638573,
      1,
      NULL,
      0,
      NULL,
      3,
      2,
      35,
      155,
      29,
      0.152485,
      1,
      3,
      0,
      1,
      2,
      3.597931,
      2.411201,
      1,
      NULL,
      3.626778,
      NULL,
      0.844238,
      NULL,
      3.978027,
      2,
      NULL,
      0,
      NULL,
      1.581639,
      NULL,
      1,
      0,
      NULL,
      1.554331,
      NULL,
      1.697479,
      1,
      0.837910,
      0,
      5,
      0.264784,
      10,
      NULL,
      NULL,
      1.047020,
      7,
      7.894887,
      0,
      2,
      4,
      2,
      1.731169,
      2,
      57,
      NULL,
      0.455136,
      59.616123,
      NULL,
      NULL,
      NULL,
      4.486016,
      0.745603,
      NULL,
      NULL,
      '30101',
      '',
      0,
      '',
      '',
      '',
      1.280915,
      '3110',
      '',
      '',
      0,
      15,
      209.710649,
      41.483168,
      1.955060,
      36.010398,
      10.334335,
      5.177470,
      2,
      1.416600,
      2.318304,
      0,
      NULL,
      NULL,
      NULL,
      0.420397,
      NULL,
      NULL,
      1,
      0.714400,
      2.043841,
      0,
      NULL,
      NULL,
      0,
      3,
      1.783557,
      NULL,
      0.234023,
      2.137640,
      3,
      3,
      0,
      NULL,
      1,
      0,
      0.687262,
      3.154397,
      NULL,
      0.184921,
      1.343600,
      1,
      2,
      0.909527,
      1.570383,
      11.362828,
      3.839105,
      NULL,
      1.829907,
      1,
      NULL,
      NULL,
      NULL,
      0.897976,
      1.575448,
      2.069793,
      3.076249,
      2,
      2,
      1,
      1.171226,
      0.288128,
      2.387103,
      2,
      0.394457,
      0.765955,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.759944,
      2,
      1,
      1.728823,
      2,
      1.472776,
      1,
      NULL,
      0.778409,
      NULL,
      1.781190,
      NULL,
      NULL,
      0.779285,
      NULL,
      NULL,
      2.747106,
      0.149786,
      0,
      8.225355,
      6.462995,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0.683562,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3.217449,
      3.826650,
      1,
      0,
      0.694816,
      2,
      3,
      2,
      NULL,
      3.952657,
      0,
      2,
      3,
      0.701380,
      NULL,
      2,
      1,
      2.597766,
      0.688644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126142,
      NULL,
      NULL,
      0.950938,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.012497,
      NULL,
      NULL,
      3.083203,
      3,
      1,
      2,
      3.168014,
      1,
      2,
      7,
      5,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.793185,
      1.907320,
      NULL,
      1.580497,
      1,
      NULL,
      0,
      9,
      1,
      1,
      NULL,
      3,
      2,
      1.428795,
      3,
      0.178224,
      NULL,
      2.690081,
      1.803384,
      0.544251,
      1,
      1.177435,
      3.475786,
      NULL,
      2,
      0.499992,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.269136,
      0,
      1,
      1.140198,
      3.748272,
      NULL,
      NULL,
      1.259267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.910177,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.698276,
      NULL,
      NULL,
      1.520517,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.478019,
      NULL,
      NULL,
      3.233847,
      0.821194,
      0,
      0,
      0.983069,
      2.978394,
      1,
      NULL,
      8,
      5.582830,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.554532,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.057767,
      1,
      NULL,
      NULL,
      0.875726,
      NULL,
      NULL,
      NULL,
      2.599426,
      NULL,
      NULL,
      NULL,
      0,
      3.375190,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.487774,
      NULL,
      NULL,
      NULL,
      1.181772,
      3,
      NULL,
      NULL,
      0,
      0.132396,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.251080,
      1.223149,
      NULL,
      NULL,
      1,
      1.133898,
      NULL,
      NULL,
      2.732756,
      1,
      NULL,
      NULL,
      NULL,
      3.313863,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.333993,
      1.077856,
      NULL,
      NULL,
      2.485164,
      NULL,
      NULL,
      NULL,
      1,
      3.722836,
      2,
      4,
      7.555906,
      0,
      NULL,
      407,
      2,
      331.403844,
      38,
      0.985797,
      NULL,
      NULL,
      1.304667,
      5.761221,
      3.896411,
      1.483768,
      NULL,
      NULL,
      NULL,
      9.604556,
      9,
      0.418975,
      NULL,
      1.425313,
      424,
      14,
      0,
      0,
      0.489017,
      0,
      0.363728,
      0,
      1,
      0.311367,
      0,
      3.887600,
      1,
      1,
      1.142097,
      2.182556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      8,
      NULL,
      0,
      29,
      38,
      1.281541,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.914349,
      NULL,
      0.382100,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.874766,
      NULL,
      1.010923,
      NULL,
      1.269598,
      NULL,
      1,
      NULL,
      0.746403,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772579,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115089,
      NULL,
      1,
      NULL,
      608,
      NULL,
      2.577279,
      NULL,
      0,
      NULL,
      3,
      1.465753,
      3.426510,
      22,
      15,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      3,
      2,
      NULL,
      2,
      4.015432,
      NULL,
      3.301970,
      1.818371,
      0,
      0,
      0.630133,
      NULL,
      NULL,
      1,
      0,
      1.279835,
      2.443153,
      0,
      1,
      3,
      NULL,
      0,
      0.010386,
      1.995854,
      1.371983,
      2.365219,
      1.899564,
      2,
      1.792959,
      NULL,
      NULL,
      NULL,
      1.555282,
      1.821015,
      0,
      0.922807,
      1,
      NULL,
      0.415526,
      0,
      0,
      2.434502,
      2.231391,
      1.726276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.407069,
      NULL,
      1.989898,
      0.709277,
      7.928310,
      2,
      0,
      0.329430,
      NULL,
      0,
      14.696729,
      6,
      0,
      3.322503,
      2.437849,
      '12314',
      '04124',
      '44014',
      1,
      '',
      '',
      '',
      3.967943,
      NULL,
      '',
      '');
commit;
end;
/


