set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4011710';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '2331041',
      0,
      1,
      0,
      0,
      '3323',
      1.386854,
      1,
      NULL,
      NULL,
      ' 4-16-1978',
      NULL,
      NULL,
      5.130955,
      3.785398,
      1,
      ' 8-25-1982',
      NULL,
      3,
      100.284952,
      113,
      0.775913,
      ' 0-18-1983',
      ' 2-15-1984',
      ' 9-23-1975',
      3,
      3,
      0,
      1.884201,
      1.657873,
      1,
      NULL,
      NULL,
      1.795796,
      365.182326,
      0.524947,
      9,
      NULL,
      NULL,
      144,
      2,
      1.437303,
      2,
      NULL,
      8.538727,
      0.097067,
      0,
      1.799539,
      NULL,
      1,
      0,
      1.766235,
      1,
      1.463222,
      NULL,
      NULL,
      14.410006,
      NULL,
      7.665515,
      2,
      0.903976,
      1.673940,
      1.883763,
      1,
      1.139439,
      0,
      0.569284,
      0,
      1,
      0.174245,
      1,
      1.501900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.105161,
      NULL,
      NULL,
      0.406092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779200,
      0,
      NULL,
      1,
      1,
      1.620601,
      5.167879,
      0.685288,
      1,
      0,
      NULL,
      7,
      1.266824,
      5,
      NULL,
      0.027368,
      NULL,
      1,
      0.802352,
      NULL,
      NULL,
      1.038246,
      5,
      1.558609,
      0,
      1,
      7.406991,
      1,
      0,
      NULL,
      0.379856,
      1,
      NULL,
      NULL,
      0,
      0,
      9,
      3,
      6.461005,
      NULL,
      2,
      1,
      NULL,
      2.992695,
      7.223814,
      2.681792,
      6.259653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.915157,
      NULL,
      NULL,
      4,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.660944,
      0,
      NULL,
      1,
      1.321977,
      NULL,
      NULL,
      NULL,
      0.652471,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.814148,
      0,
      0,
      1.051661,
      3,
      0,
      3,
      17125.714746,
      0.965309,
      0.713900,
      NULL,
      NULL,
      NULL,
      3.365663,
      0,
      NULL,
      2.220600,
      2,
      2.503220,
      1.920276,
      3.079792,
      2,
      0,
      3,
      3,
      NULL,
      NULL,
      10,
      16,
      NULL,
      NULL,
      27.620272,
      43.969362,
      NULL,
      187,
      80.556897,
      40,
      16,
      27.630083,
      136,
      NULL,
      0,
      15,
      5,
      NULL,
      1,
      7,
      0,
      1,
      1.307719,
      NULL,
      0,
      1,
      5,
      1.567098,
      0.393140,
      NULL,
      5.669565,
      0,
      2.567118,
      NULL,
      47,
      NULL,
      11,
      2.293937,
      1,
      3.060995,
      '00003',
      '',
      '',
      3.378078,
      '14204',
      '',
      '',
      3,
      '31213',
      '20441',
      '',
      2,
      11,
      140,
      0.487822,
      0.674559,
      5.960124,
      2,
      110,
      11,
      1,
      NULL,
      NULL,
      0.592720,
      NULL,
      NULL,
      0.257694,
      NULL,
      NULL,
      1.599531,
      NULL,
      NULL,
      1.507044,
      NULL,
      NULL,
      0.698175,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.258464,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.486575,
      NULL,
      NULL,
      1.692927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272251,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.757051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665689,
      NULL,
      NULL,
      0.110281,
      NULL,
      NULL,
      3.332834,
      2.971041,
      1,
      0.593850,
      NULL,
      NULL,
      5.246802,
      4.552673,
      6.703743,
      1,
      1.819941,
      3.072648,
      0.773601,
      NULL,
      NULL,
      2,
      1.205375,
      5,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.830405,
      NULL,
      NULL,
      0.091475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      6.250997,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5.709627,
      NULL,
      NULL,
      NULL,
      1,
      2.673183,
      NULL,
      2.444395,
      NULL,
      NULL,
      3,
      NULL,
      6,
      0,
      NULL,
      NULL,
      0.375698,
      NULL,
      NULL,
      2.836055,
      1,
      2.490146,
      0,
      1.475947,
      NULL,
      3,
      7,
      NULL,
      2.526137,
      1.976183,
      7.374183,
      NULL,
      NULL,
      NULL,
      0,
      1.310188,
      0,
      0.904069,
      0.618735,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.368849,
      NULL,
      1.861810,
      0.567572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323610,
      NULL,
      NULL,
      NULL,
      0,
      91,
      238.307885,
      0.829660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      116.622679,
      NULL,
      NULL,
      NULL,
      NULL,
      2.541783,
      241.028581,
      44,
      2.117701,
      68,
      3.459599,
      304.109994,
      39.471559,
      1,
      1,
      NULL,
      1.071846,
      1,
      0.886269,
      0,
      NULL,
      0.181620,
      0.586711,
      1.280832,
      0,
      1,
      1,
      1.957098,
      1.259124,
      1,
      0.559253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.803364,
      5.064073,
      5,
      3,
      5.512084,
      3,
      1.589272,
      18.534296,
      2.114120,
      1.570539,
      1.381927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005227,
      NULL,
      NULL,
      0.177415,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.476054,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.495573,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.869471,
      NULL,
      NULL,
      0,
      1.725481,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579282,
      NULL,
      0,
      NULL,
      1.690484,
      NULL,
      NULL,
      NULL,
      4.131252,
      0.072256,
      NULL,
      NULL,
      NULL,
      66,
      3,
      0.608046,
      3.165742,
      '00034',
      '',
      '',
      3.929756,
      '32230',
      '',
      '',
      NULL,
      '03421',
      '02231',
      NULL);
commit;
end;
/


