set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766685';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      0.243244,
      0.011907,
      2,
      1.646606,
      0,
      2.781120,
      3.187015,
      NULL,
      '43332401',
      53.068731,
      51,
      '3143310',
      2,
      0,
      2,
      2,
      '2324',
      3,
      1.653998,
      NULL,
      NULL,
      NULL,
      40.731735,
      113.294710,
      NULL,
      2.652131,
      6.731100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.699211,
      '10- 2-1983',
      ' 8-18-1993',
      ' 0-28-1986',
      0.905843,
      3,
      NULL,
      1,
      0.205452,
      3.311411,
      NULL,
      NULL,
      0.003878,
      5.613730,
      11.351624,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.873869,
      0.866779,
      NULL,
      NULL,
      1.419095,
      1.983151,
      0,
      0.795979,
      NULL,
      0,
      2,
      3,
      0.408770,
      NULL,
      0.534081,
      1.231832,
      NULL,
      0.292985,
      9.641980,
      0.235140,
      1,
      NULL,
      2.544239,
      1,
      6,
      1,
      0.300374,
      0,
      0.627828,
      1,
      2.053894,
      0,
      NULL,
      0,
      0,
      1.581978,
      NULL,
      NULL,
      0.442087,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1.816954,
      0,
      0.335422,
      1.304097,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      3.391395,
      0.453841,
      2.396624,
      NULL,
      NULL,
      1,
      1.678552,
      3,
      1.072969,
      0.423753,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      2.904422,
      0,
      4,
      4,
      9.609772,
      0,
      0,
      1.842804,
      NULL,
      NULL,
      0.788116,
      7.404579,
      0,
      0.360745,
      1.080089,
      0,
      1,
      NULL,
      NULL,
      1,
      1.500455,
      0,
      0,
      1.558746,
      NULL,
      NULL,
      1.810731,
      1.432931,
      0,
      1,
      0.251231,
      2,
      1.393440,
      1,
      10,
      8.549168,
      NULL,
      9.090487,
      5.956120,
      NULL,
      8,
      2,
      2.317073,
      0.622223,
      1.188276,
      1.930960,
      '11-20-1975',
      44.311205,
      ' 9- 3-1990',
      NULL,
      3,
      1,
      1.532017,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.648152,
      1,
      1,
      3.008211,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      329,
      0.705022,
      1.684496,
      3,
      NULL,
      3.871605,
      1.211227,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780604,
      0.526229,
      1,
      NULL,
      NULL,
      1.957088,
      1,
      NULL,
      NULL,
      NULL,
      0.269553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.088877,
      1,
      1.751637,
      0.065679,
      0,
      1.964559,
      1.483854,
      NULL,
      2.948339,
      0.960201,
      NULL,
      NULL,
      NULL,
      1.057237,
      0,
      3,
      1,
      NULL,
      2,
      3.825333,
      2.480027,
      1.118394,
      NULL,
      3.038873,
      2,
      0.254853,
      3,
      2,
      NULL,
      5,
      1,
      1,
      4,
      0,
      0.297181,
      0,
      0,
      NULL,
      7,
      0.795488,
      1.216795,
      0,
      1,
      2,
      0.638519,
      8.822781,
      1,
      NULL,
      5.929669,
      NULL,
      0,
      4,
      1.573430,
      2,
      3,
      3,
      0.565868,
      8,
      0.823504,
      2,
      4,
      NULL,
      11,
      40.047235,
      5.948268,
      3.454332,
      NULL,
      '41013',
      '',
      '',
      1.047151,
      '',
      '',
      '',
      1.623106,
      '',
      '',
      '',
      0,
      91.463058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559500,
      9.085665,
      0.288812,
      0.364274,
      2.228764,
      0,
      0.616285,
      NULL,
      NULL,
      NULL,
      0.210769,
      0.220101,
      1.682678,
      NULL,
      NULL,
      1.469413,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      11,
      5.905159,
      1,
      1.773490,
      0.758364,
      1,
      0,
      0,
      1,
      2,
      1,
      0.617902,
      NULL,
      0,
      0,
      1,
      0,
      1.955285,
      0.456025,
      3,
      NULL,
      0.959042,
      NULL,
      0.945470,
      NULL,
      0.099140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.524969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055013,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.545621,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698893,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      0.800503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1.721687,
      0,
      1.818390,
      1.404311,
      3,
      2.809241,
      1.300707,
      1.900652,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900442,
      NULL,
      1.080989,
      0,
      NULL,
      1.109471,
      1.793667,
      NULL,
      NULL,
      0.535253,
      NULL,
      0.910838,
      0,
      NULL,
      1.720358,
      0.611113,
      NULL,
      0.004857,
      0.872675,
      NULL,
      1.722757,
      3.050033,
      NULL,
      NULL,
      0.712748,
      NULL,
      3.445971,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161476,
      NULL,
      1.129502,
      NULL,
      1,
      NULL,
      2.626487,
      3,
      5,
      NULL,
      NULL,
      NULL,
      10,
      143.975211,
      1,
      2.591287,
      0,
      '14320',
      '',
      '',
      1.462444,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


