set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402430';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '3441240',
      2,
      1.841763,
      NULL,
      NULL,
      '0004',
      3,
      NULL,
      NULL,
      NULL,
      ' 8-14-2003',
      5.852808,
      NULL,
      1.836125,
      2,
      1.191429,
      ' 1-29-1991',
      6,
      3.561744,
      251,
      NULL,
      1.131152,
      ' 6- 3-1988',
      NULL,
      ' 2-24-1986',
      0,
      3,
      0.499247,
      1.683049,
      3.380937,
      NULL,
      5.248837,
      1,
      0.715637,
      467,
      1.411047,
      NULL,
      2,
      NULL,
      17,
      4,
      6,
      7.608253,
      NULL,
      3.767368,
      0,
      0,
      3,
      0,
      1,
      1,
      1,
      0,
      0.425859,
      1.201024,
      1,
      2.175532,
      NULL,
      NULL,
      3,
      3.751318,
      0.643643,
      2.390053,
      1.252297,
      5.001361,
      5.740696,
      3,
      1.180949,
      NULL,
      NULL,
      NULL,
      1.816808,
      7.944427,
      NULL,
      2,
      NULL,
      0.063515,
      1.724093,
      NULL,
      NULL,
      1.527605,
      NULL,
      NULL,
      0.984895,
      0,
      1,
      1,
      3,
      1.501741,
      NULL,
      2,
      1,
      1.548326,
      1,
      NULL,
      0,
      0,
      0.328692,
      3.386297,
      1,
      1,
      1,
      3.168600,
      3,
      1,
      2.525244,
      0,
      0.018201,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      6.738466,
      NULL,
      1,
      6.917715,
      9.130377,
      6.486971,
      8.092421,
      0,
      3.985786,
      5,
      3.282410,
      4,
      3,
      0,
      0.530050,
      0,
      0.812300,
      2,
      1,
      1.272333,
      1.520312,
      9,
      NULL,
      1.427410,
      6.637986,
      8,
      NULL,
      1,
      5.202272,
      5.623420,
      1,
      3.990418,
      7.097316,
      5.588647,
      7,
      7,
      2,
      8,
      0.481555,
      3.069648,
      7,
      2.563081,
      1.864046,
      6,
      0,
      NULL,
      NULL,
      ' 7- 9-2002',
      1113.468435,
      ' 8- 7-2001',
      108,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.327849,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.613903,
      0.796385,
      3.917701,
      2,
      0,
      1.687145,
      NULL,
      3,
      0,
      1.047141,
      1,
      0.784643,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.675225,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.630558,
      1.913360,
      0.846545,
      0,
      1,
      NULL,
      2.367255,
      125,
      2.470601,
      3.526900,
      145,
      101,
      549.085691,
      NULL,
      0.239927,
      0.812827,
      1.781873,
      1,
      3.723173,
      0.562688,
      3,
      3.197623,
      NULL,
      1.869688,
      0,
      NULL,
      0.631979,
      NULL,
      3.532934,
      5,
      1,
      0.257426,
      2.643498,
      NULL,
      1.180800,
      1.816534,
      1,
      0,
      3,
      1,
      NULL,
      1.499908,
      0,
      2,
      NULL,
      0,
      7.895358,
      1,
      6.089692,
      3.597511,
      NULL,
      4.064178,
      2,
      6,
      1.736670,
      1.186207,
      2.312627,
      29.538840,
      1,
      1.271859,
      NULL,
      55,
      23.770326,
      NULL,
      1.056721,
      NULL,
      2.658605,
      '30333',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2,
      '3344',
      '',
      '',
      3.146321,
      8.230953,
      NULL,
      38,
      3.328579,
      34.854025,
      NULL,
      57,
      2,
      0,
      1.014679,
      1,
      1.192592,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1.433364,
      2.502699,
      2.633163,
      3,
      1.773845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.052175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      4,
      2,
      1.286185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.197130,
      NULL,
      0.471840,
      NULL,
      NULL,
      11.004195,
      NULL,
      NULL,
      NULL,
      2,
      0.733669,
      1.208922,
      NULL,
      0.673895,
      1.487942,
      1,
      0,
      2.557346,
      1.184060,
      0,
      2.994226,
      NULL,
      1,
      1.824472,
      3.787503,
      0.410354,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.583211,
      2,
      5,
      1,
      5,
      1.380275,
      0,
      NULL,
      NULL,
      NULL,
      1.175210,
      NULL,
      NULL,
      NULL,
      0.891948,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.666098,
      NULL,
      1,
      1,
      NULL,
      NULL,
      7.882544,
      3,
      0,
      0.707121,
      1.626130,
      3.902576,
      3.518091,
      1,
      0,
      7,
      NULL,
      0,
      1.414855,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.039769,
      NULL,
      NULL,
      0,
      0.634770,
      0,
      0.093765,
      0.730657,
      NULL,
      2.551832,
      7,
      5,
      2.547653,
      NULL,
      0,
      2.402525,
      NULL,
      4.549402,
      2,
      3.241789,
      1.011926,
      0.218626,
      2.031316,
      0,
      3,
      0,
      0.609404,
      5.194445,
      1.678099,
      1,
      1,
      0,
      1,
      3,
      3,
      0.648231,
      1.608136,
      1,
      0,
      0,
      0.054096,
      NULL,
      3,
      2.925970,
      7,
      NULL,
      NULL,
      3.758943,
      0,
      4,
      1,
      1,
      0.371813,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.157442,
      NULL,
      NULL,
      1.539409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201808,
      NULL,
      NULL,
      1.911419,
      NULL,
      NULL,
      0.162252,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811691,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.256710,
      0,
      3.876440,
      1.705544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.466024,
      NULL,
      NULL,
      NULL,
      0.142225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135369,
      NULL,
      NULL,
      NULL,
      0.609342,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.128097,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.159796,
      NULL,
      NULL,
      NULL,
      1.101158,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.690958,
      NULL,
      NULL,
      NULL,
      0,
      297,
      NULL,
      0.789696,
      1.070070,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279421,
      NULL,
      NULL,
      2.848454,
      NULL,
      3.441889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      351.112178,
      NULL,
      0.065228,
      1.277932,
      1,
      0.409707,
      0.625233,
      1.917751,
      NULL,
      1,
      0.231342,
      0.310335,
      0,
      1,
      1.525954,
      0.154155,
      1.416800,
      NULL,
      NULL,
      0.147830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886783,
      3,
      4,
      6.687000,
      0.827726,
      0.103282,
      0.698230,
      2.546450,
      14,
      1,
      1,
      1.672948,
      NULL,
      0.278021,
      NULL,
      0,
      1.632382,
      NULL,
      0.804831,
      1.445443,
      NULL,
      0,
      0.487295,
      NULL,
      NULL,
      0,
      NULL,
      1.958443,
      1,
      NULL,
      0.719846,
      1,
      NULL,
      1,
      0.726921,
      NULL,
      0.775314,
      1,
      NULL,
      3.655705,
      3.093418,
      NULL,
      0.958389,
      1.179676,
      NULL,
      0,
      1.049405,
      1.305154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.174522,
      NULL,
      0.744679,
      NULL,
      NULL,
      8.210830,
      11,
      1.758754,
      NULL,
      0,
      65.615231,
      2,
      NULL,
      1,
      2.441681,
      '44211',
      '',
      '',
      0.682726,
      NULL,
      '',
      '',
      2,
      NULL,
      NULL,
      NULL);
commit;
end;
/


