set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.445133,
      1,
      0,
      '3034',
      1,
      NULL,
      NULL,
      NULL,
      ' 8-17-1981',
      9,
      NULL,
      NULL,
      NULL,
      3,
      ' 2-21-1984',
      14.585681,
      3,
      275.537132,
      23.599984,
      3.030213,
      NULL,
      NULL,
      ' 3-18-1990',
      0.443555,
      0,
      1.663022,
      0.951829,
      0.158618,
      1,
      0.282130,
      1,
      NULL,
      NULL,
      NULL,
      8.950522,
      0.150383,
      10.355399,
      6,
      3,
      10,
      1,
      3,
      4,
      1,
      0.076623,
      1.809674,
      1.672437,
      0.786414,
      NULL,
      NULL,
      0,
      0.328393,
      1,
      NULL,
      3.452260,
      4,
      2.845367,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      6,
      5,
      5.940016,
      1.368663,
      5,
      8.880657,
      NULL,
      4.714399,
      NULL,
      NULL,
      1,
      NULL,
      0.530399,
      NULL,
      NULL,
      0.238946,
      NULL,
      NULL,
      NULL,
      7.882496,
      NULL,
      2.281057,
      0,
      0,
      2.129537,
      1.626660,
      0.946836,
      3,
      NULL,
      0.324691,
      2,
      0,
      2.854856,
      NULL,
      0.934203,
      1,
      NULL,
      7,
      1,
      1.185573,
      3,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221034,
      4,
      1.662286,
      2,
      3.831267,
      0.634810,
      1,
      0,
      NULL,
      NULL,
      0,
      1.611666,
      0,
      NULL,
      1.795643,
      NULL,
      0.640151,
      1.950428,
      1.983113,
      NULL,
      0.021716,
      0,
      NULL,
      0,
      1,
      1.362501,
      0.362426,
      0,
      NULL,
      1.105657,
      0,
      1,
      0,
      0.705544,
      1.028531,
      0,
      5,
      1,
      NULL,
      7,
      5.338800,
      1.958026,
      0,
      NULL,
      1.351283,
      3.287619,
      1.047259,
      3,
      ' 9- 8-1993',
      NULL,
      ' 6-13-1989',
      NULL,
      0,
      0,
      0,
      0.014997,
      1.460277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.603242,
      1.086270,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.201470,
      0.145670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.811219,
      NULL,
      1,
      1,
      1.360075,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904368,
      0.288129,
      NULL,
      1.354012,
      NULL,
      1.785135,
      1,
      1.478896,
      NULL,
      1.946016,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.258479,
      3,
      0,
      4,
      0.676407,
      2,
      0.397622,
      4.141449,
      0.444638,
      2,
      2,
      2,
      1.896086,
      2,
      3.326069,
      1.415069,
      1,
      NULL,
      2,
      0.251504,
      0,
      0.737886,
      1.023435,
      1,
      1,
      0,
      1.929042,
      NULL,
      0,
      0,
      NULL,
      10.996798,
      5.295483,
      2.320404,
      6.459901,
      5,
      6,
      1,
      3,
      3.797070,
      0.325884,
      1,
      3.604021,
      41.384244,
      NULL,
      1,
      91.841770,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412409,
      2.103055,
      '30112',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.429029,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.196039,
      1.077315,
      0,
      NULL,
      NULL,
      0.754472,
      NULL,
      NULL,
      1.143494,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.013788,
      3.828402,
      1.609221,
      0,
      2.094341,
      NULL,
      1.580589,
      3.683873,
      1.914041,
      3.260819,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      2.615779,
      NULL,
      0,
      NULL,
      1,
      NULL,
      9.161239,
      6,
      0.542342,
      0.233913,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.995827,
      3,
      NULL,
      3,
      1,
      0,
      1.441249,
      NULL,
      NULL,
      1.992245,
      NULL,
      1,
      NULL,
      0.285936,
      1.890194,
      1,
      0,
      1,
      2,
      1.168520,
      3.957471,
      2,
      1,
      2.828517,
      0.820887,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.085441,
      NULL,
      NULL,
      NULL,
      1,
      1.914831,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.922398,
      NULL,
      NULL,
      NULL,
      1.270709,
      1.886028,
      1,
      NULL,
      NULL,
      1.090316,
      NULL,
      NULL,
      5,
      1,
      1,
      1,
      NULL,
      NULL,
      1.363974,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.037094,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.347624,
      NULL,
      NULL,
      0.548011,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.356628,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3.984344,
      5,
      1,
      3.660734,
      0.248751,
      NULL,
      0,
      1,
      NULL,
      2.474213,
      2.380205,
      1.228522,
      0.488301,
      2.413101,
      3,
      6,
      5,
      1.402122,
      NULL,
      NULL,
      3,
      0,
      0,
      1.572146,
      0.301326,
      1,
      0.110150,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.947761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.885980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0.486022,
      0.148313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293870,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.839502,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794313,
      NULL,
      NULL,
      2.527228,
      NULL,
      0.149635,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.495850,
      NULL,
      NULL,
      401.576869,
      1,
      0.755128,
      0,
      1,
      1.940639,
      0.819541,
      0.406610,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.333786,
      1.673559,
      0.045676,
      0.880323,
      1,
      1,
      0.286663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      6,
      1,
      5.221735,
      2.575791,
      4.134110,
      0.638300,
      0,
      3.519505,
      1.861227,
      1.345151,
      0,
      NULL,
      1.268337,
      2.961745,
      NULL,
      1.976496,
      2,
      NULL,
      1.798333,
      3.046042,
      NULL,
      0.654147,
      2.274456,
      NULL,
      0,
      NULL,
      NULL,
      1.067727,
      1,
      NULL,
      NULL,
      1.278535,
      NULL,
      0.543484,
      0,
      NULL,
      1.970427,
      0,
      NULL,
      0.698146,
      0,
      NULL,
      0.936532,
      1.229464,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361649,
      NULL,
      0.423273,
      NULL,
      0,
      NULL,
      0.495799,
      2,
      2.404979,
      0.279420,
      NULL,
      NULL,
      20,
      58,
      2,
      NULL,
      0.268076,
      '03412',
      '',
      '',
      1.783738,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


