set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6605896';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00',
      '40',
      NULL,
      35.272746,
      NULL,
      1,
      0,
      1,
      1,
      '4303',
      1,
      1.389864,
      NULL,
      NULL,
      ' 8-23-1981',
      138,
      35,
      NULL,
      0,
      1,
      ' 8-14-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      4.869313,
      NULL,
      NULL,
      ' 1- 1-1989',
      3,
      1,
      1,
      0,
      1.121116,
      0.662594,
      2.765706,
      1.263983,
      NULL,
      NULL,
      NULL,
      8,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574781,
      NULL,
      NULL,
      1.581958,
      1.460410,
      2.817537,
      3,
      1.427093,
      0,
      0,
      NULL,
      NULL,
      0.720666,
      NULL,
      0.260950,
      2.724309,
      3,
      0.212699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.243339,
      2,
      NULL,
      2,
      1.391299,
      1.066528,
      3.249698,
      3,
      3,
      NULL,
      2.541734,
      NULL,
      NULL,
      NULL,
      1.516429,
      NULL,
      4.022473,
      1.049518,
      0.676431,
      1,
      0.891996,
      0.388848,
      0.332619,
      0.269324,
      NULL,
      3.048120,
      NULL,
      0.484149,
      1,
      2.709799,
      0,
      1,
      1.298420,
      6.259653,
      3.507192,
      NULL,
      1.897484,
      0,
      3,
      0,
      1,
      NULL,
      2.674531,
      0,
      23.467021,
      NULL,
      NULL,
      NULL,
      5.351697,
      1.699691,
      1.801418,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      0,
      '20312',
      '',
      '',
      1,
      7.663711,
      195.206445,
      15.036919,
      0.649147,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.093968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.386676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.523636,
      NULL,
      1.580039,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.225030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9.061329,
      1.532255,
      1,
      1.146085,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.518963,
      0.137958,
      0.195963,
      3.462420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959787,
      NULL,
      NULL,
      1.398761,
      NULL,
      NULL,
      3.477839,
      2,
      0.275802,
      7.446737,
      8,
      1,
      2,
      0.280816,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.728687,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.653171,
      NULL,
      NULL,
      2,
      1,
      0.073633,
      1.827003,
      3.935506,
      1.788412,
      2.104659,
      0.233537,
      1.327962,
      NULL,
      4,
      NULL,
      1.708392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.974514,
      NULL,
      NULL,
      1.994624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.345660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.965166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.139253,
      0.998515,
      3.381609,
      3,
      0.944765,
      1.024106,
      3.278728,
      1,
      NULL,
      0.379794,
      1,
      2.244223,
      NULL,
      1.003351,
      0.797240,
      NULL,
      NULL,
      1.556280,
      1.139029,
      NULL,
      6,
      4.529887,
      0,
      1.254095,
      NULL,
      0.895226,
      0,
      3.601753,
      1.112377,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.957181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.893247,
      NULL,
      NULL,
      3.014267,
      NULL,
      NULL,
      3.803071,
      NULL,
      NULL,
      3,
      0.367376,
      3.719938,
      0.766032,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8,
      NULL,
      9,
      NULL,
      1.216409,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.444113,
      NULL,
      NULL,
      NULL,
      1.951028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.462054,
      NULL,
      1.489451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740182,
      NULL,
      1.845312,
      NULL,
      1,
      NULL,
      1.596274,
      NULL,
      2.684242,
      NULL,
      NULL,
      NULL,
      1.922778,
      NULL,
      0.654687,
      NULL,
      0,
      NULL,
      0.566640,
      NULL,
      1.333428,
      NULL,
      3,
      NULL,
      3.615940,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.409625,
      NULL,
      0.727647,
      NULL,
      3.988957,
      NULL,
      3,
      NULL,
      5.981988,
      NULL,
      11.229082,
      NULL,
      1,
      2.769176,
      NULL,
      1.256264,
      NULL,
      0.445141,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555543,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867620,
      266.518164,
      1,
      1.129575,
      0.851495,
      0.360464,
      1,
      1,
      1.616507,
      1.951441,
      0,
      NULL,
      0.519864,
      0,
      1,
      NULL,
      1.512677,
      1.669217,
      1.712592,
      1.097026,
      1.123306,
      NULL,
      0.417853,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.485173,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      31,
      13.870283,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.798963,
      NULL,
      0,
      NULL,
      1.288019,
      NULL,
      0,
      NULL,
      1.712824,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.292506,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.984814,
      1.935246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.159425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689150,
      1.787331,
      NULL,
      0.151291,
      NULL,
      1,
      NULL,
      6.210057,
      NULL,
      3.108598,
      NULL,
      0.271700,
      NULL,
      2.682322,
      NULL,
      1,
      1.452983,
      1.622950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912946,
      0.026471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708766,
      2.463414,
      NULL,
      2.274255,
      NULL,
      0.474027,
      NULL,
      NULL,
      NULL,
      0.004881,
      NULL,
      0.491367,
      NULL,
      1,
      1,
      0.822708,
      0.224833,
      4.447462,
      0.314761,
      NULL,
      NULL,
      NULL,
      1,
      1.755041,
      2.265994,
      7,
      0.371341,
      0.202124,
      4.613481,
      3.075145,
      4.861912,
      1.380812,
      NULL,
      3.497744,
      NULL,
      0,
      1,
      1.841499,
      0.391838,
      0,
      0.546057,
      1,
      1.388937,
      0.391804,
      1.919907,
      NULL,
      0,
      1.458527,
      1,
      0.194985,
      0.215327,
      0.826158,
      1.134223,
      0,
      1.560289,
      NULL,
      1.785248,
      NULL,
      0,
      1,
      0.940213,
      0.945469,
      NULL,
      1.157308,
      1,
      1,
      1,
      3.782505,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.580021,
      1,
      0.703873,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0.653685,
      1,
      1,
      1,
      NULL,
      0.793179,
      0,
      1.039647,
      0,
      NULL,
      NULL,
      0,
      3,
      1.294849,
      1,
      33,
      NULL,
      17,
      0,
      1.523454,
      1.134909,
      0.473595,
      NULL,
      1,
      2,
      6.492409,
      8,
      0,
      NULL,
      NULL,
      33.682711,
      117.892630,
      NULL,
      NULL,
      3,
      '12000',
      '04121',
      '34113',
      0.732819,
      '',
      '',
      '',
      0.279357,
      NULL,
      '01414',
      '20242');
commit;
end;
/


