set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9680781';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      '42',
      14.063474,
      23.574663,
      '2000300',
      3,
      1.949575,
      2,
      1,
      '2322',
      NULL,
      0,
      NULL,
      NULL,
      ' 0-10-1975',
      30,
      5,
      NULL,
      1.733654,
      1,
      ' 1-20-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10-20-1978',
      ' 1- 2-1987',
      ' 7-24-1984',
      2,
      3.755646,
      2,
      1.348909,
      1,
      NULL,
      2.116696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.822835,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298847,
      1.628167,
      NULL,
      1.640893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.239413,
      1.165985,
      3.011246,
      7,
      0.735628,
      1.523208,
      1.794505,
      NULL,
      NULL,
      1.353231,
      0.074180,
      1.917377,
      0,
      1.534398,
      0.592242,
      3,
      0.139069,
      NULL,
      0.574093,
      1,
      1.862244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.424780,
      1.822524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      0,
      0.110667,
      0.086918,
      NULL,
      NULL,
      1.299970,
      NULL,
      NULL,
      1.055333,
      7,
      4,
      NULL,
      NULL,
      1.599049,
      1.338136,
      0.757252,
      0.480823,
      0.605971,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      1.636385,
      1.501210,
      5.415994,
      6.490838,
      NULL,
      NULL,
      5,
      3,
      0.566863,
      6,
      0,
      3.717775,
      6,
      5.393589,
      2,
      2.388347,
      3,
      11.572300,
      0,
      NULL,
      NULL,
      0,
      1,
      0.287764,
      ' 2-27-1993',
      409.390303,
      ' 5- 8-2000',
      152,
      3.374065,
      5.881444,
      0.100026,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019995,
      0,
      0,
      1.365984,
      0.904007,
      0.267472,
      0.640084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330151,
      1,
      NULL,
      1,
      0,
      0.165387,
      0.614797,
      NULL,
      NULL,
      NULL,
      1.214103,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.318039,
      0,
      0.295654,
      1,
      3,
      85.945140,
      2.892225,
      0.392963,
      NULL,
      NULL,
      NULL,
      1,
      1.582286,
      0.713978,
      0.330241,
      1.628412,
      3,
      3.476944,
      1,
      2,
      1.892665,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      5,
      1,
      1.664538,
      1,
      1,
      0,
      1.943409,
      1,
      0,
      1.359749,
      0,
      1,
      NULL,
      NULL,
      2,
      1.896445,
      6,
      4.372521,
      NULL,
      3.522868,
      0.346536,
      NULL,
      3.190621,
      1.068584,
      4.826457,
      1,
      3.086099,
      2.554660,
      11.506225,
      2.226096,
      NULL,
      21,
      NULL,
      33.151916,
      19,
      3.235591,
      4,
      3.319201,
      '21122',
      NULL,
      '',
      1.479926,
      '',
      '',
      '',
      0.710918,
      '',
      '',
      '',
      1.141623,
      32.226572,
      144,
      11.186613,
      NULL,
      13,
      NULL,
      13,
      3,
      NULL,
      NULL,
      3.541060,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.278879,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.914807,
      NULL,
      NULL,
      0.818259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.896141,
      NULL,
      NULL,
      4.637682,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059258,
      NULL,
      NULL,
      NULL,
      2.875056,
      0.830935,
      1.568670,
      0.901489,
      NULL,
      NULL,
      1.419417,
      NULL,
      NULL,
      3.186593,
      1.846111,
      NULL,
      3.430510,
      1,
      NULL,
      1.949776,
      1,
      2.111808,
      1.473250,
      NULL,
      1.721747,
      1.628823,
      0,
      0.384858,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.570706,
      1,
      0.793461,
      1.915699,
      7.946859,
      4.344040,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.404193,
      NULL,
      NULL,
      2,
      NULL,
      0.417412,
      NULL,
      0,
      0.685608,
      1,
      0.193267,
      NULL,
      4.318559,
      1,
      0,
      2.941937,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.176378,
      5.092832,
      1.355675,
      1.054541,
      NULL,
      NULL,
      0.427759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2,
      0,
      7,
      NULL,
      NULL,
      7.166186,
      4.739643,
      2.146397,
      3,
      NULL,
      NULL,
      0.734480,
      3.548570,
      1,
      2.056170,
      NULL,
      2.543142,
      2,
      3,
      1.665585,
      NULL,
      3.700004,
      2,
      1.589261,
      2,
      3.139452,
      3,
      NULL,
      2.295591,
      0.945308,
      1,
      NULL,
      NULL,
      3.386759,
      3,
      1.647270,
      5.776845,
      1,
      7.358075,
      2,
      4.933808,
      3,
      NULL,
      1.024772,
      NULL,
      0,
      0.369187,
      1.460362,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.151692,
      NULL,
      NULL,
      0.009530,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.859863,
      NULL,
      0,
      NULL,
      NULL,
      5.172572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.852533,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.744339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      57,
      14,
      2.637942,
      57,
      6,
      0,
      NULL,
      NULL,
      1.627274,
      NULL,
      NULL,
      0.373262,
      NULL,
      NULL,
      1.406284,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1148.784676,
      NULL,
      0,
      1,
      1.581441,
      0,
      0.019099,
      1.437122,
      1.863384,
      0,
      1,
      1,
      1.562844,
      1,
      NULL,
      1.414228,
      0.054998,
      1.846624,
      1,
      1.228298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.638456,
      3.264178,
      2.342480,
      7,
      0,
      3,
      3,
      0.098613,
      15,
      2.023767,
      NULL,
      1.243154,
      0.973510,
      0,
      NULL,
      0,
      1.033771,
      NULL,
      1.508688,
      0.623064,
      NULL,
      1.556305,
      NULL,
      NULL,
      0.273052,
      0,
      NULL,
      0,
      0,
      NULL,
      2.764860,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.435353,
      NULL,
      1.851432,
      2,
      NULL,
      1.371048,
      0.302218,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365013,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.057239,
      1.599124,
      3.561894,
      NULL,
      1.006983,
      2,
      6.272293,
      3,
      NULL,
      1,
      2.498156,
      '41214',
      '',
      '',
      1.824472,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


