set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8321532';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1432301',
      1.125737,
      0,
      3,
      1,
      '4430',
      2,
      NULL,
      NULL,
      7.779834,
      ' 8-29-1993',
      3.251872,
      NULL,
      5.781938,
      0.662704,
      0.085364,
      ' 1-23-1990',
      10.426685,
      0,
      216.600157,
      NULL,
      1,
      NULL,
      NULL,
      '10-13-1990',
      0.099352,
      0,
      1,
      1,
      0,
      3.322727,
      3,
      1,
      1,
      164,
      NULL,
      4,
      8,
      NULL,
      NULL,
      2,
      22,
      10.202406,
      1,
      0.099221,
      NULL,
      1,
      1.563839,
      NULL,
      1,
      0,
      1.565981,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      7.477922,
      NULL,
      2,
      NULL,
      0.579337,
      0,
      1,
      NULL,
      4.692687,
      NULL,
      0,
      0,
      1.097424,
      3,
      5,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      1.616371,
      NULL,
      NULL,
      0,
      0.753543,
      0,
      1.031376,
      0,
      1.046362,
      0,
      NULL,
      0,
      0,
      1,
      1.122363,
      1.862219,
      1,
      2,
      0,
      0,
      NULL,
      1.696784,
      NULL,
      NULL,
      1.339947,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.066982,
      3.544029,
      3.440085,
      2.737939,
      NULL,
      0,
      0.575370,
      NULL,
      NULL,
      1.138284,
      1.605309,
      0,
      0.032249,
      1.375355,
      0,
      0,
      NULL,
      0,
      3.842754,
      3.247319,
      3,
      1.343493,
      0,
      6.090518,
      0.815278,
      NULL,
      2.122512,
      4.328317,
      5.375673,
      2,
      2.443045,
      0,
      NULL,
      NULL,
      6.855502,
      7,
      1.811363,
      0.471277,
      4,
      0,
      6,
      3,
      0.725837,
      NULL,
      NULL,
      ' 5-28-1997',
      923,
      ' 1-13-2002',
      NULL,
      1,
      NULL,
      NULL,
      2.384860,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.152462,
      0,
      NULL,
      3.005053,
      4.239592,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.308236,
      1,
      7,
      0,
      7,
      0.292774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.636867,
      0.395790,
      1.346638,
      1.532902,
      1,
      NULL,
      1,
      NULL,
      0,
      1.826082,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.467595,
      0,
      NULL,
      NULL,
      1.378120,
      NULL,
      0.350996,
      1,
      2.902565,
      3,
      2,
      NULL,
      8.820452,
      12.773734,
      5.496919,
      1,
      1,
      2.618330,
      NULL,
      1.814708,
      1,
      0.884715,
      1.144090,
      1,
      NULL,
      1,
      1.788326,
      1.344817,
      0.690105,
      0,
      8.446202,
      1.035352,
      1,
      3.661355,
      NULL,
      3.222796,
      NULL,
      2,
      NULL,
      2.725299,
      1.229662,
      2.840083,
      NULL,
      1,
      0.544968,
      12.125613,
      NULL,
      NULL,
      NULL,
      2.332505,
      1,
      1,
      '22010',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      3,
      16.211042,
      229,
      29.961775,
      NULL,
      NULL,
      2.084020,
      5.020270,
      0.515805,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.305774,
      3,
      1.955493,
      0,
      NULL,
      NULL,
      1.091848,
      NULL,
      NULL,
      NULL,
      2,
      2.053130,
      0.759519,
      NULL,
      NULL,
      NULL,
      NULL,
      0.972333,
      3.273512,
      2,
      0,
      0,
      NULL,
      NULL,
      0.765605,
      1,
      0,
      7.329941,
      0.986278,
      1.563595,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.909811,
      1,
      NULL,
      NULL,
      0.916014,
      NULL,
      NULL,
      2,
      0.691216,
      NULL,
      NULL,
      0.152815,
      1,
      0,
      0.149418,
      1,
      0.821328,
      0.621210,
      0,
      0,
      3.963854,
      0.873802,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.394660,
      5,
      5.709113,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716564,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0.497295,
      3,
      3,
      NULL,
      1.075573,
      1.714903,
      0.094943,
      NULL,
      NULL,
      3.994356,
      0,
      3,
      1.507135,
      NULL,
      NULL,
      NULL,
      1.506598,
      NULL,
      1,
      3,
      4,
      0.618724,
      NULL,
      NULL,
      0.057212,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.053862,
      0,
      0,
      NULL,
      NULL,
      5,
      0.829271,
      1,
      3,
      0.288604,
      NULL,
      2,
      1.391492,
      2,
      NULL,
      2,
      11.272074,
      6.978013,
      7.881695,
      5,
      NULL,
      0.517900,
      7,
      1,
      1,
      0,
      NULL,
      0,
      1.154265,
      2.420528,
      0.015301,
      2,
      NULL,
      3.481384,
      3,
      2,
      1.462160,
      1.544226,
      1,
      1,
      NULL,
      3.766185,
      3.141136,
      0,
      1,
      NULL,
      2,
      8.920498,
      1.849884,
      NULL,
      7.807579,
      NULL,
      8.576457,
      NULL,
      3,
      8,
      0.793856,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374240,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.440130,
      NULL,
      NULL,
      1.470617,
      NULL,
      NULL,
      2.282798,
      NULL,
      NULL,
      0.066770,
      NULL,
      NULL,
      2.111473,
      NULL,
      NULL,
      7.679281,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      1.118442,
      8,
      NULL,
      1.524391,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.417571,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.214833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.865684,
      NULL,
      2.770415,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.187111,
      NULL,
      1.769034,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.850803,
      NULL,
      2.898012,
      NULL,
      0,
      NULL,
      3.665820,
      NULL,
      2.381310,
      NULL,
      2.156122,
      NULL,
      3,
      NULL,
      3.255508,
      NULL,
      0.025264,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.023867,
      NULL,
      1.607058,
      NULL,
      1.168364,
      NULL,
      NULL,
      NULL,
      2,
      155,
      91.235622,
      0.057793,
      161.062751,
      1.228700,
      1,
      NULL,
      NULL,
      0.170783,
      NULL,
      NULL,
      1,
      12.647472,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.177289,
      0,
      1.988545,
      0,
      1,
      0.078270,
      1.007028,
      0.296489,
      0.172616,
      1,
      NULL,
      0.100959,
      0,
      1,
      1.978782,
      0.733046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203310,
      3,
      2.253875,
      NULL,
      1,
      2.274068,
      1,
      NULL,
      19.494505,
      2,
      NULL,
      3.105499,
      0.323418,
      NULL,
      0.031255,
      3,
      NULL,
      1,
      0.944455,
      3.075159,
      3.521022,
      0.277498,
      NULL,
      1,
      2.527940,
      2,
      3.495698,
      0,
      2.534766,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652668,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.098081,
      2,
      NULL,
      0.714892,
      3.224553,
      0,
      1.712095,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.834257,
      1.511557,
      0.976848,
      0.281401,
      1,
      NULL,
      NULL,
      8.742719,
      NULL,
      3,
      3.341671,
      25,
      10.341984,
      0,
      0,
      1,
      '41134',
      '12433',
      '',
      0.564227,
      '33130',
      '',
      '',
      3.568530,
      '2313',
      '',
      NULL);
commit;
end;
/


